/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.Arrays;
import java.util.Map;
import org.apache.pinot.common.function.AggregationFunctionType;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.BaseSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.core.query.request.context.ExpressionContext;

public class PercentileAggregationFunction
extends BaseSingleInputAggregationFunction<DoubleArrayList, Double> {
    private static final double DEFAULT_FINAL_RESULT = Double.NEGATIVE_INFINITY;
    protected final int _percentile;

    public PercentileAggregationFunction(ExpressionContext expression, int percentile) {
        super(expression);
        this._percentile = percentile;
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.PERCENTILE;
    }

    @Override
    public String getColumnName() {
        return AggregationFunctionType.PERCENTILE.getName() + this._percentile + "_" + this._expression;
    }

    @Override
    public String getResultColumnName() {
        return AggregationFunctionType.PERCENTILE.getName().toLowerCase() + this._percentile + "(" + this._expression + ")";
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        DoubleArrayList valueList = PercentileAggregationFunction.getValueList(aggregationResultHolder);
        double[] valueArray = blockValSetMap.get(this._expression).getDoubleValuesSV();
        for (int i = 0; i < length; ++i) {
            valueList.add(valueArray[i]);
        }
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        double[] valueArray = blockValSetMap.get(this._expression).getDoubleValuesSV();
        for (int i = 0; i < length; ++i) {
            DoubleArrayList valueList = PercentileAggregationFunction.getValueList(groupByResultHolder, groupKeyArray[i]);
            valueList.add(valueArray[i]);
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        double[] valueArray = blockValSetMap.get(this._expression).getDoubleValuesSV();
        for (int i = 0; i < length; ++i) {
            double value = valueArray[i];
            for (int groupKey : groupKeysArray[i]) {
                DoubleArrayList valueList = PercentileAggregationFunction.getValueList(groupByResultHolder, groupKey);
                valueList.add(value);
            }
        }
    }

    @Override
    public DoubleArrayList extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        DoubleArrayList doubleArrayList = (DoubleArrayList)aggregationResultHolder.getResult();
        if (doubleArrayList == null) {
            return new DoubleArrayList();
        }
        return doubleArrayList;
    }

    @Override
    public DoubleArrayList extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        DoubleArrayList doubleArrayList = (DoubleArrayList)groupByResultHolder.getResult(groupKey);
        if (doubleArrayList == null) {
            return new DoubleArrayList();
        }
        return doubleArrayList;
    }

    @Override
    public DoubleArrayList merge(DoubleArrayList intermediateResult1, DoubleArrayList intermediateResult2) {
        intermediateResult1.addAll((DoubleList)intermediateResult2);
        return intermediateResult1;
    }

    @Override
    public boolean isIntermediateResultComparable() {
        return false;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.DOUBLE;
    }

    @Override
    public Double extractFinalResult(DoubleArrayList intermediateResult) {
        int size = intermediateResult.size();
        if (size == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        double[] values = intermediateResult.elements();
        Arrays.sort(values, 0, size);
        if (this._percentile == 100) {
            return values[size - 1];
        }
        return values[(int)((long)size * (long)this._percentile / 100L)];
    }

    protected static DoubleArrayList getValueList(AggregationResultHolder aggregationResultHolder) {
        DoubleArrayList valueList = (DoubleArrayList)aggregationResultHolder.getResult();
        if (valueList == null) {
            valueList = new DoubleArrayList();
            aggregationResultHolder.setValue(valueList);
        }
        return valueList;
    }

    protected static DoubleArrayList getValueList(GroupByResultHolder groupByResultHolder, int groupKey) {
        DoubleArrayList valueList = (DoubleArrayList)groupByResultHolder.getResult(groupKey);
        if (valueList == null) {
            valueList = new DoubleArrayList();
            groupByResultHolder.setValueForKey(groupKey, valueList);
        }
        return valueList;
    }
}

