/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import java.util.Map;
import org.apache.pinot.common.function.AggregationFunctionType;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.MinMaxRangeAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.request.context.ExpressionContext;

public class MinMaxRangeMVAggregationFunction
extends MinMaxRangeAggregationFunction {
    public MinMaxRangeMVAggregationFunction(ExpressionContext expression) {
        super(expression);
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.MINMAXRANGEMV;
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        double[][] valuesArray = blockValSetMap.get(this._expression).getDoubleValuesMV();
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < length; ++i) {
            double[] values;
            for (double value : values = valuesArray[i]) {
                if (value < min) {
                    min = value;
                }
                if (!(value > max)) continue;
                max = value;
            }
        }
        this.setAggregationResult(aggregationResultHolder, min, max);
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        double[][] valuesArray = blockValSetMap.get(this._expression).getDoubleValuesMV();
        for (int i = 0; i < length; ++i) {
            this.aggregateOnGroupKey(groupKeyArray[i], groupByResultHolder, valuesArray[i]);
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        double[][] valuesArray = blockValSetMap.get(this._expression).getDoubleValuesMV();
        for (int i = 0; i < length; ++i) {
            double[] values = valuesArray[i];
            for (int groupKey : groupKeysArray[i]) {
                this.aggregateOnGroupKey(groupKey, groupByResultHolder, values);
            }
        }
    }

    private void aggregateOnGroupKey(int groupKey, GroupByResultHolder groupByResultHolder, double[] values) {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (double value : values) {
            if (value < min) {
                min = value;
            }
            if (!(value > max)) continue;
            max = value;
        }
        this.setGroupByResult(groupKey, groupByResultHolder, min, max);
    }
}

