/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import java.util.Map;
import org.apache.pinot.common.function.AggregationFunctionType;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.BaseSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.customobject.MinMaxRangePair;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.core.query.request.context.ExpressionContext;
import org.apache.pinot.spi.data.FieldSpec;

public class MinMaxRangeAggregationFunction
extends BaseSingleInputAggregationFunction<MinMaxRangePair, Double> {
    public MinMaxRangeAggregationFunction(ExpressionContext expression) {
        super(expression);
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.MINMAXRANGE;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        if (blockValSet.getValueType() != FieldSpec.DataType.BYTES) {
            double[] doubleValues = blockValSet.getDoubleValuesSV();
            for (int i = 0; i < length; ++i) {
                double value = doubleValues[i];
                if (value < min) {
                    min = value;
                }
                if (!(value > max)) continue;
                max = value;
            }
        } else {
            byte[][] bytesValues = blockValSet.getBytesValuesSV();
            for (int i = 0; i < length; ++i) {
                MinMaxRangePair minMaxRangePair = ObjectSerDeUtils.MIN_MAX_RANGE_PAIR_SER_DE.deserialize(bytesValues[i]);
                double minValue = minMaxRangePair.getMin();
                double maxValue = minMaxRangePair.getMax();
                if (minValue < min) {
                    min = minValue;
                }
                if (!(maxValue > max)) continue;
                max = maxValue;
            }
        }
        this.setAggregationResult(aggregationResultHolder, min, max);
    }

    protected void setAggregationResult(AggregationResultHolder aggregationResultHolder, double min, double max) {
        MinMaxRangePair minMaxRangePair = (MinMaxRangePair)aggregationResultHolder.getResult();
        if (minMaxRangePair == null) {
            aggregationResultHolder.setValue(new MinMaxRangePair(min, max));
        } else {
            minMaxRangePair.apply(min, max);
        }
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        if (blockValSet.getValueType() != FieldSpec.DataType.BYTES) {
            double[] doubleValues = blockValSet.getDoubleValuesSV();
            for (int i = 0; i < length; ++i) {
                double value = doubleValues[i];
                this.setGroupByResult(groupKeyArray[i], groupByResultHolder, value, value);
            }
        } else {
            byte[][] bytesValues = blockValSet.getBytesValuesSV();
            for (int i = 0; i < length; ++i) {
                MinMaxRangePair minMaxRangePair = ObjectSerDeUtils.MIN_MAX_RANGE_PAIR_SER_DE.deserialize(bytesValues[i]);
                this.setGroupByResult(groupKeyArray[i], groupByResultHolder, minMaxRangePair.getMin(), minMaxRangePair.getMax());
            }
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        if (blockValSet.getValueType() != FieldSpec.DataType.BYTES) {
            double[] doubleValues = blockValSet.getDoubleValuesSV();
            for (int i = 0; i < length; ++i) {
                double value = doubleValues[i];
                for (int groupKey : groupKeysArray[i]) {
                    this.setGroupByResult(groupKey, groupByResultHolder, value, value);
                }
            }
        } else {
            byte[][] bytesValues = blockValSet.getBytesValuesSV();
            for (int i = 0; i < length; ++i) {
                MinMaxRangePair minMaxRangePair = ObjectSerDeUtils.MIN_MAX_RANGE_PAIR_SER_DE.deserialize(bytesValues[i]);
                double min = minMaxRangePair.getMin();
                double max = minMaxRangePair.getMax();
                for (int groupKey : groupKeysArray[i]) {
                    this.setGroupByResult(groupKey, groupByResultHolder, min, max);
                }
            }
        }
    }

    protected void setGroupByResult(int groupKey, GroupByResultHolder groupByResultHolder, double min, double max) {
        MinMaxRangePair minMaxRangePair = (MinMaxRangePair)groupByResultHolder.getResult(groupKey);
        if (minMaxRangePair == null) {
            groupByResultHolder.setValueForKey(groupKey, new MinMaxRangePair(min, max));
        } else {
            minMaxRangePair.apply(min, max);
        }
    }

    @Override
    public MinMaxRangePair extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        MinMaxRangePair minMaxRangePair = (MinMaxRangePair)aggregationResultHolder.getResult();
        if (minMaxRangePair == null) {
            return new MinMaxRangePair(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
        }
        return minMaxRangePair;
    }

    @Override
    public MinMaxRangePair extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        MinMaxRangePair minMaxRangePair = (MinMaxRangePair)groupByResultHolder.getResult(groupKey);
        if (minMaxRangePair == null) {
            return new MinMaxRangePair(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
        }
        return minMaxRangePair;
    }

    @Override
    public MinMaxRangePair merge(MinMaxRangePair intermediateResult1, MinMaxRangePair intermediateResult2) {
        intermediateResult1.apply(intermediateResult2);
        return intermediateResult1;
    }

    @Override
    public boolean isIntermediateResultComparable() {
        return true;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.DOUBLE;
    }

    @Override
    public Double extractFinalResult(MinMaxRangePair intermediateResult) {
        return intermediateResult.getMax() - intermediateResult.getMin();
    }
}

