/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import java.util.Map;
import org.apache.pinot.common.function.AggregationFunctionType;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.DoubleAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.BaseSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.DoubleGroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.request.context.ExpressionContext;

public class MinAggregationFunction
extends BaseSingleInputAggregationFunction<Double, Double> {
    private static final double DEFAULT_VALUE = Double.POSITIVE_INFINITY;

    public MinAggregationFunction(ExpressionContext expression) {
        super(expression);
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.MIN;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new DoubleAggregationResultHolder(Double.POSITIVE_INFINITY);
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new DoubleGroupByResultHolder(initialCapacity, maxCapacity, Double.POSITIVE_INFINITY);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        double[] valueArray = blockValSetMap.get(this._expression).getDoubleValuesSV();
        double min = aggregationResultHolder.getDoubleResult();
        for (int i = 0; i < length; ++i) {
            double value = valueArray[i];
            if (!(value < min)) continue;
            min = value;
        }
        aggregationResultHolder.setValue(min);
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        double[] valueArray = blockValSetMap.get(this._expression).getDoubleValuesSV();
        for (int i = 0; i < length; ++i) {
            double value = valueArray[i];
            int groupKey = groupKeyArray[i];
            if (!(value < groupByResultHolder.getDoubleResult(groupKey))) continue;
            groupByResultHolder.setValueForKey(groupKey, value);
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        double[] valueArray = blockValSetMap.get(this._expression).getDoubleValuesSV();
        for (int i = 0; i < length; ++i) {
            double value = valueArray[i];
            for (int groupKey : groupKeysArray[i]) {
                if (!(value < groupByResultHolder.getDoubleResult(groupKey))) continue;
                groupByResultHolder.setValueForKey(groupKey, value);
            }
        }
    }

    @Override
    public Double extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        return aggregationResultHolder.getDoubleResult();
    }

    @Override
    public Double extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        return groupByResultHolder.getDoubleResult(groupKey);
    }

    @Override
    public Double merge(Double intermediateResult1, Double intermediateResult2) {
        if (intermediateResult1 < intermediateResult2) {
            return intermediateResult1;
        }
        return intermediateResult2;
    }

    @Override
    public boolean isIntermediateResultComparable() {
        return true;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.DOUBLE;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.DOUBLE;
    }

    @Override
    public Double extractFinalResult(Double intermediateResult) {
        return intermediateResult;
    }
}

