/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import java.util.Map;
import org.apache.pinot.common.function.AggregationFunctionType;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.MaxAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.request.context.ExpressionContext;

public class MaxMVAggregationFunction
extends MaxAggregationFunction {
    public MaxMVAggregationFunction(ExpressionContext expression) {
        super(expression);
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.MAXMV;
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        double[][] valuesArray = blockValSetMap.get(this._expression).getDoubleValuesMV();
        double max = aggregationResultHolder.getDoubleResult();
        for (int i = 0; i < length; ++i) {
            for (double value : valuesArray[i]) {
                if (!(value > max)) continue;
                max = value;
            }
        }
        aggregationResultHolder.setValue(max);
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        double[][] valuesArray = blockValSetMap.get(this._expression).getDoubleValuesMV();
        for (int i = 0; i < length; ++i) {
            int groupKey = groupKeyArray[i];
            double max = groupByResultHolder.getDoubleResult(groupKey);
            for (double value : valuesArray[i]) {
                if (!(value > max)) continue;
                max = value;
            }
            groupByResultHolder.setValueForKey(groupKey, max);
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        double[][] valuesArray = blockValSetMap.get(this._expression).getDoubleValuesMV();
        for (int i = 0; i < length; ++i) {
            double[] values = valuesArray[i];
            for (int groupKey : groupKeysArray[i]) {
                double max = groupByResultHolder.getDoubleResult(groupKey);
                for (double value : values) {
                    if (!(value > max)) continue;
                    max = value;
                }
                groupByResultHolder.setValueForKey(groupKey, max);
            }
        }
    }
}

