/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import com.clearspring.analytics.stream.cardinality.HyperLogLog;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.function.AggregationFunctionType;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.BaseSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.core.query.request.context.ExpressionContext;
import org.apache.pinot.spi.data.FieldSpec;

public class DistinctCountHLLAggregationFunction
extends BaseSingleInputAggregationFunction<HyperLogLog, Long> {
    protected final int _log2m;

    public DistinctCountHLLAggregationFunction(List<ExpressionContext> arguments) {
        super(arguments.get(0));
        int numExpressions = arguments.size();
        Preconditions.checkArgument((numExpressions <= 2 ? 1 : 0) != 0, (String)"DistinctCountHLL expects 1 or 2 arguments, got: %s", (int)numExpressions);
        this._log2m = arguments.size() == 2 ? Integer.parseInt(arguments.get(1).getLiteral()) : 8;
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.DISTINCTCOUNTHLL;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        block19: {
            BlockValSet blockValSet;
            block18: {
                blockValSet = blockValSetMap.get(this._expression);
                FieldSpec.DataType valueType = blockValSet.getValueType();
                if (valueType == FieldSpec.DataType.BYTES) break block18;
                HyperLogLog hyperLogLog = this.getDefaultHyperLogLog(aggregationResultHolder);
                switch (valueType) {
                    case INT: {
                        int[] intValues = blockValSet.getIntValuesSV();
                        for (int i = 0; i < length; ++i) {
                            hyperLogLog.offer((Object)intValues[i]);
                        }
                        break block19;
                    }
                    case LONG: {
                        long[] longValues = blockValSet.getLongValuesSV();
                        for (int i = 0; i < length; ++i) {
                            hyperLogLog.offer((Object)longValues[i]);
                        }
                        break block19;
                    }
                    case FLOAT: {
                        float[] floatValues = blockValSet.getFloatValuesSV();
                        for (int i = 0; i < length; ++i) {
                            hyperLogLog.offer((Object)Float.valueOf(floatValues[i]));
                        }
                        break block19;
                    }
                    case DOUBLE: {
                        double[] doubleValues = blockValSet.getDoubleValuesSV();
                        for (int i = 0; i < length; ++i) {
                            hyperLogLog.offer((Object)doubleValues[i]);
                        }
                        break block19;
                    }
                    case STRING: {
                        String[] stringValues = blockValSet.getStringValuesSV();
                        for (int i = 0; i < length; ++i) {
                            hyperLogLog.offer((Object)stringValues[i]);
                        }
                        break block19;
                    }
                    default: {
                        throw new IllegalStateException("Illegal data type for DISTINCT_COUNT_HLL aggregation function: " + valueType);
                    }
                }
            }
            byte[][] bytesValues = blockValSet.getBytesValuesSV();
            try {
                HyperLogLog hyperLogLog = (HyperLogLog)aggregationResultHolder.getResult();
                if (hyperLogLog != null) {
                    for (int i = 0; i < length; ++i) {
                        hyperLogLog.addAll(ObjectSerDeUtils.HYPER_LOG_LOG_SER_DE.deserialize(bytesValues[i]));
                    }
                } else {
                    hyperLogLog = ObjectSerDeUtils.HYPER_LOG_LOG_SER_DE.deserialize(bytesValues[0]);
                    aggregationResultHolder.setValue(hyperLogLog);
                    for (int i = 1; i < length; ++i) {
                        hyperLogLog.addAll(ObjectSerDeUtils.HYPER_LOG_LOG_SER_DE.deserialize(bytesValues[i]));
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Caught exception while merging HyperLogLogs", e);
            }
        }
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        FieldSpec.DataType valueType = blockValSet.getValueType();
        switch (valueType) {
            case INT: {
                int[] intValues = blockValSet.getIntValuesSV();
                for (int i = 0; i < length; ++i) {
                    this.getDefaultHyperLogLog(groupByResultHolder, groupKeyArray[i]).offer((Object)intValues[i]);
                }
                break;
            }
            case LONG: {
                long[] longValues = blockValSet.getLongValuesSV();
                for (int i = 0; i < length; ++i) {
                    this.getDefaultHyperLogLog(groupByResultHolder, groupKeyArray[i]).offer((Object)longValues[i]);
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = blockValSet.getFloatValuesSV();
                for (int i = 0; i < length; ++i) {
                    this.getDefaultHyperLogLog(groupByResultHolder, groupKeyArray[i]).offer((Object)Float.valueOf(floatValues[i]));
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = blockValSet.getDoubleValuesSV();
                for (int i = 0; i < length; ++i) {
                    this.getDefaultHyperLogLog(groupByResultHolder, groupKeyArray[i]).offer((Object)doubleValues[i]);
                }
                break;
            }
            case STRING: {
                String[] stringValues = blockValSet.getStringValuesSV();
                for (int i = 0; i < length; ++i) {
                    this.getDefaultHyperLogLog(groupByResultHolder, groupKeyArray[i]).offer((Object)stringValues[i]);
                }
                break;
            }
            case BYTES: {
                byte[][] bytesValues = blockValSet.getBytesValuesSV();
                try {
                    for (int i = 0; i < length; ++i) {
                        HyperLogLog value = ObjectSerDeUtils.HYPER_LOG_LOG_SER_DE.deserialize(bytesValues[i]);
                        int groupKey = groupKeyArray[i];
                        HyperLogLog hyperLogLog = (HyperLogLog)groupByResultHolder.getResult(groupKey);
                        if (hyperLogLog != null) {
                            hyperLogLog.addAll(value);
                            continue;
                        }
                        groupByResultHolder.setValueForKey(groupKey, value);
                    }
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException("Caught exception while merging HyperLogLogs", e);
                }
            }
            default: {
                throw new IllegalStateException("Illegal data type for DISTINCT_COUNT_HLL aggregation function: " + valueType);
            }
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        FieldSpec.DataType valueType = blockValSet.getValueType();
        switch (valueType) {
            case INT: {
                int[] intValues = blockValSet.getIntValuesSV();
                for (int i = 0; i < length; ++i) {
                    int value = intValues[i];
                    for (int groupKey : groupKeysArray[i]) {
                        this.getDefaultHyperLogLog(groupByResultHolder, groupKey).offer((Object)value);
                    }
                }
                break;
            }
            case LONG: {
                long[] longValues = blockValSet.getLongValuesSV();
                for (int i = 0; i < length; ++i) {
                    long value = longValues[i];
                    for (int groupKey : groupKeysArray[i]) {
                        this.getDefaultHyperLogLog(groupByResultHolder, groupKey).offer((Object)value);
                    }
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = blockValSet.getFloatValuesSV();
                for (int i = 0; i < length; ++i) {
                    float value = floatValues[i];
                    for (int groupKey : groupKeysArray[i]) {
                        this.getDefaultHyperLogLog(groupByResultHolder, groupKey).offer((Object)Float.valueOf(value));
                    }
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = blockValSet.getDoubleValuesSV();
                for (int i = 0; i < length; ++i) {
                    double value = doubleValues[i];
                    for (int groupKey : groupKeysArray[i]) {
                        this.getDefaultHyperLogLog(groupByResultHolder, groupKey).offer((Object)value);
                    }
                }
                break;
            }
            case STRING: {
                String[] stringValues = blockValSet.getStringValuesSV();
                for (int i = 0; i < length; ++i) {
                    String value = stringValues[i];
                    for (int groupKey : groupKeysArray[i]) {
                        this.getDefaultHyperLogLog(groupByResultHolder, groupKey).offer((Object)value);
                    }
                }
                break;
            }
            case BYTES: {
                byte[][] bytesValues = blockValSet.getBytesValuesSV();
                try {
                    for (int i = 0; i < length; ++i) {
                        HyperLogLog value = ObjectSerDeUtils.HYPER_LOG_LOG_SER_DE.deserialize(bytesValues[i]);
                        for (int groupKey : groupKeysArray[i]) {
                            HyperLogLog hyperLogLog = (HyperLogLog)groupByResultHolder.getResult(groupKey);
                            if (hyperLogLog != null) {
                                hyperLogLog.addAll(value);
                                continue;
                            }
                            groupByResultHolder.setValueForKey(groupKey, ObjectSerDeUtils.HYPER_LOG_LOG_SER_DE.deserialize(bytesValues[i]));
                        }
                    }
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException("Caught exception while merging HyperLogLogs", e);
                }
            }
            default: {
                throw new IllegalStateException("Illegal data type for DISTINCT_COUNT_HLL aggregation function: " + valueType);
            }
        }
    }

    @Override
    public HyperLogLog extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        HyperLogLog hyperLogLog = (HyperLogLog)aggregationResultHolder.getResult();
        if (hyperLogLog == null) {
            return new HyperLogLog(this._log2m);
        }
        return hyperLogLog;
    }

    @Override
    public HyperLogLog extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        HyperLogLog hyperLogLog = (HyperLogLog)groupByResultHolder.getResult(groupKey);
        if (hyperLogLog == null) {
            return new HyperLogLog(this._log2m);
        }
        return hyperLogLog;
    }

    @Override
    public HyperLogLog merge(HyperLogLog intermediateResult1, HyperLogLog intermediateResult2) {
        if (intermediateResult1.sizeof() != intermediateResult2.sizeof()) {
            if (intermediateResult1.cardinality() == 0L) {
                return intermediateResult2;
            }
            Preconditions.checkState((intermediateResult2.cardinality() == 0L ? 1 : 0) != 0, (Object)"Cannot merge HyperLogLogs of different sizes");
            return intermediateResult1;
        }
        try {
            intermediateResult1.addAll(intermediateResult2);
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while merging HyperLogLogs", e);
        }
        return intermediateResult1;
    }

    @Override
    public boolean isIntermediateResultComparable() {
        return false;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.LONG;
    }

    @Override
    public Long extractFinalResult(HyperLogLog intermediateResult) {
        return intermediateResult.cardinality();
    }

    protected HyperLogLog getDefaultHyperLogLog(AggregationResultHolder aggregationResultHolder) {
        HyperLogLog hyperLogLog = (HyperLogLog)aggregationResultHolder.getResult();
        if (hyperLogLog == null) {
            hyperLogLog = new HyperLogLog(this._log2m);
            aggregationResultHolder.setValue(hyperLogLog);
        }
        return hyperLogLog;
    }

    protected HyperLogLog getDefaultHyperLogLog(GroupByResultHolder groupByResultHolder, int groupKey) {
        HyperLogLog hyperLogLog = (HyperLogLog)groupByResultHolder.getResult(groupKey);
        if (hyperLogLog == null) {
            hyperLogLog = new HyperLogLog(this._log2m);
            groupByResultHolder.setValueForKey(groupKey, hyperLogLog);
        }
        return hyperLogLog;
    }
}

