/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.function.AggregationFunctionType;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.RowBasedBlockValueFetcher;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.core.query.aggregation.function.customobject.DistinctTable;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.request.context.ExpressionContext;
import org.apache.pinot.core.query.request.context.OrderByExpressionContext;
import org.apache.pinot.spi.data.FieldSpec;

public class DistinctAggregationFunction
implements AggregationFunction<DistinctTable, Comparable> {
    private final List<ExpressionContext> _expressions;
    private final String[] _columns;
    private final List<OrderByExpressionContext> _orderByExpressions;
    private final int _limit;

    public DistinctAggregationFunction(List<ExpressionContext> expressions, @Nullable List<OrderByExpressionContext> orderByExpressions, int limit) {
        this._expressions = expressions;
        int numExpressions = expressions.size();
        this._columns = new String[numExpressions];
        for (int i = 0; i < numExpressions; ++i) {
            this._columns[i] = expressions.get(i).toString();
        }
        this._orderByExpressions = orderByExpressions;
        this._limit = limit;
    }

    public String[] getColumns() {
        return this._columns;
    }

    public List<OrderByExpressionContext> getOrderByExpressions() {
        return this._orderByExpressions;
    }

    public int getLimit() {
        return this._limit;
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.DISTINCT;
    }

    @Override
    public String getColumnName() {
        return AggregationFunctionType.DISTINCT.getName() + "_" + AggregationFunctionUtils.concatArgs(this._columns);
    }

    @Override
    public String getResultColumnName() {
        return AggregationFunctionType.DISTINCT.getName().toLowerCase() + "(" + AggregationFunctionUtils.concatArgs(this._columns) + ")";
    }

    @Override
    public List<ExpressionContext> getInputExpressions() {
        return this._expressions;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        RowBasedBlockValueFetcher blockValueFetcher;
        int numExpressions;
        int numBlockValSets = blockValSetMap.size();
        Preconditions.checkState((numBlockValSets == (numExpressions = this._expressions.size()) ? 1 : 0) != 0, (String)"Size mismatch: numBlockValSets = %s, numExpressions = %s", (int)numBlockValSets, (int)numExpressions);
        BlockValSet[] blockValSets = new BlockValSet[numExpressions];
        for (int i = 0; i < numExpressions; ++i) {
            blockValSets[i] = blockValSetMap.get(this._expressions.get(i));
        }
        DistinctTable distinctTable = (DistinctTable)aggregationResultHolder.getResult();
        if (distinctTable == null) {
            DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numExpressions];
            for (int i = 0; i < numExpressions; ++i) {
                columnDataTypes[i] = DataSchema.ColumnDataType.fromDataTypeSV((FieldSpec.DataType)blockValSetMap.get(this._expressions.get(i)).getValueType());
            }
            DataSchema dataSchema = new DataSchema(this._columns, columnDataTypes);
            distinctTable = new DistinctTable(dataSchema, this._orderByExpressions, this._limit);
            aggregationResultHolder.setValue(distinctTable);
        }
        if (distinctTable.hasOrderBy()) {
            blockValueFetcher = new RowBasedBlockValueFetcher(blockValSets);
            for (int i = 0; i < length; ++i) {
                distinctTable.addWithOrderBy(new Record(blockValueFetcher.getRow(i)));
            }
        } else {
            if (distinctTable.isSatisfied()) {
                return;
            }
            blockValueFetcher = new RowBasedBlockValueFetcher(blockValSets);
            for (int i = 0; i < length; ++i) {
                if (!distinctTable.addWithoutOrderBy(new Record(blockValueFetcher.getRow(i)))) continue;
                return;
            }
        }
    }

    @Override
    public DistinctTable extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        DistinctTable distinctTable = (DistinctTable)aggregationResultHolder.getResult();
        if (distinctTable != null) {
            return distinctTable;
        }
        Object[] columnDataTypes = new DataSchema.ColumnDataType[this._columns.length];
        Arrays.fill(columnDataTypes, DataSchema.ColumnDataType.STRING);
        return new DistinctTable(new DataSchema(this._columns, (DataSchema.ColumnDataType[])columnDataTypes), this._orderByExpressions, this._limit);
    }

    @Override
    public DistinctTable merge(DistinctTable intermediateResult1, DistinctTable intermediateResult2) {
        if (intermediateResult1.size() == 0) {
            return intermediateResult2;
        }
        if (intermediateResult2.size() != 0) {
            intermediateResult1.mergeMainDistinctTable(intermediateResult2);
        }
        return intermediateResult1;
    }

    @Override
    public boolean isIntermediateResultComparable() {
        return false;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        throw new UnsupportedOperationException("Operation not supported for DISTINCT aggregation function");
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        throw new UnsupportedOperationException("Operation not supported for DISTINCT aggregation function");
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        throw new UnsupportedOperationException("Operation not supported for DISTINCT aggregation function");
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        throw new UnsupportedOperationException("Operation not supported for DISTINCT aggregation function");
    }

    @Override
    public DistinctTable extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        throw new UnsupportedOperationException("Operation not supported for DISTINCT aggregation function");
    }

    @Override
    public Comparable extractFinalResult(DistinctTable intermediateResult) {
        throw new UnsupportedOperationException("Operation not supported for DISTINCT aggregation function");
    }
}

