/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.function.AggregationFunctionType;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.CountAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.request.context.ExpressionContext;

public class CountMVAggregationFunction
extends CountAggregationFunction {
    private final ExpressionContext _expression;

    public CountMVAggregationFunction(ExpressionContext expression) {
        this._expression = expression;
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.COUNTMV;
    }

    @Override
    public String getColumnName() {
        return AggregationFunctionType.COUNTMV.getName() + "_" + this._expression;
    }

    @Override
    public String getResultColumnName() {
        return AggregationFunctionType.COUNTMV.getName().toLowerCase() + "(" + this._expression + ")";
    }

    @Override
    public List<ExpressionContext> getInputExpressions() {
        return Collections.singletonList(this._expression);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        int[] valueArray = blockValSetMap.get(this._expression).getNumMVEntries();
        long count = 0L;
        for (int i = 0; i < length; ++i) {
            count += (long)valueArray[i];
        }
        aggregationResultHolder.setValue(aggregationResultHolder.getDoubleResult() + (double)count);
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        int[] valueArray = blockValSetMap.get(this._expression).getNumMVEntries();
        for (int i = 0; i < length; ++i) {
            int groupKey = groupKeyArray[i];
            groupByResultHolder.setValueForKey(groupKey, groupByResultHolder.getDoubleResult(groupKey) + (double)valueArray[i]);
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        int[] valueArray = blockValSetMap.get(this._expression).getNumMVEntries();
        for (int i = 0; i < length; ++i) {
            int value = valueArray[i];
            for (int groupKey : groupKeysArray[i]) {
                groupByResultHolder.setValueForKey(groupKey, groupByResultHolder.getDoubleResult(groupKey) + (double)value);
            }
        }
    }
}

