/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.function.AggregationFunctionType;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AvgAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AvgMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.CountAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.CountMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountBitmapAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountBitmapMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountHLLAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountHLLMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountRawHLLAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountRawHLLMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountRawThetaSketchAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountThetaSketchAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.FastHLLAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.IdSetAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.MaxAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.MaxMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.MinAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.MinMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.MinMaxRangeAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.MinMaxRangeMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.PercentileAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.PercentileEstAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.PercentileEstMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.PercentileMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.PercentileTDigestAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.PercentileTDigestMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.SegmentPartitionedDistinctCountAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.StUnionAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.SumAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.SumMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.SumPrecisionAggregationFunction;
import org.apache.pinot.core.query.exception.BadQueryRequestException;
import org.apache.pinot.core.query.request.context.ExpressionContext;
import org.apache.pinot.core.query.request.context.FunctionContext;
import org.apache.pinot.core.query.request.context.QueryContext;

public class AggregationFunctionFactory {
    private AggregationFunctionFactory() {
    }

    public static AggregationFunction getAggregationFunction(FunctionContext function, QueryContext queryContext) {
        try {
            String upperCaseFunctionName = StringUtils.remove((String)function.getFunctionName(), (char)'_').toUpperCase();
            List<ExpressionContext> arguments = function.getArguments();
            ExpressionContext firstArgument = arguments.get(0);
            if (upperCaseFunctionName.startsWith("PERCENTILE")) {
                String remainingFunctionName = upperCaseFunctionName.substring(10);
                int numArguments = arguments.size();
                if (numArguments == 1) {
                    if (remainingFunctionName.matches("\\d+")) {
                        return new PercentileAggregationFunction(firstArgument, AggregationFunctionFactory.parsePercentile(remainingFunctionName));
                    }
                    if (remainingFunctionName.matches("EST\\d+")) {
                        String percentileString = remainingFunctionName.substring(3);
                        return new PercentileEstAggregationFunction(firstArgument, AggregationFunctionFactory.parsePercentile(percentileString));
                    }
                    if (remainingFunctionName.matches("TDIGEST\\d+")) {
                        String percentileString = remainingFunctionName.substring(7);
                        return new PercentileTDigestAggregationFunction(firstArgument, AggregationFunctionFactory.parsePercentile(percentileString));
                    }
                    if (remainingFunctionName.matches("\\d+MV")) {
                        String percentileString = remainingFunctionName.substring(0, remainingFunctionName.length() - 2);
                        return new PercentileMVAggregationFunction(firstArgument, AggregationFunctionFactory.parsePercentile(percentileString));
                    }
                    if (remainingFunctionName.matches("EST\\d+MV")) {
                        String percentileString = remainingFunctionName.substring(3, remainingFunctionName.length() - 2);
                        return new PercentileEstMVAggregationFunction(firstArgument, AggregationFunctionFactory.parsePercentile(percentileString));
                    }
                    if (remainingFunctionName.matches("TDIGEST\\d+MV")) {
                        String percentileString = remainingFunctionName.substring(7, remainingFunctionName.length() - 2);
                        return new PercentileTDigestMVAggregationFunction(firstArgument, AggregationFunctionFactory.parsePercentile(percentileString));
                    }
                } else if (numArguments == 2) {
                    int percentile = AggregationFunctionFactory.parsePercentile(arguments.get(1).getLiteral());
                    if (remainingFunctionName.isEmpty()) {
                        return new PercentileAggregationFunction(firstArgument, percentile);
                    }
                    if (remainingFunctionName.equals("EST")) {
                        return new PercentileEstAggregationFunction(firstArgument, percentile);
                    }
                    if (remainingFunctionName.equals("TDIGEST")) {
                        return new PercentileTDigestAggregationFunction(firstArgument, percentile);
                    }
                    if (remainingFunctionName.equals("MV")) {
                        return new PercentileMVAggregationFunction(firstArgument, percentile);
                    }
                    if (remainingFunctionName.equals("ESTMV")) {
                        return new PercentileEstMVAggregationFunction(firstArgument, percentile);
                    }
                    if (remainingFunctionName.equals("TDIGESTMV")) {
                        return new PercentileTDigestMVAggregationFunction(firstArgument, percentile);
                    }
                }
                throw new IllegalArgumentException("Invalid percentile function: " + function);
            }
            switch (AggregationFunctionType.valueOf((String)upperCaseFunctionName)) {
                case COUNT: {
                    return new CountAggregationFunction();
                }
                case MIN: {
                    return new MinAggregationFunction(firstArgument);
                }
                case MAX: {
                    return new MaxAggregationFunction(firstArgument);
                }
                case SUM: {
                    return new SumAggregationFunction(firstArgument);
                }
                case SUMPRECISION: {
                    return new SumPrecisionAggregationFunction(arguments);
                }
                case AVG: {
                    return new AvgAggregationFunction(firstArgument);
                }
                case MINMAXRANGE: {
                    return new MinMaxRangeAggregationFunction(firstArgument);
                }
                case DISTINCTCOUNT: {
                    return new DistinctCountAggregationFunction(firstArgument);
                }
                case DISTINCTCOUNTBITMAP: {
                    return new DistinctCountBitmapAggregationFunction(firstArgument);
                }
                case SEGMENTPARTITIONEDDISTINCTCOUNT: {
                    return new SegmentPartitionedDistinctCountAggregationFunction(firstArgument);
                }
                case DISTINCTCOUNTHLL: {
                    return new DistinctCountHLLAggregationFunction(arguments);
                }
                case DISTINCTCOUNTRAWHLL: {
                    return new DistinctCountRawHLLAggregationFunction(arguments);
                }
                case FASTHLL: {
                    return new FastHLLAggregationFunction(firstArgument);
                }
                case DISTINCTCOUNTTHETASKETCH: {
                    return new DistinctCountThetaSketchAggregationFunction(arguments);
                }
                case DISTINCTCOUNTRAWTHETASKETCH: {
                    return new DistinctCountRawThetaSketchAggregationFunction(arguments);
                }
                case IDSET: {
                    return new IdSetAggregationFunction(arguments);
                }
                case COUNTMV: {
                    return new CountMVAggregationFunction(firstArgument);
                }
                case MINMV: {
                    return new MinMVAggregationFunction(firstArgument);
                }
                case MAXMV: {
                    return new MaxMVAggregationFunction(firstArgument);
                }
                case SUMMV: {
                    return new SumMVAggregationFunction(firstArgument);
                }
                case AVGMV: {
                    return new AvgMVAggregationFunction(firstArgument);
                }
                case MINMAXRANGEMV: {
                    return new MinMaxRangeMVAggregationFunction(firstArgument);
                }
                case DISTINCTCOUNTMV: {
                    return new DistinctCountMVAggregationFunction(firstArgument);
                }
                case DISTINCTCOUNTBITMAPMV: {
                    return new DistinctCountBitmapMVAggregationFunction(firstArgument);
                }
                case DISTINCTCOUNTHLLMV: {
                    return new DistinctCountHLLMVAggregationFunction(arguments);
                }
                case DISTINCTCOUNTRAWHLLMV: {
                    return new DistinctCountRawHLLMVAggregationFunction(arguments);
                }
                case DISTINCT: {
                    return new DistinctAggregationFunction(arguments, queryContext.getOrderByExpressions(), queryContext.getLimit());
                }
                case STUNION: {
                    return new StUnionAggregationFunction(firstArgument);
                }
            }
            throw new IllegalArgumentException();
        }
        catch (Exception e) {
            throw new BadQueryRequestException("Invalid aggregation function: " + function);
        }
    }

    private static int parsePercentile(String percentileString) {
        int percentile = Integer.parseInt(percentileString);
        Preconditions.checkArgument((percentile >= 0 && percentile <= 100 ? 1 : 0) != 0, (String)"Invalid percentile: %s", (int)percentile);
        return percentile;
    }
}

