/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan.maker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.pinot.common.function.AggregationFunctionType;
import org.apache.pinot.common.proto.Server;
import org.apache.pinot.core.indexsegment.IndexSegment;
import org.apache.pinot.core.plan.AggregationGroupByOrderByPlanNode;
import org.apache.pinot.core.plan.AggregationGroupByPlanNode;
import org.apache.pinot.core.plan.AggregationPlanNode;
import org.apache.pinot.core.plan.CombinePlanNode;
import org.apache.pinot.core.plan.DictionaryBasedAggregationPlanNode;
import org.apache.pinot.core.plan.GlobalPlanImplV0;
import org.apache.pinot.core.plan.InstanceResponsePlanNode;
import org.apache.pinot.core.plan.MetadataBasedAggregationPlanNode;
import org.apache.pinot.core.plan.Plan;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.plan.SelectionPlanNode;
import org.apache.pinot.core.plan.StreamingSelectionPlanNode;
import org.apache.pinot.core.plan.maker.PlanMaker;
import org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.core.query.config.QueryExecutorConfig;
import org.apache.pinot.core.query.request.context.ExpressionContext;
import org.apache.pinot.core.query.request.context.FunctionContext;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.utils.QueryContextUtils;
import org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.core.util.QueryOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstancePlanMakerImplV2
implements PlanMaker {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstancePlanMakerImplV2.class);
    public static final String MAX_INITIAL_RESULT_HOLDER_CAPACITY_KEY = "max.init.group.holder.capacity";
    public static final int DEFAULT_MAX_INITIAL_RESULT_HOLDER_CAPACITY = 10000;
    public static final String NUM_GROUPS_LIMIT = "num.groups.limit";
    public static final int DEFAULT_NUM_GROUPS_LIMIT = 100000;
    private final int _maxInitialResultHolderCapacity;
    private final int _numGroupsLimit;

    @VisibleForTesting
    public InstancePlanMakerImplV2() {
        this._maxInitialResultHolderCapacity = 10000;
        this._numGroupsLimit = 100000;
    }

    @VisibleForTesting
    public InstancePlanMakerImplV2(int maxInitialResultHolderCapacity, int numGroupsLimit) {
        this._maxInitialResultHolderCapacity = maxInitialResultHolderCapacity;
        this._numGroupsLimit = numGroupsLimit;
    }

    public InstancePlanMakerImplV2(QueryExecutorConfig queryExecutorConfig) {
        this._maxInitialResultHolderCapacity = queryExecutorConfig.getConfig().getProperty(MAX_INITIAL_RESULT_HOLDER_CAPACITY_KEY, 10000);
        this._numGroupsLimit = queryExecutorConfig.getConfig().getProperty(NUM_GROUPS_LIMIT, 100000);
        Preconditions.checkState((this._maxInitialResultHolderCapacity <= this._numGroupsLimit ? 1 : 0) != 0, (String)"Invalid configuration: maxInitialResultHolderCapacity: %d must be smaller or equal to numGroupsLimit: %d", (int)this._maxInitialResultHolderCapacity, (int)this._numGroupsLimit);
        LOGGER.info("Initializing plan maker with maxInitialResultHolderCapacity: {}, numGroupsLimit: {}", (Object)this._maxInitialResultHolderCapacity, (Object)this._numGroupsLimit);
    }

    @Override
    public Plan makeInstancePlan(List<IndexSegment> indexSegments, QueryContext queryContext, ExecutorService executorService, long endTimeMs) {
        ArrayList<PlanNode> planNodes = new ArrayList<PlanNode>(indexSegments.size());
        for (IndexSegment indexSegment : indexSegments) {
            planNodes.add(this.makeSegmentPlanNode(indexSegment, queryContext));
        }
        CombinePlanNode combinePlanNode = new CombinePlanNode(planNodes, queryContext, executorService, endTimeMs, this._numGroupsLimit, null);
        return new GlobalPlanImplV0(new InstanceResponsePlanNode(combinePlanNode));
    }

    @Override
    public PlanNode makeSegmentPlanNode(IndexSegment indexSegment, QueryContext queryContext) {
        if (QueryContextUtils.isAggregationQuery(queryContext)) {
            List<ExpressionContext> groupByExpressions = queryContext.getGroupByExpressions();
            if (groupByExpressions != null) {
                QueryOptions queryOptions = new QueryOptions(queryContext.getQueryOptions());
                if (queryOptions.isGroupByModeSQL()) {
                    return new AggregationGroupByOrderByPlanNode(indexSegment, queryContext, this._maxInitialResultHolderCapacity, this._numGroupsLimit);
                }
                return new AggregationGroupByPlanNode(indexSegment, queryContext, this._maxInitialResultHolderCapacity, this._numGroupsLimit);
            }
            if (queryContext.getFilter() == null && indexSegment.getValidDocIndex() == null) {
                if (InstancePlanMakerImplV2.isFitForMetadataBasedPlan(queryContext)) {
                    return new MetadataBasedAggregationPlanNode(indexSegment, queryContext);
                }
                if (InstancePlanMakerImplV2.isFitForDictionaryBasedPlan(queryContext, indexSegment)) {
                    return new DictionaryBasedAggregationPlanNode(indexSegment, queryContext);
                }
            }
            return new AggregationPlanNode(indexSegment, queryContext);
        }
        return new SelectionPlanNode(indexSegment, queryContext);
    }

    @Override
    public Plan makeStreamingInstancePlan(List<IndexSegment> indexSegments, QueryContext queryContext, ExecutorService executorService, StreamObserver<Server.ServerResponse> streamObserver, long endTimeMs) {
        ArrayList<PlanNode> planNodes = new ArrayList<PlanNode>(indexSegments.size());
        for (IndexSegment indexSegment : indexSegments) {
            planNodes.add(this.makeStreamingSegmentPlanNode(indexSegment, queryContext));
        }
        CombinePlanNode combinePlanNode = new CombinePlanNode(planNodes, queryContext, executorService, endTimeMs, this._numGroupsLimit, streamObserver);
        return new GlobalPlanImplV0(new InstanceResponsePlanNode(combinePlanNode));
    }

    @Override
    public PlanNode makeStreamingSegmentPlanNode(IndexSegment indexSegment, QueryContext queryContext) {
        if (QueryContextUtils.isAggregationQuery(queryContext)) {
            throw new UnsupportedOperationException("Queries with aggregations are not supported");
        }
        return new StreamingSelectionPlanNode(indexSegment, queryContext);
    }

    @VisibleForTesting
    static boolean isFitForMetadataBasedPlan(QueryContext queryContext) {
        List<ExpressionContext> selectExpressions = queryContext.getSelectExpressions();
        for (ExpressionContext expression : selectExpressions) {
            if (expression.getFunction().getFunctionName().equals("count")) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    static boolean isFitForDictionaryBasedPlan(QueryContext queryContext, IndexSegment indexSegment) {
        List<ExpressionContext> selectExpressions = queryContext.getSelectExpressions();
        for (ExpressionContext expression : selectExpressions) {
            FunctionContext function = expression.getFunction();
            String functionName = function.getFunctionName();
            if (!AggregationFunctionUtils.isFitForDictionaryBasedComputation(functionName)) {
                return false;
            }
            ExpressionContext argument = function.getArguments().get(0);
            if (argument.getType() != ExpressionContext.Type.IDENTIFIER) {
                return false;
            }
            String column = argument.getIdentifier();
            Dictionary dictionary = indexSegment.getDataSource(column).getDictionary();
            if (dictionary == null) {
                return false;
            }
            if (dictionary.isSorted() || functionName.equalsIgnoreCase(AggregationFunctionType.DISTINCTCOUNT.name()) || functionName.equalsIgnoreCase(AggregationFunctionType.SEGMENTPARTITIONEDDISTINCTCOUNT.name())) continue;
            return false;
        }
        return true;
    }
}

