/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan;

import java.util.Collection;
import java.util.HashSet;
import org.apache.pinot.core.indexsegment.IndexSegment;
import org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.plan.ProjectionPlanNode;
import org.apache.pinot.core.query.request.context.ExpressionContext;
import org.apache.pinot.core.query.request.context.QueryContext;

public class TransformPlanNode
implements PlanNode {
    private final Collection<ExpressionContext> _expressions;
    private final ProjectionPlanNode _projectionPlanNode;

    public TransformPlanNode(IndexSegment indexSegment, QueryContext queryContext, Collection<ExpressionContext> expressions, int maxDocsPerCall) {
        this._expressions = expressions;
        HashSet<String> projectionColumns = new HashSet<String>();
        for (ExpressionContext expression : expressions) {
            expression.getColumns(projectionColumns);
        }
        DocIdSetPlanNode docIdSetPlanNode = maxDocsPerCall > 0 ? new DocIdSetPlanNode(indexSegment, queryContext, maxDocsPerCall) : null;
        this._projectionPlanNode = new ProjectionPlanNode(indexSegment, projectionColumns, docIdSetPlanNode);
    }

    public TransformOperator run() {
        return new TransformOperator(this._projectionPlanNode.run(), this._expressions);
    }
}

