/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan;

import java.util.HashMap;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.core.common.DataSource;
import org.apache.pinot.core.indexsegment.IndexSegment;
import org.apache.pinot.core.operator.ProjectionOperator;
import org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.core.plan.PlanNode;

public class ProjectionPlanNode
implements PlanNode {
    private final IndexSegment _indexSegment;
    private final Set<String> _projectionColumns;
    private final DocIdSetPlanNode _docIdSetPlanNode;

    public ProjectionPlanNode(IndexSegment indexSegment, Set<String> projectionColumns, @Nullable DocIdSetPlanNode docIdSetPlanNode) {
        this._indexSegment = indexSegment;
        this._projectionColumns = projectionColumns;
        this._docIdSetPlanNode = docIdSetPlanNode;
    }

    public ProjectionOperator run() {
        HashMap<String, DataSource> dataSourceMap = new HashMap<String, DataSource>(this._projectionColumns.size());
        for (String column : this._projectionColumns) {
            dataSourceMap.put(column, this._indexSegment.getDataSource(column));
        }
        return new ProjectionOperator(dataSourceMap, this._docIdSetPlanNode != null ? this._docIdSetPlanNode.run() : null);
    }
}

