/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.core.common.DataSource;
import org.apache.pinot.core.indexsegment.IndexSegment;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.operator.filter.BitmapBasedFilterOperator;
import org.apache.pinot.core.operator.filter.EmptyFilterOperator;
import org.apache.pinot.core.operator.filter.ExpressionFilterOperator;
import org.apache.pinot.core.operator.filter.FilterOperatorUtils;
import org.apache.pinot.core.operator.filter.MatchAllFilterOperator;
import org.apache.pinot.core.operator.filter.TextMatchFilterOperator;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluatorProvider;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.query.request.context.ExpressionContext;
import org.apache.pinot.core.query.request.context.FilterContext;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.predicate.Predicate;
import org.apache.pinot.core.query.request.context.predicate.TextMatchPredicate;
import org.apache.pinot.core.segment.index.readers.NullValueVectorReader;
import org.apache.pinot.core.segment.index.readers.ValidDocIndexReader;
import org.apache.pinot.core.util.QueryOptions;

public class FilterPlanNode
implements PlanNode {
    private final IndexSegment _indexSegment;
    private final QueryContext _queryContext;
    private final int _numDocs;

    public FilterPlanNode(IndexSegment indexSegment, QueryContext queryContext) {
        this._indexSegment = indexSegment;
        this._queryContext = queryContext;
        this._numDocs = this._indexSegment.getSegmentMetadata().getTotalDocs();
    }

    public BaseFilterOperator run() {
        FilterContext filter = this._queryContext.getFilter();
        ValidDocIndexReader validDocIndexReader = this._indexSegment.getValidDocIndex();
        boolean upsertSkipped = false;
        if (this._queryContext.getQueryOptions() != null) {
            upsertSkipped = new QueryOptions(this._queryContext.getQueryOptions()).isSkipUpsert();
        }
        if (filter != null) {
            BaseFilterOperator filterOperator = this.constructPhysicalOperator(filter, this._queryContext.getDebugOptions());
            if (validDocIndexReader != null && !upsertSkipped) {
                BitmapBasedFilterOperator validDocFilter = new BitmapBasedFilterOperator(validDocIndexReader.getValidDocBitmap(), false, this._numDocs);
                return FilterOperatorUtils.getAndFilterOperator(Arrays.asList(filterOperator, validDocFilter), this._numDocs, this._queryContext.getDebugOptions());
            }
            return filterOperator;
        }
        if (validDocIndexReader != null && !upsertSkipped) {
            return new BitmapBasedFilterOperator(validDocIndexReader.getValidDocBitmap(), false, this._numDocs);
        }
        return new MatchAllFilterOperator(this._numDocs);
    }

    private BaseFilterOperator constructPhysicalOperator(FilterContext filter, @Nullable Map<String, String> debugOptions) {
        switch (filter.getType()) {
            case AND: {
                List<FilterContext> childFilters = filter.getChildren();
                ArrayList<BaseFilterOperator> childFilterOperators = new ArrayList<BaseFilterOperator>(childFilters.size());
                for (FilterContext childFilter : childFilters) {
                    BaseFilterOperator childFilterOperator = this.constructPhysicalOperator(childFilter, debugOptions);
                    if (childFilterOperator.isResultEmpty()) {
                        return EmptyFilterOperator.getInstance();
                    }
                    if (childFilterOperator.isResultMatchingAll()) continue;
                    childFilterOperators.add(childFilterOperator);
                }
                return FilterOperatorUtils.getAndFilterOperator(childFilterOperators, this._numDocs, debugOptions);
            }
            case OR: {
                List<FilterContext> childFilters = filter.getChildren();
                ArrayList<BaseFilterOperator> childFilterOperators = new ArrayList<BaseFilterOperator>(childFilters.size());
                for (FilterContext childFilter : childFilters) {
                    BaseFilterOperator childFilterOperator = this.constructPhysicalOperator(childFilter, debugOptions);
                    if (childFilterOperator.isResultMatchingAll()) {
                        return new MatchAllFilterOperator(this._numDocs);
                    }
                    if (childFilterOperator.isResultEmpty()) continue;
                    childFilterOperators.add(childFilterOperator);
                }
                return FilterOperatorUtils.getOrFilterOperator(childFilterOperators, this._numDocs, debugOptions);
            }
            case PREDICATE: {
                Predicate predicate = filter.getPredicate();
                ExpressionContext lhs = predicate.getLhs();
                if (lhs.getType() == ExpressionContext.Type.FUNCTION) {
                    return new ExpressionFilterOperator(this._indexSegment, predicate, this._numDocs);
                }
                DataSource dataSource = this._indexSegment.getDataSource(lhs.getIdentifier());
                switch (predicate.getType()) {
                    case TEXT_MATCH: {
                        return new TextMatchFilterOperator(dataSource.getTextIndex(), ((TextMatchPredicate)predicate).getValue(), this._numDocs);
                    }
                    case IS_NULL: {
                        NullValueVectorReader nullValueVector = dataSource.getNullValueVector();
                        if (nullValueVector != null) {
                            return new BitmapBasedFilterOperator(nullValueVector.getNullBitmap(), false, this._numDocs);
                        }
                        return EmptyFilterOperator.getInstance();
                    }
                    case IS_NOT_NULL: {
                        NullValueVectorReader nullValueVector = dataSource.getNullValueVector();
                        if (nullValueVector != null) {
                            return new BitmapBasedFilterOperator(nullValueVector.getNullBitmap(), true, this._numDocs);
                        }
                        return new MatchAllFilterOperator(this._numDocs);
                    }
                }
                PredicateEvaluator predicateEvaluator = PredicateEvaluatorProvider.getPredicateEvaluator(predicate, dataSource.getDictionary(), dataSource.getDataSourceMetadata().getDataType());
                return FilterOperatorUtils.getLeafFilterOperator(predicateEvaluator, dataSource, this._numDocs);
            }
        }
        throw new IllegalStateException();
    }
}

