/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.core.indexsegment.IndexSegment;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.core.operator.query.AggregationOperator;
import org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.plan.TransformPlanNode;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.core.query.request.context.ExpressionContext;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.startree.StarTreeUtils;
import org.apache.pinot.core.startree.plan.StarTreeTransformPlanNode;
import org.apache.pinot.core.startree.v2.AggregationFunctionColumnPair;
import org.apache.pinot.core.startree.v2.StarTreeV2;

public class AggregationPlanNode
implements PlanNode {
    private final IndexSegment _indexSegment;
    private final AggregationFunction[] _aggregationFunctions;
    private final TransformPlanNode _transformPlanNode;
    private final StarTreeTransformPlanNode _starTreeTransformPlanNode;

    public AggregationPlanNode(IndexSegment indexSegment, QueryContext queryContext) {
        Map<String, List<PredicateEvaluator>> predicateEvaluatorsMap;
        AggregationFunctionColumnPair[] aggregationFunctionColumnPairs;
        this._indexSegment = indexSegment;
        this._aggregationFunctions = queryContext.getAggregationFunctions();
        assert (this._aggregationFunctions != null);
        List<StarTreeV2> starTrees = indexSegment.getStarTrees();
        if (starTrees != null && !StarTreeUtils.isStarTreeDisabled(queryContext) && (aggregationFunctionColumnPairs = StarTreeUtils.extractAggregationFunctionPairs(this._aggregationFunctions)) != null && (predicateEvaluatorsMap = StarTreeUtils.extractPredicateEvaluatorsMap(indexSegment, queryContext.getFilter())) != null) {
            for (StarTreeV2 starTreeV2 : starTrees) {
                if (!StarTreeUtils.isFitForStarTree(starTreeV2.getMetadata(), aggregationFunctionColumnPairs, null, predicateEvaluatorsMap.keySet())) continue;
                this._transformPlanNode = null;
                this._starTreeTransformPlanNode = new StarTreeTransformPlanNode(starTreeV2, aggregationFunctionColumnPairs, null, predicateEvaluatorsMap, queryContext.getDebugOptions());
                return;
            }
        }
        Set<ExpressionContext> expressionsToTransform = AggregationFunctionUtils.collectExpressionsToTransform(this._aggregationFunctions, null);
        this._transformPlanNode = new TransformPlanNode(this._indexSegment, queryContext, expressionsToTransform, DocIdSetPlanNode.MAX_DOC_PER_CALL);
        this._starTreeTransformPlanNode = null;
    }

    public AggregationOperator run() {
        int numTotalDocs = this._indexSegment.getSegmentMetadata().getTotalDocs();
        if (this._transformPlanNode != null) {
            return new AggregationOperator(this._aggregationFunctions, this._transformPlanNode.run(), numTotalDocs, false);
        }
        return new AggregationOperator(this._aggregationFunctions, this._starTreeTransformPlanNode.run(), numTotalDocs, true);
    }
}

