/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.transformer.datetime;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.pinot.core.operator.transform.transformer.DataTransformer;
import org.apache.pinot.spi.data.DateTimeFormatSpec;
import org.apache.pinot.spi.data.DateTimeFormatUnitSpec;
import org.apache.pinot.spi.data.DateTimeGranularitySpec;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;

public abstract class BaseDateTimeTransformer<I, O>
implements DataTransformer<I, O> {
    private final int _inputTimeSize;
    private final TimeUnit _inputTimeUnit;
    private final DateTimeFormatter _inputDateTimeFormatter;
    private final int _outputTimeSize;
    private final DateTimeFormatUnitSpec.DateTimeTransformUnit _outputTimeUnit;
    private final DateTimeFormatter _outputDateTimeFormatter;
    private final DateTimeGranularitySpec _outputGranularity;
    private final long _outputGranularityMillis;
    private final SDFDateTimeTruncate _dateTimeTruncate;

    public BaseDateTimeTransformer(@Nonnull DateTimeFormatSpec inputFormat, @Nonnull DateTimeFormatSpec outputFormat, @Nonnull DateTimeGranularitySpec outputGranularity) {
        this._inputTimeSize = inputFormat.getColumnSize();
        this._inputTimeUnit = inputFormat.getColumnUnit();
        this._inputDateTimeFormatter = inputFormat.getDateTimeFormatter();
        this._outputTimeSize = outputFormat.getColumnSize();
        this._outputTimeUnit = outputFormat.getColumnDateTimeTransformUnit();
        this._outputDateTimeFormatter = outputFormat.getDateTimeFormatter();
        this._outputGranularity = outputGranularity;
        this._outputGranularityMillis = outputGranularity.granularityToMillis();
        int sz = this._outputGranularity.getSize();
        switch (this._outputGranularity.getTimeUnit()) {
            case MILLISECONDS: {
                this._dateTimeTruncate = dateTime -> this._outputDateTimeFormatter.print((ReadableInstant)dateTime.withMillisOfSecond(dateTime.getMillisOfSecond() / sz * sz));
                break;
            }
            case SECONDS: {
                this._dateTimeTruncate = dateTime -> this._outputDateTimeFormatter.print((ReadableInstant)dateTime.withSecondOfMinute(dateTime.getSecondOfMinute() / sz * sz).secondOfMinute().roundFloorCopy());
                break;
            }
            case MINUTES: {
                this._dateTimeTruncate = dateTime -> this._outputDateTimeFormatter.print((ReadableInstant)dateTime.withMinuteOfHour(dateTime.getMinuteOfHour() / sz * sz).minuteOfHour().roundFloorCopy());
                break;
            }
            case HOURS: {
                this._dateTimeTruncate = dateTime -> this._outputDateTimeFormatter.print((ReadableInstant)dateTime.withHourOfDay(dateTime.getHourOfDay() / sz * sz).hourOfDay().roundFloorCopy());
                break;
            }
            case DAYS: {
                this._dateTimeTruncate = dateTime -> this._outputDateTimeFormatter.print((ReadableInstant)dateTime.withDayOfMonth(dateTime.getDayOfMonth() / sz * sz).dayOfMonth().roundFloorCopy());
                break;
            }
            default: {
                this._dateTimeTruncate = arg_0 -> ((DateTimeFormatter)this._outputDateTimeFormatter).print(arg_0);
            }
        }
    }

    protected long transformEpochToMillis(long epochTime) {
        return this._inputTimeUnit.toMillis(epochTime * (long)this._inputTimeSize);
    }

    protected long transformSDFToMillis(@Nonnull String sdfTime) {
        return this._inputDateTimeFormatter.parseMillis(sdfTime);
    }

    protected long transformMillisToEpoch(long millisSinceEpoch) {
        return this._outputTimeUnit.fromMillis(millisSinceEpoch) / (long)this._outputTimeSize;
    }

    protected String transformMillisToSDF(long millisSinceEpoch) {
        return this._dateTimeTruncate.truncate(new DateTime(millisSinceEpoch, this._outputDateTimeFormatter.getZone()));
    }

    protected long transformToOutputGranularity(long millisSinceEpoch) {
        return millisSinceEpoch / this._outputGranularityMillis * this._outputGranularityMillis;
    }

    private static interface SDFDateTimeTruncate {
        public String truncate(DateTime var1);
    }
}

