/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.pinot.common.function.FunctionInfo;
import org.apache.pinot.common.function.FunctionInvoker;
import org.apache.pinot.common.function.FunctionUtils;
import org.apache.pinot.common.utils.PinotDataType;
import org.apache.pinot.core.common.DataSource;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.spi.data.FieldSpec;

public class ScalarTransformFunctionWrapper
extends BaseTransformFunction {
    private final String _name;
    private final FunctionInvoker _functionInvoker;
    private Object[] _arguments;
    private int _numNonLiteralArguments;
    private int[] _nonLiteralIndices;
    private TransformFunction[] _nonLiteralFunctions;
    private Object[][] _nonLiteralValues;
    private TransformResultMetadata _resultMetadata;
    private int[] _intResults;
    private float[] _floatResults;
    private double[] _doubleResults;
    private long[] _longResults;
    private String[] _stringResults;
    private byte[][] _bytesResults;

    public ScalarTransformFunctionWrapper(FunctionInfo functionInfo) {
        this._name = functionInfo.getMethod().getName();
        this._functionInvoker = new FunctionInvoker(functionInfo);
        Class[] parameterClasses = this._functionInvoker.getParameterClasses();
        PinotDataType[] parameterTypes = this._functionInvoker.getParameterTypes();
        int numParameters = parameterClasses.length;
        for (int i = 0; i < numParameters; ++i) {
            Preconditions.checkArgument((parameterTypes[i] != null ? 1 : 0) != 0, (String)"Unsupported parameter class: %s for method: %s", (Object)parameterClasses[i], (Object)functionInfo.getMethod());
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        PinotDataType[] parameterTypes;
        int numArguments = arguments.size();
        Preconditions.checkArgument((numArguments == (parameterTypes = this._functionInvoker.getParameterTypes()).length ? 1 : 0) != 0, (String)"Wrong number of arguments for method: %s, expected: %s, actual: %s", (Object)this._functionInvoker.getMethod(), (Object)parameterTypes.length, (Object)numArguments);
        this._arguments = new Object[numArguments];
        this._nonLiteralIndices = new int[numArguments];
        this._nonLiteralFunctions = new TransformFunction[numArguments];
        for (int i = 0; i < numArguments; ++i) {
            TransformFunction transformFunction = arguments.get(i);
            if (transformFunction instanceof LiteralTransformFunction) {
                String literal = ((LiteralTransformFunction)transformFunction).getLiteral();
                this._arguments[i] = parameterTypes[i].convert((Object)literal, PinotDataType.STRING);
                continue;
            }
            this._nonLiteralIndices[this._numNonLiteralArguments] = i;
            this._nonLiteralFunctions[this._numNonLiteralArguments] = transformFunction;
            ++this._numNonLiteralArguments;
        }
        this._nonLiteralValues = new Object[this._numNonLiteralArguments][];
        FieldSpec.DataType resultDataType = FunctionUtils.getDataType((Class)this._functionInvoker.getResultClass());
        if (resultDataType == null) {
            resultDataType = FieldSpec.DataType.STRING;
        }
        this._resultMetadata = new TransformResultMetadata(resultDataType, true, false);
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return this._resultMetadata;
    }

    @Override
    public int[] transformToIntValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType() != FieldSpec.DataType.INT) {
            return super.transformToIntValuesSV(projectionBlock);
        }
        if (this._intResults == null) {
            this._intResults = new int[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        this.getNonLiteralValues(projectionBlock);
        int length = projectionBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._arguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            this._intResults[i] = (Integer)this._functionInvoker.invoke(this._arguments);
        }
        return this._intResults;
    }

    @Override
    public long[] transformToLongValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType() != FieldSpec.DataType.LONG) {
            return super.transformToLongValuesSV(projectionBlock);
        }
        if (this._longResults == null) {
            this._longResults = new long[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        this.getNonLiteralValues(projectionBlock);
        int length = projectionBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._arguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            this._longResults[i] = (Long)this._functionInvoker.invoke(this._arguments);
        }
        return this._longResults;
    }

    @Override
    public float[] transformToFloatValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType() != FieldSpec.DataType.FLOAT) {
            return super.transformToFloatValuesSV(projectionBlock);
        }
        if (this._floatResults == null) {
            this._floatResults = new float[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        this.getNonLiteralValues(projectionBlock);
        int length = projectionBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._arguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            this._floatResults[i] = ((Float)this._functionInvoker.invoke(this._arguments)).floatValue();
        }
        return this._floatResults;
    }

    @Override
    public double[] transformToDoubleValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType() != FieldSpec.DataType.DOUBLE) {
            return super.transformToDoubleValuesSV(projectionBlock);
        }
        if (this._doubleResults == null) {
            this._doubleResults = new double[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        this.getNonLiteralValues(projectionBlock);
        int length = projectionBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._arguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            this._doubleResults[i] = (Double)this._functionInvoker.invoke(this._arguments);
        }
        return this._doubleResults;
    }

    @Override
    public String[] transformToStringValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType() != FieldSpec.DataType.STRING) {
            return super.transformToStringValuesSV(projectionBlock);
        }
        if (this._stringResults == null) {
            this._stringResults = new String[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        this.getNonLiteralValues(projectionBlock);
        int length = projectionBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._arguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            this._stringResults[i] = this._functionInvoker.invoke(this._arguments).toString();
        }
        return this._stringResults;
    }

    @Override
    public byte[][] transformToBytesValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType() != FieldSpec.DataType.BYTES) {
            return super.transformToBytesValuesSV(projectionBlock);
        }
        if (this._bytesResults == null) {
            this._bytesResults = new byte[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
        }
        this.getNonLiteralValues(projectionBlock);
        int length = projectionBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._arguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            this._bytesResults[i] = (byte[])this._functionInvoker.invoke(this._arguments);
        }
        return this._bytesResults;
    }

    private void getNonLiteralValues(ProjectionBlock projectionBlock) {
        PinotDataType[] parameterTypes = this._functionInvoker.getParameterTypes();
        block8: for (int i = 0; i < this._numNonLiteralArguments; ++i) {
            int index = this._nonLiteralIndices[i];
            TransformFunction transformFunction = this._nonLiteralFunctions[i];
            switch (parameterTypes[index]) {
                case INTEGER: {
                    this._nonLiteralValues[i] = ArrayUtils.toObject((int[])transformFunction.transformToIntValuesSV(projectionBlock));
                    continue block8;
                }
                case LONG: {
                    this._nonLiteralValues[i] = ArrayUtils.toObject((long[])transformFunction.transformToLongValuesSV(projectionBlock));
                    continue block8;
                }
                case FLOAT: {
                    this._nonLiteralValues[i] = ArrayUtils.toObject((float[])transformFunction.transformToFloatValuesSV(projectionBlock));
                    continue block8;
                }
                case DOUBLE: {
                    this._nonLiteralValues[i] = ArrayUtils.toObject((double[])transformFunction.transformToDoubleValuesSV(projectionBlock));
                    continue block8;
                }
                case STRING: {
                    this._nonLiteralValues[i] = transformFunction.transformToStringValuesSV(projectionBlock);
                    continue block8;
                }
                case BYTES: {
                    this._nonLiteralValues[i] = (Object[])transformFunction.transformToBytesValuesSV(projectionBlock);
                    continue block8;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }
}

