/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.collect.ImmutableSet;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.pinot.core.common.DataSource;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.JsonUtils;

public class JsonExtractScalarTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "jsonExtractScalar";
    private static final Configuration LIST_RESPONSE_CONFIG = Configuration.defaultConfiguration().addOptions(new Option[]{Option.SUPPRESS_EXCEPTIONS});
    private TransformFunction _jsonFieldTransformFunction;
    private String _jsonPath;
    private String _resultsType;
    private Object _defaultValue = null;
    private TransformResultMetadata _resultMetadata;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(@Nonnull List<TransformFunction> arguments, @Nonnull Map<String, DataSource> dataSourceMap) {
        if (arguments.size() < 3 || arguments.size() > 4) {
            throw new IllegalArgumentException("Expected 3/4 arguments for transform function: jsonExtractScalar(jsonFieldName, 'jsonPath', 'resultsType', ['defaultValue'])");
        }
        TransformFunction firstArgument = arguments.get(0);
        if (firstArgument instanceof LiteralTransformFunction || !firstArgument.getResultMetadata().isSingleValue()) {
            throw new IllegalArgumentException("The first argument of jsonExtractScalar transform function must be a single-valued column or a transform function");
        }
        this._jsonFieldTransformFunction = firstArgument;
        this._jsonPath = ((LiteralTransformFunction)arguments.get(1)).getLiteral();
        this._resultsType = ((LiteralTransformFunction)arguments.get(2)).getLiteral().toUpperCase();
        boolean isSingleValue = !this._resultsType.toUpperCase().endsWith("_ARRAY");
        try {
            FieldSpec.DataType fieldType = FieldSpec.DataType.valueOf((String)this._resultsType.split("_ARRAY")[0]);
            if (arguments.size() == 4) {
                String defaultValue = ((LiteralTransformFunction)arguments.get(3)).getLiteral();
                switch (fieldType) {
                    case INT: {
                        this._defaultValue = Double.valueOf(defaultValue).intValue();
                        break;
                    }
                    case LONG: {
                        this._defaultValue = Double.valueOf(defaultValue).longValue();
                        break;
                    }
                    case FLOAT: {
                        this._defaultValue = Float.valueOf(Double.valueOf(defaultValue).floatValue());
                        break;
                    }
                    case DOUBLE: {
                        this._defaultValue = Double.valueOf(defaultValue);
                        break;
                    }
                    case BOOLEAN: 
                    case STRING: {
                        this._defaultValue = defaultValue;
                        break;
                    }
                    case BYTES: {
                        throw new UnsupportedOperationException(String.format("Unsupported results type: BYTES for 'jsonExtractScalar' Udf. Supported types are: INT/LONG/FLOAT/DOUBLE/STRING/INT_ARRAY/LONG/FLOAT_ARRAY/DOUBLE_ARRAY/STRING_ARRAY", this._resultsType));
                    }
                }
            }
            this._resultMetadata = new TransformResultMetadata(fieldType, isSingleValue, false);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(String.format("Unsupported results type: %s for 'jsonExtractScalar' Udf. Supported types are: INT/LONG/FLOAT/DOUBLE/STRING/INT_ARRAY/LONG/FLOAT_ARRAY/DOUBLE_ARRAY/STRING_ARRAY", this._resultsType));
        }
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return this._resultMetadata;
    }

    @Override
    public int[] transformToIntValuesSV(@Nonnull ProjectionBlock projectionBlock) {
        String[] stringValuesSV = this._jsonFieldTransformFunction.transformToStringValuesSV(projectionBlock);
        int[] results = new int[projectionBlock.getNumDocs()];
        for (int i = 0; i < results.length; ++i) {
            Object read = JsonPath.read((String)stringValuesSV[i], (String)this._jsonPath, (Predicate[])new Predicate[0]);
            if (read == null) {
                if (this._defaultValue != null) {
                    results[i] = (Integer)this._defaultValue;
                    continue;
                }
                throw new RuntimeException(String.format("Illegal Json Path: [%s], when reading [%s]", this._jsonPath, stringValuesSV[i]));
            }
            results[i] = read instanceof Number ? ((Number)read).intValue() : Integer.parseInt(read.toString());
        }
        return results;
    }

    @Override
    public long[] transformToLongValuesSV(@Nonnull ProjectionBlock projectionBlock) {
        String[] stringValuesSV = this._jsonFieldTransformFunction.transformToStringValuesSV(projectionBlock);
        long[] results = new long[projectionBlock.getNumDocs()];
        for (int i = 0; i < projectionBlock.getNumDocs(); ++i) {
            Object read = JsonPath.read((String)stringValuesSV[i], (String)this._jsonPath, (Predicate[])new Predicate[0]);
            if (read == null) {
                if (this._defaultValue != null) {
                    results[i] = (Long)this._defaultValue;
                    continue;
                }
                throw new RuntimeException(String.format("Illegal Json Path: [%s], when reading [%s]", this._jsonPath, stringValuesSV[i]));
            }
            results[i] = read instanceof Number ? ((Number)read).longValue() : Double.valueOf(read.toString()).longValue();
        }
        return results;
    }

    @Override
    public float[] transformToFloatValuesSV(@Nonnull ProjectionBlock projectionBlock) {
        String[] stringValuesSV = this._jsonFieldTransformFunction.transformToStringValuesSV(projectionBlock);
        float[] results = new float[projectionBlock.getNumDocs()];
        for (int i = 0; i < projectionBlock.getNumDocs(); ++i) {
            Object read = JsonPath.read((String)stringValuesSV[i], (String)this._jsonPath, (Predicate[])new Predicate[0]);
            if (read == null) {
                if (this._defaultValue != null) {
                    results[i] = ((Float)this._defaultValue).floatValue();
                    continue;
                }
                throw new RuntimeException(String.format("Illegal Json Path: [%s], when reading [%s]", this._jsonPath, stringValuesSV[i]));
            }
            results[i] = read instanceof Number ? ((Number)read).floatValue() : Double.valueOf(read.toString()).floatValue();
        }
        return results;
    }

    @Override
    public double[] transformToDoubleValuesSV(@Nonnull ProjectionBlock projectionBlock) {
        String[] stringValuesSV = this._jsonFieldTransformFunction.transformToStringValuesSV(projectionBlock);
        double[] results = new double[projectionBlock.getNumDocs()];
        for (int i = 0; i < projectionBlock.getNumDocs(); ++i) {
            Object read = JsonPath.read((String)stringValuesSV[i], (String)this._jsonPath, (Predicate[])new Predicate[0]);
            if (read == null) {
                if (this._defaultValue != null) {
                    results[i] = (Double)this._defaultValue;
                    continue;
                }
                throw new RuntimeException(String.format("Illegal Json Path: [%s], when reading [%s]", this._jsonPath, stringValuesSV[i]));
            }
            results[i] = read instanceof Number ? ((Number)read).doubleValue() : (read instanceof BigDecimal ? ((BigDecimal)read).doubleValue() : Double.valueOf(read.toString()).doubleValue());
        }
        return results;
    }

    @Override
    public String[] transformToStringValuesSV(@Nonnull ProjectionBlock projectionBlock) {
        String[] stringValuesSV = this._jsonFieldTransformFunction.transformToStringValuesSV(projectionBlock);
        String[] results = new String[projectionBlock.getNumDocs()];
        for (int i = 0; i < projectionBlock.getNumDocs(); ++i) {
            Object read = JsonPath.read((String)stringValuesSV[i], (String)this._jsonPath, (Predicate[])new Predicate[0]);
            if (read == null) {
                if (this._defaultValue != null) {
                    results[i] = (String)this._defaultValue;
                    continue;
                }
                throw new RuntimeException(String.format("Illegal Json Path: [%s], when reading [%s]", this._jsonPath, stringValuesSV[i]));
            }
            results[i] = read instanceof String ? read.toString() : JsonUtils.objectToJsonNode((Object)read).toString();
        }
        return results;
    }

    @Override
    public int[][] transformToIntValuesMV(@Nonnull ProjectionBlock projectionBlock) {
        String[] stringValuesMV = this._jsonFieldTransformFunction.transformToStringValuesSV(projectionBlock);
        int[][] results = new int[projectionBlock.getNumDocs()][];
        for (int i = 0; i < projectionBlock.getNumDocs(); ++i) {
            List intVals = (List)JsonPath.using((Configuration)LIST_RESPONSE_CONFIG).parse(stringValuesMV[i]).read(this._jsonPath, new Predicate[0]);
            if (intVals == null) {
                results[i] = new int[0];
                continue;
            }
            results[i] = new int[intVals.size()];
            for (int j = 0; j < intVals.size(); ++j) {
                results[i][j] = (Integer)intVals.get(j);
            }
        }
        return results;
    }

    @Override
    public long[][] transformToLongValuesMV(@Nonnull ProjectionBlock projectionBlock) {
        String[] stringValuesMV = this._jsonFieldTransformFunction.transformToStringValuesSV(projectionBlock);
        long[][] results = new long[projectionBlock.getNumDocs()][];
        for (int i = 0; i < projectionBlock.getNumDocs(); ++i) {
            List longVals = (List)JsonPath.using((Configuration)LIST_RESPONSE_CONFIG).parse(stringValuesMV[i]).read(this._jsonPath, new Predicate[0]);
            if (longVals == null) {
                results[i] = new long[0];
                continue;
            }
            results[i] = new long[longVals.size()];
            for (int j = 0; j < longVals.size(); ++j) {
                results[i][j] = (Long)longVals.get(j);
            }
        }
        return results;
    }

    @Override
    public float[][] transformToFloatValuesMV(@Nonnull ProjectionBlock projectionBlock) {
        String[] stringValuesMV = this._jsonFieldTransformFunction.transformToStringValuesSV(projectionBlock);
        float[][] results = new float[projectionBlock.getNumDocs()][];
        for (int i = 0; i < projectionBlock.getNumDocs(); ++i) {
            List floatVals = (List)JsonPath.using((Configuration)LIST_RESPONSE_CONFIG).parse(stringValuesMV[i]).read(this._jsonPath, new Predicate[0]);
            if (floatVals == null) {
                results[i] = new float[0];
                continue;
            }
            results[i] = new float[floatVals.size()];
            for (int j = 0; j < floatVals.size(); ++j) {
                results[i][j] = ((Float)floatVals.get(j)).floatValue();
            }
        }
        return results;
    }

    @Override
    public double[][] transformToDoubleValuesMV(@Nonnull ProjectionBlock projectionBlock) {
        String[] stringValuesMV = this._jsonFieldTransformFunction.transformToStringValuesSV(projectionBlock);
        double[][] results = new double[projectionBlock.getNumDocs()][];
        for (int i = 0; i < projectionBlock.getNumDocs(); ++i) {
            List doubleVals = (List)JsonPath.using((Configuration)LIST_RESPONSE_CONFIG).parse(stringValuesMV[i]).read(this._jsonPath, new Predicate[0]);
            if (doubleVals == null) {
                results[i] = new double[0];
                continue;
            }
            results[i] = new double[doubleVals.size()];
            for (int j = 0; j < doubleVals.size(); ++j) {
                results[i][j] = (Double)doubleVals.get(j);
            }
        }
        return results;
    }

    @Override
    public String[][] transformToStringValuesMV(@Nonnull ProjectionBlock projectionBlock) {
        String[] stringValuesMV = this._jsonFieldTransformFunction.transformToStringValuesSV(projectionBlock);
        String[][] results = new String[projectionBlock.getNumDocs()][];
        for (int i = 0; i < projectionBlock.getNumDocs(); ++i) {
            List stringVals = (List)JsonPath.using((Configuration)LIST_RESPONSE_CONFIG).parse(stringValuesMV[i]).read(this._jsonPath, new Predicate[0]);
            if (stringVals == null) {
                results[i] = new String[0];
                continue;
            }
            results[i] = new String[stringVals.size()];
            for (int j = 0; j < stringVals.size(); ++j) {
                results[i][j] = (String)stringVals.get(j);
            }
        }
        return results;
    }

    static {
        Configuration.setDefaults((Configuration.Defaults)new Configuration.Defaults(){
            private final JsonProvider jsonProvider = new JacksonJsonProvider();
            private final MappingProvider mappingProvider = new JacksonMappingProvider();

            public JsonProvider jsonProvider() {
                return this.jsonProvider;
            }

            public MappingProvider mappingProvider() {
                return this.mappingProvider;
            }

            public Set<Option> options() {
                return ImmutableSet.of((Object)Option.SUPPRESS_EXCEPTIONS);
            }
        });
    }
}

