/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.core.common.DataSource;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TimeZoneKey;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.field.DividedDateTimeField;
import org.joda.time.field.OffsetDateTimeField;
import org.joda.time.field.ScaledDurationField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTruncTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "dateTrunc";
    public static final String EXAMPLE_INVOCATION = String.format("%s('week', time_expression, 'seconds', <TZ>, <Output-Granularity>)", "dateTrunc");
    private static final String UTC_TZ = TimeZoneKey.UTC_KEY.getId();
    private static final DateTimeFieldType QUARTER_OF_YEAR = new QuarterOfYearDateTimeField();
    private static final Logger LOGGER = LoggerFactory.getLogger(DateTruncTransformFunction.class);
    private TransformFunction _mainTransformFunction;
    private TransformResultMetadata _resultMetadata;
    private long[] _longOutputTimes;
    private DateTimeField _field;
    private TimeUnit _inputTimeUnit;
    private TimeUnit _outputTimeUnit;

    private static DateTimeField getTimestampField(ISOChronology chronology, String unitString) {
        switch (unitString) {
            case "millisecond": {
                return chronology.millisOfSecond();
            }
            case "second": {
                return chronology.secondOfMinute();
            }
            case "minute": {
                return chronology.minuteOfHour();
            }
            case "hour": {
                return chronology.hourOfDay();
            }
            case "day": {
                return chronology.dayOfMonth();
            }
            case "week": {
                return chronology.weekOfWeekyear();
            }
            case "month": {
                return chronology.monthOfYear();
            }
            case "quarter": {
                return QUARTER_OF_YEAR.getField((Chronology)chronology);
            }
            case "year": {
                return chronology.year();
            }
        }
        throw new IllegalArgumentException("'" + unitString + "' is not a valid Timestamp field");
    }

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        Preconditions.checkArgument((arguments.size() >= 3 && arguments.size() <= 5 ? 1 : 0) != 0, (String)"Between three to five arguments are required, example: %s", (Object)EXAMPLE_INVOCATION);
        String unit = ((LiteralTransformFunction)arguments.get(0)).getLiteral().toLowerCase();
        TransformFunction valueArgument = arguments.get(1);
        Preconditions.checkArgument((!(valueArgument instanceof LiteralTransformFunction) && valueArgument.getResultMetadata().isSingleValue() ? 1 : 0) != 0, (Object)"The second argument of dateTrunc transform function must be a single-valued column or a transform function");
        this._mainTransformFunction = valueArgument;
        String inputTimeUnitStr = ((LiteralTransformFunction)arguments.get(2)).getLiteral().toUpperCase();
        this._inputTimeUnit = TimeUnit.valueOf(inputTimeUnitStr);
        String timeZone = arguments.size() >= 4 ? ((LiteralTransformFunction)arguments.get(3)).getLiteral() : UTC_TZ;
        String outputTimeUnitStr = arguments.size() >= 5 ? ((LiteralTransformFunction)arguments.get(4)).getLiteral().toUpperCase() : inputTimeUnitStr;
        TimeZoneKey timeZoneKey = TimeZoneKey.getTimeZoneKey(timeZone);
        this._field = DateTruncTransformFunction.getTimestampField(DateTimeZoneIndex.getChronology(timeZoneKey), unit);
        this._resultMetadata = LONG_SV_NO_DICTIONARY_METADATA;
        this._outputTimeUnit = TimeUnit.valueOf(outputTimeUnitStr);
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return this._resultMetadata;
    }

    @Override
    public long[] transformToLongValuesSV(ProjectionBlock projectionBlock) {
        if (this._longOutputTimes == null) {
            this._longOutputTimes = new long[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        int length = projectionBlock.getNumDocs();
        long[] input = this._mainTransformFunction.transformToLongValuesSV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            this._longOutputTimes[i] = this._outputTimeUnit.convert(this._field.roundFloor(TimeUnit.MILLISECONDS.convert(input[i], this._inputTimeUnit)), TimeUnit.MILLISECONDS);
        }
        return this._longOutputTimes;
    }

    public static final class QuarterOfYearDateTimeField
    extends DateTimeFieldType {
        private static final DateTimeFieldType QUARTER_OF_YEAR = new QuarterOfYearDateTimeField();
        private static final long serialVersionUID = -5677872459807379123L;
        private static final DurationFieldType QUARTER_OF_YEAR_DURATION_FIELD_TYPE = new QuarterOfYearDurationFieldType();

        private QuarterOfYearDateTimeField() {
            super("quarterOfYear");
        }

        public DurationFieldType getDurationType() {
            return QUARTER_OF_YEAR_DURATION_FIELD_TYPE;
        }

        public DurationFieldType getRangeDurationType() {
            return DurationFieldType.years();
        }

        public DateTimeField getField(Chronology chronology) {
            return new OffsetDateTimeField((DateTimeField)new DividedDateTimeField((DateTimeField)new OffsetDateTimeField(chronology.monthOfYear(), -1), QUARTER_OF_YEAR, 3), 1);
        }

        private static class QuarterOfYearDurationFieldType
        extends DurationFieldType {
            private static final long serialVersionUID = -8167713675442491871L;

            public QuarterOfYearDurationFieldType() {
                super("quarters");
            }

            public DurationField getField(Chronology chronology) {
                return new ScaledDurationField(chronology.months(), QUARTER_OF_YEAR_DURATION_FIELD_TYPE, 3);
            }
        }
    }

    public static final class DateTimeZoneIndex {
        private static final DateTimeZone[] DATE_TIME_ZONES = new DateTimeZone[TimeZoneKey.MAX_TIME_ZONE_KEY + 1];
        private static final ISOChronology[] CHRONOLOGIES = new ISOChronology[TimeZoneKey.MAX_TIME_ZONE_KEY + 1];
        private static final int[] FIXED_ZONE_OFFSET = new int[TimeZoneKey.MAX_TIME_ZONE_KEY + 1];
        private static final int VARIABLE_ZONE = Integer.MAX_VALUE;

        private DateTimeZoneIndex() {
        }

        public static ISOChronology getChronology(TimeZoneKey zoneKey) {
            return CHRONOLOGIES[zoneKey.getKey()];
        }

        public static DateTimeZone getDateTimeZone(TimeZoneKey zoneKey) {
            return DATE_TIME_ZONES[zoneKey.getKey()];
        }

        static {
            for (TimeZoneKey timeZoneKey : TimeZoneKey.getTimeZoneKeys()) {
                DateTimeZone dateTimeZone;
                short zoneKey = timeZoneKey.getKey();
                try {
                    dateTimeZone = DateTimeZone.forID((String)timeZoneKey.getId());
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("Exception while extracting time zone field", (Throwable)e);
                    continue;
                }
                DateTimeZoneIndex.DATE_TIME_ZONES[zoneKey] = dateTimeZone;
                DateTimeZoneIndex.CHRONOLOGIES[zoneKey] = ISOChronology.getInstance((DateTimeZone)dateTimeZone);
                if (dateTimeZone.isFixed() && dateTimeZone.getOffset(0L) % 60000 == 0) {
                    DateTimeZoneIndex.FIXED_ZONE_OFFSET[zoneKey] = dateTimeZone.getOffset(0L) / 60000;
                    continue;
                }
                DateTimeZoneIndex.FIXED_ZONE_OFFSET[zoneKey] = Integer.MAX_VALUE;
            }
        }
    }
}

