/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import java.util.List;
import java.util.Map;
import org.apache.pinot.core.common.DataSource;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;

public class CastTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "cast";
    private TransformFunction _transformFunction;
    private String _toFormat;
    private TransformResultMetadata _resultMetadata;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        if (arguments.size() != 2) {
            throw new IllegalArgumentException("Exactly 2 arguments are required for CAST transform function");
        }
        this._transformFunction = arguments.get(0);
        TransformFunction castFormatTransformFunction = arguments.get(1);
        if (castFormatTransformFunction instanceof LiteralTransformFunction) {
            switch (this._toFormat = ((LiteralTransformFunction)castFormatTransformFunction).getLiteral().toUpperCase()) {
                case "INT": 
                case "INTEGER": 
                case "LONG": {
                    this._resultMetadata = LONG_SV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "FLOAT": 
                case "DOUBLE": {
                    this._resultMetadata = DOUBLE_SV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "STRING": 
                case "VARCHAR": {
                    this._resultMetadata = STRING_SV_NO_DICTIONARY_METADATA;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unable to cast expression to type - " + this._toFormat);
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid cast to type - " + castFormatTransformFunction.getName());
        }
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return this._resultMetadata;
    }

    @Override
    public int[] transformToIntValuesSV(ProjectionBlock projectionBlock) {
        return this._transformFunction.transformToIntValuesSV(projectionBlock);
    }

    @Override
    public long[] transformToLongValuesSV(ProjectionBlock projectionBlock) {
        return this._transformFunction.transformToLongValuesSV(projectionBlock);
    }

    @Override
    public float[] transformToFloatValuesSV(ProjectionBlock projectionBlock) {
        return this._transformFunction.transformToFloatValuesSV(projectionBlock);
    }

    @Override
    public double[] transformToDoubleValuesSV(ProjectionBlock projectionBlock) {
        return this._transformFunction.transformToDoubleValuesSV(projectionBlock);
    }

    @Override
    public String[] transformToStringValuesSV(ProjectionBlock projectionBlock) {
        return this._transformFunction.transformToStringValuesSV(projectionBlock);
    }
}

