/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.common.DataSource;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.core.util.ArrayCopyUtils;
import org.apache.pinot.spi.data.FieldSpec;

public class CaseTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "case";
    private final List<TransformFunction> _whenStatements = new ArrayList<TransformFunction>();
    private final List<TransformFunction> _elseThenStatements = new ArrayList<TransformFunction>();
    private int _numberWhenStatements;
    private TransformResultMetadata _resultMetadata;
    private int[] _selectedResults;
    private int[] _intResults;
    private long[] _longResults;
    private float[] _floatResults;
    private double[] _doubleResults;
    private String[] _stringResults;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        int i;
        if (arguments.size() % 2 != 1 || arguments.size() < 3) {
            throw new IllegalArgumentException("At least 3 odd number of arguments are required for CASE-WHEN-ELSE function");
        }
        this._numberWhenStatements = arguments.size() / 2;
        for (i = 0; i < this._numberWhenStatements; ++i) {
            this._whenStatements.add(arguments.get(i));
        }
        this._elseThenStatements.add(arguments.get(this._numberWhenStatements * 2));
        for (i = this._numberWhenStatements; i < this._numberWhenStatements * 2; ++i) {
            this._elseThenStatements.add(arguments.get(i));
        }
        this.getResultMetadata();
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        if (this._resultMetadata != null) {
            return this._resultMetadata;
        }
        FieldSpec.DataType dataType = this._elseThenStatements.get(0).getResultMetadata().getDataType();
        boolean isSingleValueField = this._elseThenStatements.get(0).getResultMetadata().isSingleValue();
        block39: for (int i = 1; i < this._elseThenStatements.size(); ++i) {
            TransformFunction transformFunction = this._elseThenStatements.get(i);
            TransformResultMetadata resultMetadata = transformFunction.getResultMetadata();
            if (resultMetadata.isSingleValue() != isSingleValueField) {
                throw new IllegalStateException(String.format("Mixed Single/Multi Value results in expression types in THEN Clause [%s].", resultMetadata));
            }
            switch (dataType) {
                case INT: {
                    if (transformFunction instanceof LiteralTransformFunction) {
                        dataType = LiteralTransformFunction.inferLiteralDataType((LiteralTransformFunction)transformFunction);
                        continue block39;
                    }
                    switch (resultMetadata.getDataType()) {
                        case INT: 
                        case LONG: 
                        case FLOAT: 
                        case DOUBLE: 
                        case STRING: {
                            dataType = resultMetadata.getDataType();
                            continue block39;
                        }
                    }
                    throw new IllegalStateException(String.format("Incompatible expression types in THEN Clause [%s].", resultMetadata));
                }
                case LONG: {
                    FieldSpec.DataType literalDataType;
                    if (transformFunction instanceof LiteralTransformFunction) {
                        literalDataType = LiteralTransformFunction.inferLiteralDataType((LiteralTransformFunction)transformFunction);
                        switch (literalDataType) {
                            case INT: 
                            case LONG: {
                                continue block39;
                            }
                            case FLOAT: 
                            case DOUBLE: {
                                dataType = FieldSpec.DataType.DOUBLE;
                                continue block39;
                            }
                        }
                        dataType = FieldSpec.DataType.STRING;
                        continue block39;
                    }
                    switch (resultMetadata.getDataType()) {
                        case INT: 
                        case LONG: {
                            continue block39;
                        }
                        case FLOAT: 
                        case DOUBLE: {
                            dataType = FieldSpec.DataType.DOUBLE;
                            continue block39;
                        }
                        case STRING: {
                            dataType = FieldSpec.DataType.STRING;
                            continue block39;
                        }
                    }
                    throw new IllegalStateException(String.format("Incompatible expression types in THEN Clause [%s].", resultMetadata));
                }
                case FLOAT: {
                    FieldSpec.DataType literalDataType;
                    if (transformFunction instanceof LiteralTransformFunction) {
                        literalDataType = LiteralTransformFunction.inferLiteralDataType((LiteralTransformFunction)transformFunction);
                        switch (literalDataType) {
                            case INT: 
                            case FLOAT: {
                                continue block39;
                            }
                            case LONG: 
                            case DOUBLE: {
                                dataType = FieldSpec.DataType.DOUBLE;
                                continue block39;
                            }
                            case STRING: {
                                dataType = FieldSpec.DataType.STRING;
                                continue block39;
                            }
                        }
                        dataType = literalDataType;
                        continue block39;
                    }
                    switch (resultMetadata.getDataType()) {
                        case INT: 
                        case FLOAT: {
                            continue block39;
                        }
                        case LONG: 
                        case DOUBLE: {
                            dataType = FieldSpec.DataType.DOUBLE;
                            continue block39;
                        }
                        case STRING: {
                            dataType = FieldSpec.DataType.STRING;
                            continue block39;
                        }
                    }
                    throw new IllegalStateException(String.format("Incompatible expression types in THEN Clause [%s].", resultMetadata));
                }
                case DOUBLE: {
                    FieldSpec.DataType literalDataType;
                    if (transformFunction instanceof LiteralTransformFunction) {
                        literalDataType = LiteralTransformFunction.inferLiteralDataType((LiteralTransformFunction)transformFunction);
                        switch (literalDataType) {
                            case INT: 
                            case LONG: 
                            case FLOAT: 
                            case DOUBLE: {
                                continue block39;
                            }
                        }
                        dataType = literalDataType;
                        continue block39;
                    }
                    switch (resultMetadata.getDataType()) {
                        case INT: 
                        case LONG: 
                        case FLOAT: 
                        case DOUBLE: {
                            continue block39;
                        }
                        case STRING: {
                            dataType = resultMetadata.getDataType();
                            continue block39;
                        }
                    }
                    throw new IllegalStateException(String.format("Incompatible expression types in THEN Clause [%s].", resultMetadata));
                }
                case STRING: {
                    if (transformFunction instanceof LiteralTransformFunction) continue block39;
                    switch (resultMetadata.getDataType()) {
                        case INT: 
                        case LONG: 
                        case FLOAT: 
                        case DOUBLE: 
                        case STRING: {
                            continue block39;
                        }
                    }
                    throw new IllegalStateException(String.format("Incompatible expression types in THEN Clause [%s].", resultMetadata));
                }
                default: {
                    if (resultMetadata.getDataType() == dataType) continue block39;
                    throw new IllegalStateException(String.format("Incompatible expression types in THEN Clause [%s].", resultMetadata));
                }
            }
        }
        this._resultMetadata = new TransformResultMetadata(dataType, true, false);
        return this._resultMetadata;
    }

    private int[] getSelectedArray(ProjectionBlock projectionBlock) {
        if (this._selectedResults == null) {
            this._selectedResults = new int[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        } else {
            Arrays.fill(this._selectedResults, 0);
        }
        for (int i = 0; i < this._numberWhenStatements; ++i) {
            TransformFunction transformFunction = this._whenStatements.get(i);
            int[] conditions = transformFunction.transformToIntValuesSV(projectionBlock);
            for (int j = 0; j < conditions.length; ++j) {
                if (this._selectedResults[j] != 0 || conditions[j] != 1) continue;
                this._selectedResults[j] = i + 1;
            }
        }
        return this._selectedResults;
    }

    @Override
    public int[] transformToIntValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType() != FieldSpec.DataType.INT) {
            return super.transformToIntValuesSV(projectionBlock);
        }
        int[] selected = this.getSelectedArray(projectionBlock);
        if (this._intResults == null) {
            this._intResults = new int[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        for (int i = 0; i < this._elseThenStatements.size(); ++i) {
            TransformFunction transformFunction = this._elseThenStatements.get(i);
            int blockNumDocs = projectionBlock.getNumDocs();
            int[] evalInts = transformFunction.transformToIntValuesSV(projectionBlock);
            for (int j = 0; j < blockNumDocs; ++j) {
                if (selected[j] != i) continue;
                this._intResults[j] = evalInts[j];
            }
        }
        return this._intResults;
    }

    @Override
    public long[] transformToLongValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType() != FieldSpec.DataType.LONG) {
            return super.transformToLongValuesSV(projectionBlock);
        }
        int[] selected = this.getSelectedArray(projectionBlock);
        if (this._longResults == null) {
            this._longResults = new long[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        for (int i = 0; i < this._elseThenStatements.size(); ++i) {
            long[] evalLongs;
            TransformFunction transformFunction = this._elseThenStatements.get(i);
            FieldSpec.DataType dataType = transformFunction.getResultMetadata().getDataType();
            int blockNumDocs = projectionBlock.getNumDocs();
            if (dataType == FieldSpec.DataType.LONG) {
                evalLongs = transformFunction.transformToLongValuesSV(projectionBlock);
            } else {
                evalLongs = new long[blockNumDocs];
                ArrayCopyUtils.copy(transformFunction.transformToIntValuesSV(projectionBlock), evalLongs, blockNumDocs);
            }
            for (int j = 0; j < blockNumDocs; ++j) {
                if (selected[j] != i) continue;
                this._longResults[j] = evalLongs[j];
            }
        }
        return this._longResults;
    }

    @Override
    public float[] transformToFloatValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType() != FieldSpec.DataType.FLOAT) {
            return super.transformToFloatValuesSV(projectionBlock);
        }
        int[] selected = this.getSelectedArray(projectionBlock);
        if (this._floatResults == null) {
            this._floatResults = new float[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        for (int i = 0; i < this._elseThenStatements.size(); ++i) {
            float[] evalFloats;
            TransformFunction transformFunction = this._elseThenStatements.get(i);
            FieldSpec.DataType dataType = transformFunction.getResultMetadata().getDataType();
            int blockNumDocs = projectionBlock.getNumDocs();
            if (dataType == FieldSpec.DataType.FLOAT) {
                evalFloats = transformFunction.transformToFloatValuesSV(projectionBlock);
            } else {
                evalFloats = new float[blockNumDocs];
                ArrayCopyUtils.copy(transformFunction.transformToIntValuesSV(projectionBlock), evalFloats, blockNumDocs);
            }
            for (int j = 0; j < blockNumDocs; ++j) {
                if (selected[j] != i) continue;
                this._floatResults[j] = evalFloats[j];
            }
        }
        return this._floatResults;
    }

    @Override
    public double[] transformToDoubleValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType() != FieldSpec.DataType.DOUBLE) {
            return super.transformToDoubleValuesSV(projectionBlock);
        }
        int[] selected = this.getSelectedArray(projectionBlock);
        if (this._doubleResults == null) {
            this._doubleResults = new double[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        for (int i = 0; i < this._elseThenStatements.size(); ++i) {
            double[] evalDoubles;
            TransformFunction transformFunction = this._elseThenStatements.get(i);
            FieldSpec.DataType dataType = transformFunction.getResultMetadata().getDataType();
            int blockNumDocs = projectionBlock.getNumDocs();
            if (dataType == FieldSpec.DataType.DOUBLE) {
                evalDoubles = transformFunction.transformToDoubleValuesSV(projectionBlock);
            } else {
                evalDoubles = new double[blockNumDocs];
                switch (dataType) {
                    case INT: {
                        ArrayCopyUtils.copy(transformFunction.transformToIntValuesSV(projectionBlock), evalDoubles, blockNumDocs);
                        break;
                    }
                    case LONG: {
                        ArrayCopyUtils.copy(transformFunction.transformToLongValuesSV(projectionBlock), evalDoubles, blockNumDocs);
                        break;
                    }
                    case FLOAT: {
                        ArrayCopyUtils.copy(transformFunction.transformToFloatValuesSV(projectionBlock), evalDoubles, blockNumDocs);
                        break;
                    }
                    default: {
                        throw new IllegalStateException(String.format("Cannot convert result type [%s] to [DOUBLE] for transform function [%s]", dataType, transformFunction));
                    }
                }
            }
            for (int j = 0; j < blockNumDocs; ++j) {
                if (selected[j] != i) continue;
                this._doubleResults[j] = evalDoubles[j];
            }
        }
        return this._doubleResults;
    }

    @Override
    public String[] transformToStringValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType() != FieldSpec.DataType.STRING) {
            return super.transformToStringValuesSV(projectionBlock);
        }
        int[] selected = this.getSelectedArray(projectionBlock);
        if (this._stringResults == null) {
            this._stringResults = new String[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        for (int i = 0; i < this._elseThenStatements.size(); ++i) {
            String[] evalStrings;
            TransformFunction transformFunction = this._elseThenStatements.get(i);
            FieldSpec.DataType dataType = transformFunction.getResultMetadata().getDataType();
            int blockNumDocs = projectionBlock.getNumDocs();
            if (dataType == FieldSpec.DataType.STRING) {
                evalStrings = transformFunction.transformToStringValuesSV(projectionBlock);
            } else {
                evalStrings = new String[blockNumDocs];
                switch (dataType) {
                    case INT: {
                        ArrayCopyUtils.copy(transformFunction.transformToIntValuesSV(projectionBlock), evalStrings, blockNumDocs);
                        break;
                    }
                    case LONG: {
                        ArrayCopyUtils.copy(transformFunction.transformToLongValuesSV(projectionBlock), evalStrings, blockNumDocs);
                        break;
                    }
                    case FLOAT: {
                        ArrayCopyUtils.copy(transformFunction.transformToFloatValuesSV(projectionBlock), evalStrings, blockNumDocs);
                        break;
                    }
                    case DOUBLE: {
                        ArrayCopyUtils.copy(transformFunction.transformToDoubleValuesSV(projectionBlock), evalStrings, blockNumDocs);
                        break;
                    }
                    case BYTES: {
                        ArrayCopyUtils.copy(transformFunction.transformToBytesValuesSV(projectionBlock), evalStrings, blockNumDocs);
                        break;
                    }
                    default: {
                        throw new IllegalStateException(String.format("Cannot convert result type [%s] to [STRING] for transform function [%s]", dataType, transformFunction));
                    }
                }
            }
            for (int j = 0; j < blockNumDocs; ++j) {
                if (selected[j] != i) continue;
                this._stringResults[j] = evalStrings[j];
            }
        }
        return this._stringResults;
    }
}

