/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.core.util.ArrayCopyUtils;
import org.apache.pinot.spi.data.FieldSpec;

public abstract class BaseTransformFunction
implements TransformFunction {
    protected static final TransformResultMetadata INT_SV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.INT, true, false);
    protected static final TransformResultMetadata LONG_SV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.LONG, true, false);
    protected static final TransformResultMetadata DOUBLE_SV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.DOUBLE, true, false);
    protected static final TransformResultMetadata STRING_SV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.STRING, true, false);
    protected static final TransformResultMetadata STRING_MV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.STRING, false, false);
    protected static final TransformResultMetadata BYTES_SV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.BYTES, true, false);
    private int[] _intValuesSV;
    private long[] _longValuesSV;
    private float[] _floatValuesSV;
    private double[] _doubleValuesSV;
    private String[] _stringValuesSV;
    private byte[][] _byteValuesSV;
    private int[][] _intValuesMV;
    private long[][] _longValuesMV;
    private float[][] _floatValuesMV;
    private double[][] _doubleValuesMV;
    private String[][] _stringValuesMV;

    @Override
    public Dictionary getDictionary() {
        return null;
    }

    @Override
    public int[] transformToDictIdsSV(ProjectionBlock projectionBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[][] transformToDictIdsMV(ProjectionBlock projectionBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] transformToIntValuesSV(ProjectionBlock projectionBlock) {
        if (this._intValuesSV == null) {
            this._intValuesSV = new int[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        int length = projectionBlock.getNumDocs();
        Dictionary dictionary = this.getDictionary();
        if (dictionary != null) {
            int[] dictIds = this.transformToDictIdsSV(projectionBlock);
            dictionary.readIntValues(dictIds, length, this._intValuesSV);
        } else {
            switch (this.getResultMetadata().getDataType()) {
                case LONG: {
                    long[] longValues = this.transformToLongValuesSV(projectionBlock);
                    ArrayCopyUtils.copy(longValues, this._intValuesSV, length);
                    break;
                }
                case FLOAT: {
                    float[] floatValues = this.transformToFloatValuesSV(projectionBlock);
                    ArrayCopyUtils.copy(floatValues, this._intValuesSV, length);
                    break;
                }
                case DOUBLE: {
                    double[] doubleValues = this.transformToDoubleValuesSV(projectionBlock);
                    ArrayCopyUtils.copy(doubleValues, this._intValuesSV, length);
                    break;
                }
                case STRING: {
                    String[] stringValues = this.transformToStringValuesSV(projectionBlock);
                    ArrayCopyUtils.copy(stringValues, this._intValuesSV, length);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return this._intValuesSV;
    }

    @Override
    public long[] transformToLongValuesSV(ProjectionBlock projectionBlock) {
        if (this._longValuesSV == null) {
            this._longValuesSV = new long[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        int length = projectionBlock.getNumDocs();
        Dictionary dictionary = this.getDictionary();
        if (dictionary != null) {
            int[] dictIds = this.transformToDictIdsSV(projectionBlock);
            dictionary.readLongValues(dictIds, length, this._longValuesSV);
        } else {
            switch (this.getResultMetadata().getDataType()) {
                case INT: {
                    int[] intValues = this.transformToIntValuesSV(projectionBlock);
                    ArrayCopyUtils.copy(intValues, this._longValuesSV, length);
                    break;
                }
                case FLOAT: {
                    float[] floatValues = this.transformToFloatValuesSV(projectionBlock);
                    ArrayCopyUtils.copy(floatValues, this._longValuesSV, length);
                    break;
                }
                case DOUBLE: {
                    double[] doubleValues = this.transformToDoubleValuesSV(projectionBlock);
                    ArrayCopyUtils.copy(doubleValues, this._longValuesSV, length);
                    break;
                }
                case STRING: {
                    String[] stringValues = this.transformToStringValuesSV(projectionBlock);
                    ArrayCopyUtils.copy(stringValues, this._longValuesSV, length);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return this._longValuesSV;
    }

    @Override
    public float[] transformToFloatValuesSV(ProjectionBlock projectionBlock) {
        if (this._floatValuesSV == null) {
            this._floatValuesSV = new float[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        int length = projectionBlock.getNumDocs();
        Dictionary dictionary = this.getDictionary();
        if (dictionary != null) {
            int[] dictIds = this.transformToDictIdsSV(projectionBlock);
            dictionary.readFloatValues(dictIds, length, this._floatValuesSV);
        } else {
            switch (this.getResultMetadata().getDataType()) {
                case INT: {
                    int[] intValues = this.transformToIntValuesSV(projectionBlock);
                    ArrayCopyUtils.copy(intValues, this._floatValuesSV, length);
                    break;
                }
                case LONG: {
                    long[] longValues = this.transformToLongValuesSV(projectionBlock);
                    ArrayCopyUtils.copy(longValues, this._floatValuesSV, length);
                    break;
                }
                case DOUBLE: {
                    double[] doubleValues = this.transformToDoubleValuesSV(projectionBlock);
                    ArrayCopyUtils.copy(doubleValues, this._floatValuesSV, length);
                    break;
                }
                case STRING: {
                    String[] stringValues = this.transformToStringValuesSV(projectionBlock);
                    ArrayCopyUtils.copy(stringValues, this._floatValuesSV, length);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return this._floatValuesSV;
    }

    @Override
    public double[] transformToDoubleValuesSV(ProjectionBlock projectionBlock) {
        if (this._doubleValuesSV == null) {
            this._doubleValuesSV = new double[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        int length = projectionBlock.getNumDocs();
        Dictionary dictionary = this.getDictionary();
        if (dictionary != null) {
            int[] dictIds = this.transformToDictIdsSV(projectionBlock);
            dictionary.readDoubleValues(dictIds, length, this._doubleValuesSV);
        } else {
            switch (this.getResultMetadata().getDataType()) {
                case INT: {
                    int[] intValues = this.transformToIntValuesSV(projectionBlock);
                    ArrayCopyUtils.copy(intValues, this._doubleValuesSV, length);
                    break;
                }
                case LONG: {
                    long[] longValues = this.transformToLongValuesSV(projectionBlock);
                    ArrayCopyUtils.copy(longValues, this._doubleValuesSV, length);
                    break;
                }
                case FLOAT: {
                    float[] floatValues = this.transformToFloatValuesSV(projectionBlock);
                    ArrayCopyUtils.copy(floatValues, this._doubleValuesSV, length);
                    break;
                }
                case STRING: {
                    String[] stringValues = this.transformToStringValuesSV(projectionBlock);
                    ArrayCopyUtils.copy(stringValues, this._doubleValuesSV, length);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return this._doubleValuesSV;
    }

    @Override
    public String[] transformToStringValuesSV(ProjectionBlock projectionBlock) {
        if (this._stringValuesSV == null) {
            this._stringValuesSV = new String[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        int length = projectionBlock.getNumDocs();
        Dictionary dictionary = this.getDictionary();
        if (dictionary != null) {
            int[] dictIds = this.transformToDictIdsSV(projectionBlock);
            dictionary.readStringValues(dictIds, length, this._stringValuesSV);
        } else {
            switch (this.getResultMetadata().getDataType()) {
                case INT: {
                    int[] intValues = this.transformToIntValuesSV(projectionBlock);
                    ArrayCopyUtils.copy(intValues, this._stringValuesSV, length);
                    break;
                }
                case LONG: {
                    long[] longValues = this.transformToLongValuesSV(projectionBlock);
                    ArrayCopyUtils.copy(longValues, this._stringValuesSV, length);
                    break;
                }
                case FLOAT: {
                    float[] floatValues = this.transformToFloatValuesSV(projectionBlock);
                    ArrayCopyUtils.copy(floatValues, this._stringValuesSV, length);
                    break;
                }
                case DOUBLE: {
                    double[] doubleValues = this.transformToDoubleValuesSV(projectionBlock);
                    ArrayCopyUtils.copy(doubleValues, this._stringValuesSV, length);
                    break;
                }
                case BYTES: {
                    byte[][] bytesValues = this.transformToBytesValuesSV(projectionBlock);
                    ArrayCopyUtils.copy(bytesValues, this._stringValuesSV, length);
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return this._stringValuesSV;
    }

    @Override
    public byte[][] transformToBytesValuesSV(ProjectionBlock projectionBlock) {
        if (this._byteValuesSV == null) {
            this._byteValuesSV = new byte[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
        }
        int length = projectionBlock.getNumDocs();
        Dictionary dictionary = this.getDictionary();
        if (dictionary != null) {
            int[] dictIds = this.transformToDictIdsSV(projectionBlock);
            dictionary.readIntValues(dictIds, length, this._intValuesSV);
        } else {
            Preconditions.checkState((this.getResultMetadata().getDataType() == FieldSpec.DataType.STRING ? 1 : 0) != 0);
            String[] stringValues = this.transformToStringValuesSV(projectionBlock);
            ArrayCopyUtils.copy(stringValues, this._byteValuesSV, length);
        }
        return this._byteValuesSV;
    }

    @Override
    public int[][] transformToIntValuesMV(ProjectionBlock projectionBlock) {
        if (this._intValuesMV == null) {
            this._intValuesMV = new int[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
        }
        int length = projectionBlock.getNumDocs();
        Dictionary dictionary = this.getDictionary();
        if (dictionary != null) {
            int[][] dictIdsMV = this.transformToDictIdsMV(projectionBlock);
            for (int i = 0; i < length; ++i) {
                int[] dictIds = dictIdsMV[i];
                int numValues = dictIds.length;
                int[] intValues = new int[numValues];
                dictionary.readIntValues(dictIds, numValues, intValues);
                this._intValuesMV[i] = intValues;
            }
        } else {
            switch (this.getResultMetadata().getDataType()) {
                case LONG: {
                    long[][] longValuesMV = this.transformToLongValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        long[] longValues = longValuesMV[i];
                        int numValues = longValues.length;
                        int[] intValues = new int[numValues];
                        ArrayCopyUtils.copy(longValues, intValues, numValues);
                        this._intValuesMV[i] = intValues;
                    }
                    break;
                }
                case FLOAT: {
                    float[][] floatValuesMV = this.transformToFloatValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        float[] floatValues = floatValuesMV[i];
                        int numValues = floatValues.length;
                        int[] intValues = new int[numValues];
                        ArrayCopyUtils.copy(floatValues, intValues, numValues);
                        this._intValuesMV[i] = intValues;
                    }
                    break;
                }
                case DOUBLE: {
                    double[][] doubleValuesMV = this.transformToDoubleValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        double[] doubleValues = doubleValuesMV[i];
                        int numValues = doubleValues.length;
                        int[] intValues = new int[numValues];
                        ArrayCopyUtils.copy(doubleValues, intValues, numValues);
                        this._intValuesMV[i] = intValues;
                    }
                    break;
                }
                case STRING: {
                    String[][] stringValuesMV = this.transformToStringValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        String[] stringValues = stringValuesMV[i];
                        int numValues = stringValues.length;
                        int[] intValues = new int[numValues];
                        ArrayCopyUtils.copy(stringValues, intValues, numValues);
                        this._intValuesMV[i] = intValues;
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return this._intValuesMV;
    }

    @Override
    public long[][] transformToLongValuesMV(ProjectionBlock projectionBlock) {
        if (this._longValuesMV == null) {
            this._longValuesMV = new long[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
        }
        int length = projectionBlock.getNumDocs();
        Dictionary dictionary = this.getDictionary();
        if (dictionary != null) {
            int[][] dictIdsMV = this.transformToDictIdsMV(projectionBlock);
            for (int i = 0; i < length; ++i) {
                int[] dictIds = dictIdsMV[i];
                int numValues = dictIds.length;
                long[] longValues = new long[numValues];
                dictionary.readLongValues(dictIds, numValues, longValues);
                this._longValuesMV[i] = longValues;
            }
        } else {
            switch (this.getResultMetadata().getDataType()) {
                case INT: {
                    int[][] intValuesMV = this.transformToIntValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        int[] intValues = intValuesMV[i];
                        int numValues = intValues.length;
                        long[] longValues = new long[numValues];
                        ArrayCopyUtils.copy(intValues, longValues, numValues);
                        this._longValuesMV[i] = longValues;
                    }
                    break;
                }
                case FLOAT: {
                    float[][] floatValuesMV = this.transformToFloatValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        float[] floatValues = floatValuesMV[i];
                        int numValues = floatValues.length;
                        long[] longValues = new long[numValues];
                        ArrayCopyUtils.copy(floatValues, longValues, numValues);
                        this._longValuesMV[i] = longValues;
                    }
                    break;
                }
                case DOUBLE: {
                    double[][] doubleValuesMV = this.transformToDoubleValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        double[] doubleValues = doubleValuesMV[i];
                        int numValues = doubleValues.length;
                        long[] longValues = new long[numValues];
                        ArrayCopyUtils.copy(doubleValues, longValues, numValues);
                        this._longValuesMV[i] = longValues;
                    }
                    break;
                }
                case STRING: {
                    String[][] stringValuesMV = this.transformToStringValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        String[] stringValues = stringValuesMV[i];
                        int numValues = stringValues.length;
                        long[] longValues = new long[numValues];
                        ArrayCopyUtils.copy(stringValues, longValues, numValues);
                        this._longValuesMV[i] = longValues;
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return this._longValuesMV;
    }

    @Override
    public float[][] transformToFloatValuesMV(ProjectionBlock projectionBlock) {
        if (this._floatValuesMV == null) {
            this._floatValuesMV = new float[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
        }
        int length = projectionBlock.getNumDocs();
        Dictionary dictionary = this.getDictionary();
        if (dictionary != null) {
            int[][] dictIdsMV = this.transformToDictIdsMV(projectionBlock);
            for (int i = 0; i < length; ++i) {
                int[] dictIds = dictIdsMV[i];
                int numValues = dictIds.length;
                float[] floatValues = new float[numValues];
                dictionary.readFloatValues(dictIds, numValues, floatValues);
                this._floatValuesMV[i] = floatValues;
            }
        } else {
            switch (this.getResultMetadata().getDataType()) {
                case INT: {
                    int[][] intValuesMV = this.transformToIntValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        int[] intValues = intValuesMV[i];
                        int numValues = intValues.length;
                        float[] floatValues = new float[numValues];
                        ArrayCopyUtils.copy(intValues, floatValues, numValues);
                        this._floatValuesMV[i] = floatValues;
                    }
                    break;
                }
                case LONG: {
                    long[][] longValuesMV = this.transformToLongValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        long[] longValues = longValuesMV[i];
                        int numValues = longValues.length;
                        float[] floatValues = new float[numValues];
                        ArrayCopyUtils.copy(longValues, floatValues, numValues);
                        this._floatValuesMV[i] = floatValues;
                    }
                    break;
                }
                case DOUBLE: {
                    double[][] doubleValuesMV = this.transformToDoubleValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        double[] doubleValues = doubleValuesMV[i];
                        int numValues = doubleValues.length;
                        float[] floatValues = new float[numValues];
                        ArrayCopyUtils.copy(doubleValues, floatValues, numValues);
                        this._floatValuesMV[i] = floatValues;
                    }
                    break;
                }
                case STRING: {
                    String[][] stringValuesMV = this.transformToStringValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        String[] stringValues = stringValuesMV[i];
                        int numValues = stringValues.length;
                        float[] floatValues = new float[numValues];
                        ArrayCopyUtils.copy(stringValues, floatValues, numValues);
                        this._floatValuesMV[i] = floatValues;
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return this._floatValuesMV;
    }

    @Override
    public double[][] transformToDoubleValuesMV(ProjectionBlock projectionBlock) {
        if (this._doubleValuesMV == null) {
            this._doubleValuesMV = new double[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
        }
        int length = projectionBlock.getNumDocs();
        Dictionary dictionary = this.getDictionary();
        if (dictionary != null) {
            int[][] dictIdsMV = this.transformToDictIdsMV(projectionBlock);
            for (int i = 0; i < length; ++i) {
                int[] dictIds = dictIdsMV[i];
                int numValues = dictIds.length;
                double[] doubleValues = new double[numValues];
                dictionary.readDoubleValues(dictIds, numValues, doubleValues);
                this._doubleValuesMV[i] = doubleValues;
            }
        } else {
            switch (this.getResultMetadata().getDataType()) {
                case INT: {
                    int[][] intValuesMV = this.transformToIntValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        int[] intValues = intValuesMV[i];
                        int numValues = intValues.length;
                        double[] doubleValues = new double[numValues];
                        ArrayCopyUtils.copy(intValues, doubleValues, numValues);
                        this._doubleValuesMV[i] = doubleValues;
                    }
                    break;
                }
                case LONG: {
                    long[][] longValuesMV = this.transformToLongValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        long[] longValues = longValuesMV[i];
                        int numValues = longValues.length;
                        double[] doubleValues = new double[numValues];
                        ArrayCopyUtils.copy(longValues, doubleValues, numValues);
                        this._doubleValuesMV[i] = doubleValues;
                    }
                    break;
                }
                case FLOAT: {
                    float[][] floatValuesMV = this.transformToFloatValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        float[] floatValues = floatValuesMV[i];
                        int numValues = floatValues.length;
                        double[] doubleValues = new double[numValues];
                        ArrayCopyUtils.copy(floatValues, doubleValues, numValues);
                        this._doubleValuesMV[i] = doubleValues;
                    }
                    break;
                }
                case STRING: {
                    String[][] stringValuesMV = this.transformToStringValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        String[] stringValues = stringValuesMV[i];
                        int numValues = stringValues.length;
                        double[] doubleValues = new double[numValues];
                        ArrayCopyUtils.copy(stringValues, doubleValues, numValues);
                        this._doubleValuesMV[i] = doubleValues;
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return this._doubleValuesMV;
    }

    @Override
    public String[][] transformToStringValuesMV(ProjectionBlock projectionBlock) {
        if (this._stringValuesMV == null) {
            this._stringValuesMV = new String[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
        }
        int length = projectionBlock.getNumDocs();
        Dictionary dictionary = this.getDictionary();
        if (dictionary != null) {
            int[][] dictIdsMV = this.transformToDictIdsMV(projectionBlock);
            for (int i = 0; i < length; ++i) {
                int[] dictIds = dictIdsMV[i];
                int numValues = dictIds.length;
                String[] stringValues = new String[numValues];
                dictionary.readStringValues(dictIds, numValues, stringValues);
                this._stringValuesMV[i] = stringValues;
            }
        } else {
            switch (this.getResultMetadata().getDataType()) {
                case INT: {
                    int[][] intValuesMV = this.transformToIntValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        int[] intValues = intValuesMV[i];
                        int numValues = intValues.length;
                        String[] stringValues = new String[numValues];
                        ArrayCopyUtils.copy(intValues, stringValues, numValues);
                        this._stringValuesMV[i] = stringValues;
                    }
                    break;
                }
                case LONG: {
                    long[][] longValuesMV = this.transformToLongValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        long[] longValues = longValuesMV[i];
                        int numValues = longValues.length;
                        String[] stringValues = new String[numValues];
                        ArrayCopyUtils.copy(longValues, stringValues, numValues);
                        this._stringValuesMV[i] = stringValues;
                    }
                    break;
                }
                case FLOAT: {
                    float[][] floatValuesMV = this.transformToFloatValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        float[] floatValues = floatValuesMV[i];
                        int numValues = floatValues.length;
                        String[] stringValues = new String[numValues];
                        ArrayCopyUtils.copy(floatValues, stringValues, numValues);
                        this._stringValuesMV[i] = stringValues;
                    }
                    break;
                }
                case DOUBLE: {
                    double[][] doubleValuesMV = this.transformToDoubleValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        double[] doubleValues = doubleValuesMV[i];
                        int numValues = doubleValues.length;
                        String[] stringValues = new String[numValues];
                        ArrayCopyUtils.copy(doubleValues, stringValues, numValues);
                        this._stringValuesMV[i] = stringValues;
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return this._stringValuesMV;
    }
}

