/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.core.common.DataSource;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.ProjectionOperator;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunctionFactory;
import org.apache.pinot.core.query.request.context.ExpressionContext;
import org.apache.pinot.core.segment.index.readers.Dictionary;

public class TransformOperator
extends BaseOperator<TransformBlock> {
    private static final String OPERATOR_NAME = "TransformOperator";
    private final ProjectionOperator _projectionOperator;
    private final Map<String, DataSource> _dataSourceMap;
    private final Map<ExpressionContext, TransformFunction> _transformFunctionMap = new HashMap<ExpressionContext, TransformFunction>();

    public TransformOperator(ProjectionOperator projectionOperator, Collection<ExpressionContext> expressions) {
        this._projectionOperator = projectionOperator;
        this._dataSourceMap = projectionOperator.getDataSourceMap();
        for (ExpressionContext expression : expressions) {
            TransformFunction transformFunction = TransformFunctionFactory.get(expression, this._dataSourceMap);
            this._transformFunctionMap.put(expression, transformFunction);
        }
    }

    public int getNumColumnsProjected() {
        return this._dataSourceMap.size();
    }

    public TransformResultMetadata getResultMetadata(ExpressionContext expression) {
        return this._transformFunctionMap.get(expression).getResultMetadata();
    }

    public Dictionary getDictionary(ExpressionContext expression) {
        return this._transformFunctionMap.get(expression).getDictionary();
    }

    @Override
    protected TransformBlock getNextBlock() {
        ProjectionBlock projectionBlock = (ProjectionBlock)this._projectionOperator.nextBlock();
        if (projectionBlock == null) {
            return null;
        }
        return new TransformBlock(projectionBlock, this._transformFunctionMap);
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        return this._projectionOperator.getExecutionStatistics();
    }
}

