/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.streaming;

import io.grpc.stub.StreamObserver;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.proto.Server;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.core.operator.combine.CombineOperatorUtils;
import org.apache.pinot.core.operator.streaming.StreamingResponseUtils;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.selection.SelectionOperatorUtils;
import org.apache.pinot.core.util.trace.TraceRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingSelectionOnlyCombineOperator
extends BaseOperator<IntermediateResultsBlock> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamingSelectionOnlyCombineOperator.class);
    private static final String OPERATOR_NAME = "StreamingSelectionOnlyCombineOperator";
    private static final IntermediateResultsBlock LAST_RESULTS_BLOCK = new IntermediateResultsBlock(new DataSchema(new String[0], new DataSchema.ColumnDataType[0]), Collections.emptyList());
    private final List<Operator> _operators;
    private final QueryContext _queryContext;
    private final ExecutorService _executorService;
    private final long _endTimeMs;
    private final StreamObserver<Server.ServerResponse> _streamObserver;
    private final int _limit;

    public StreamingSelectionOnlyCombineOperator(List<Operator> operators, QueryContext queryContext, ExecutorService executorService, long endTimeMs, StreamObserver<Server.ServerResponse> streamObserver) {
        this._operators = operators;
        this._queryContext = queryContext;
        this._executorService = executorService;
        this._endTimeMs = endTimeMs;
        this._streamObserver = streamObserver;
        this._limit = queryContext.getLimit();
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IntermediateResultsBlock getNextBlock() {
        final int numOperators = this._operators.size();
        final int numThreads = CombineOperatorUtils.getNumThreadsForQuery(numOperators);
        final LinkedBlockingQueue blockingQueue = new LinkedBlockingQueue();
        final Phaser phaser = new Phaser(1);
        Future[] futures = new Future[numThreads];
        for (int i = 0; i < numThreads; ++i) {
            final int threadIndex = i;
            futures[i] = this._executorService.submit(new TraceRunnable(){

                /*
                 * Exception decompiling
                 */
                @Override
                public void runJob() {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[UNCONDITIONALDOLOOP]], but top level block is 4[TRYBLOCK]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            });
        }
        try {
            IntermediateResultsBlock intermediateResultsBlock;
            int numRowsCollected = 0;
            int numOperatorsFinished = 0;
            while (numRowsCollected < this._limit && numOperatorsFinished < numOperators) {
                IntermediateResultsBlock resultsBlock = (IntermediateResultsBlock)blockingQueue.poll(this._endTimeMs - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                if (resultsBlock == null) {
                    LOGGER.error("Timed out while polling results block (query: {})", (Object)this._queryContext);
                    intermediateResultsBlock = new IntermediateResultsBlock((Exception)QueryException.getException((ProcessingException)QueryException.EXECUTION_TIMEOUT_ERROR, (Exception)new TimeoutException("Timed out while polling results block")));
                    return intermediateResultsBlock;
                }
                if (resultsBlock.getProcessingExceptions() != null) {
                    intermediateResultsBlock = resultsBlock;
                    return intermediateResultsBlock;
                }
                if (resultsBlock == LAST_RESULTS_BLOCK) {
                    ++numOperatorsFinished;
                    continue;
                }
                DataSchema dataSchema = resultsBlock.getDataSchema();
                Collection<Object[]> rows = resultsBlock.getSelectionResult();
                assert (dataSchema != null && rows != null);
                numRowsCollected += rows.size();
                DataTable dataTable = SelectionOperatorUtils.getDataTableFromRows(rows, dataSchema);
                this._streamObserver.onNext((Object)StreamingResponseUtils.getDataResponse(dataTable));
            }
            IntermediateResultsBlock metadataBlock = new IntermediateResultsBlock();
            CombineOperatorUtils.setExecutionStatistics(metadataBlock, this._operators);
            intermediateResultsBlock = metadataBlock;
            return intermediateResultsBlock;
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while streaming results blocks (query: {})", (Object)this._queryContext, (Object)e);
            IntermediateResultsBlock intermediateResultsBlock = new IntermediateResultsBlock(QueryException.INTERNAL_ERROR, e);
            return intermediateResultsBlock;
        }
        finally {
            for (Future future : futures) {
                if (future.isDone()) continue;
                future.cancel(true);
            }
            phaser.awaitAdvance(phaser.arriveAndDeregister());
        }
    }

    static /* synthetic */ List access$000(StreamingSelectionOnlyCombineOperator x0) {
        return x0._operators;
    }

    static /* synthetic */ int access$100(StreamingSelectionOnlyCombineOperator x0) {
        return x0._limit;
    }

    static /* synthetic */ IntermediateResultsBlock access$200() {
        return LAST_RESULTS_BLOCK;
    }

    static /* synthetic */ QueryContext access$300(StreamingSelectionOnlyCombineOperator x0) {
        return x0._queryContext;
    }

    static /* synthetic */ Logger access$400() {
        return LOGGER;
    }
}

