/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.streaming;

import com.google.protobuf.ByteString;
import java.io.IOException;
import org.apache.pinot.common.proto.Server;
import org.apache.pinot.common.utils.DataTable;

public class StreamingResponseUtils {
    private StreamingResponseUtils() {
    }

    public static Server.ServerResponse getDataResponse(DataTable dataTable) throws IOException {
        return StreamingResponseUtils.getResponse(dataTable, "data");
    }

    public static Server.ServerResponse getMetadataResponse(DataTable dataTable) throws IOException {
        return StreamingResponseUtils.getResponse(dataTable, "metadata");
    }

    public static Server.ServerResponse getNonStreamingResponse(DataTable dataTable) throws IOException {
        return StreamingResponseUtils.getResponse(dataTable, "nonStreaming");
    }

    private static Server.ServerResponse getResponse(DataTable dataTable, String responseType) throws IOException {
        return Server.ServerResponse.newBuilder().putMetadata("responseType", responseType).setPayload(ByteString.copyFrom((byte[])dataTable.toBytes())).build();
    }
}

