/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.query;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.DataSource;
import org.apache.pinot.core.common.RowBasedBlockValueFetcher;
import org.apache.pinot.core.indexsegment.IndexSegment;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.ProjectionOperator;
import org.apache.pinot.core.operator.blocks.DocIdSetBlock;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.core.query.request.context.ExpressionContext;
import org.apache.pinot.core.query.request.context.OrderByExpressionContext;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.selection.SelectionOperatorUtils;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ByteArray;
import org.roaringbitmap.IntIterator;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class SelectionOrderByOperator
extends BaseOperator<IntermediateResultsBlock> {
    private static final String OPERATOR_NAME = "SelectionOrderByOperator";
    private final IndexSegment _indexSegment;
    private final List<ExpressionContext> _expressions;
    private final TransformOperator _transformOperator;
    private final List<OrderByExpressionContext> _orderByExpressions;
    private final TransformResultMetadata[] _orderByExpressionMetadata;
    private final int _numRowsToKeep;
    private final PriorityQueue<Object[]> _rows;
    private int _numDocsScanned = 0;
    private long _numEntriesScannedPostFilter = 0L;

    public SelectionOrderByOperator(IndexSegment indexSegment, QueryContext queryContext, List<ExpressionContext> expressions, TransformOperator transformOperator) {
        this._indexSegment = indexSegment;
        this._expressions = expressions;
        this._transformOperator = transformOperator;
        this._orderByExpressions = queryContext.getOrderByExpressions();
        assert (this._orderByExpressions != null);
        int numOrderByExpressions = this._orderByExpressions.size();
        this._orderByExpressionMetadata = new TransformResultMetadata[numOrderByExpressions];
        for (int i = 0; i < numOrderByExpressions; ++i) {
            ExpressionContext expression = this._orderByExpressions.get(i).getExpression();
            this._orderByExpressionMetadata[i] = this._transformOperator.getResultMetadata(expression);
        }
        this._numRowsToKeep = queryContext.getOffset() + queryContext.getLimit();
        this._rows = new PriorityQueue<Object[]>(Math.min(this._numRowsToKeep, 10000), this.getComparator());
    }

    private Comparator<Object[]> getComparator() {
        int numOrderByExpressions = this._orderByExpressions.size();
        ArrayList<Integer> valueIndexList = new ArrayList<Integer>(numOrderByExpressions);
        for (int i = 0; i < numOrderByExpressions; ++i) {
            if (!this._orderByExpressionMetadata[i].isSingleValue()) continue;
            valueIndexList.add(i);
        }
        int numValuesToCompare = valueIndexList.size();
        int[] valueIndices = new int[numValuesToCompare];
        FieldSpec.DataType[] dataTypes = new FieldSpec.DataType[numValuesToCompare];
        int[] multipliers = new int[numValuesToCompare];
        for (int i = 0; i < numValuesToCompare; ++i) {
            int valueIndex;
            valueIndices[i] = valueIndex = ((Integer)valueIndexList.get(i)).intValue();
            dataTypes[i] = this._orderByExpressionMetadata[valueIndex].getDataType();
            multipliers[i] = this._orderByExpressions.get(valueIndex).isAsc() ? -1 : 1;
        }
        return (o1, o2) -> {
            for (int i = 0; i < numValuesToCompare; ++i) {
                int result;
                int index = valueIndices[i];
                Object v1 = o1[index];
                Object v2 = o2[index];
                switch (dataTypes[i]) {
                    case INT: {
                        result = ((Integer)v1).compareTo((Integer)v2);
                        break;
                    }
                    case LONG: {
                        result = ((Long)v1).compareTo((Long)v2);
                        break;
                    }
                    case FLOAT: {
                        result = ((Float)v1).compareTo((Float)v2);
                        break;
                    }
                    case DOUBLE: {
                        result = ((Double)v1).compareTo((Double)v2);
                        break;
                    }
                    case STRING: {
                        result = ((String)v1).compareTo((String)v2);
                        break;
                    }
                    case BYTES: {
                        result = ((ByteArray)v1).compareTo((ByteArray)v2);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                if (result == 0) continue;
                return result * multipliers[i];
            }
            return 0;
        };
    }

    public IndexSegment getIndexSegment() {
        return this._indexSegment;
    }

    @Override
    protected IntermediateResultsBlock getNextBlock() {
        if (this._expressions.size() == this._orderByExpressions.size()) {
            return this.computeAllOrdered();
        }
        return this.computePartiallyOrdered();
    }

    private IntermediateResultsBlock computeAllOrdered() {
        int i;
        TransformBlock transformBlock;
        int numExpressions = this._expressions.size();
        BlockValSet[] blockValSets = new BlockValSet[numExpressions];
        int numColumnsProjected = this._transformOperator.getNumColumnsProjected();
        while ((transformBlock = (TransformBlock)this._transformOperator.nextBlock()) != null) {
            for (int i2 = 0; i2 < numExpressions; ++i2) {
                ExpressionContext expression = this._expressions.get(i2);
                blockValSets[i2] = transformBlock.getBlockValueSet(expression);
            }
            RowBasedBlockValueFetcher blockValueFetcher = new RowBasedBlockValueFetcher(blockValSets);
            int numDocsFetched = transformBlock.getNumDocs();
            for (i = 0; i < numDocsFetched; ++i) {
                SelectionOperatorUtils.addToPriorityQueue(blockValueFetcher.getRow(i), this._rows, this._numRowsToKeep);
            }
            this._numDocsScanned += numDocsFetched;
            this._numEntriesScannedPostFilter += (long)(numDocsFetched * numColumnsProjected);
        }
        String[] columnNames = new String[numExpressions];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numExpressions];
        for (i = 0; i < numExpressions; ++i) {
            columnNames[i] = this._expressions.get(i).toString();
            TransformResultMetadata expressionMetadata = this._orderByExpressionMetadata[i];
            columnDataTypes[i] = DataSchema.ColumnDataType.fromDataType((FieldSpec.DataType)expressionMetadata.getDataType(), (boolean)expressionMetadata.isSingleValue());
        }
        DataSchema dataSchema = new DataSchema(columnNames, columnDataTypes);
        return new IntermediateResultsBlock(dataSchema, this._rows);
    }

    private IntermediateResultsBlock computePartiallyOrdered() {
        TransformResultMetadata expressionMetadata;
        int i;
        TransformBlock transformBlock;
        int numExpressions = this._expressions.size();
        int numOrderByExpressions = this._orderByExpressions.size();
        BlockValSet[] blockValSets = new BlockValSet[numOrderByExpressions + 1];
        int numColumnsProjected = this._transformOperator.getNumColumnsProjected();
        while ((transformBlock = (TransformBlock)this._transformOperator.nextBlock()) != null) {
            for (int i2 = 0; i2 < numOrderByExpressions; ++i2) {
                ExpressionContext expression = this._orderByExpressions.get(i2).getExpression();
                blockValSets[i2] = transformBlock.getBlockValueSet(expression);
            }
            blockValSets[numOrderByExpressions] = transformBlock.getBlockValueSet("$docId");
            RowBasedBlockValueFetcher blockValueFetcher = new RowBasedBlockValueFetcher(blockValSets);
            int numDocsFetched = transformBlock.getNumDocs();
            for (int i3 = 0; i3 < numDocsFetched; ++i3) {
                Object[] row = new Object[numExpressions];
                blockValueFetcher.getRow(i3, row, 0);
                SelectionOperatorUtils.addToPriorityQueue(row, this._rows, this._numRowsToKeep);
            }
            this._numDocsScanned += numDocsFetched;
            this._numEntriesScannedPostFilter += (long)(numDocsFetched * numColumnsProjected);
        }
        int numRows = this._rows.size();
        ArrayList<Object[]> rowList = new ArrayList<Object[]>(numRows);
        MutableRoaringBitmap docIds = new MutableRoaringBitmap();
        for (Object[] row : this._rows) {
            rowList.add(row);
            int docId = (Integer)row[numOrderByExpressions];
            docIds.add(docId);
        }
        rowList.sort(Comparator.comparingInt(o -> (Integer)o[numOrderByExpressions]));
        List<ExpressionContext> nonOrderByExpressions = this._expressions.subList(numOrderByExpressions, numExpressions);
        HashSet<String> columns = new HashSet<String>();
        for (ExpressionContext expressionContext : nonOrderByExpressions) {
            expressionContext.getColumns(columns);
        }
        int numColumns = columns.size();
        HashMap<String, DataSource> dataSourceMap = new HashMap<String, DataSource>();
        for (String column : columns) {
            dataSourceMap.put(column, this._indexSegment.getDataSource(column));
        }
        ProjectionOperator projectionOperator = new ProjectionOperator(dataSourceMap, new BitmapDocIdSetOperator((ImmutableRoaringBitmap)docIds, numRows));
        TransformOperator transformOperator = new TransformOperator(projectionOperator, nonOrderByExpressions);
        int numNonOrderByExpressions = nonOrderByExpressions.size();
        blockValSets = new BlockValSet[numNonOrderByExpressions];
        int rowBaseId = 0;
        while ((transformBlock = (TransformBlock)transformOperator.nextBlock()) != null) {
            for (int i4 = 0; i4 < numNonOrderByExpressions; ++i4) {
                ExpressionContext expression = nonOrderByExpressions.get(i4);
                blockValSets[i4] = transformBlock.getBlockValueSet(expression);
            }
            RowBasedBlockValueFetcher blockValueFetcher = new RowBasedBlockValueFetcher(blockValSets);
            int numDocsFetched = transformBlock.getNumDocs();
            for (i = 0; i < numDocsFetched; ++i) {
                blockValueFetcher.getRow(i, (Object[])rowList.get(rowBaseId + i), numOrderByExpressions);
            }
            this._numEntriesScannedPostFilter += (long)(numDocsFetched * numColumns);
            rowBaseId += numDocsFetched;
        }
        String[] columnNames = new String[numExpressions];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numExpressions];
        for (i = 0; i < numExpressions; ++i) {
            columnNames[i] = this._expressions.get(i).toString();
        }
        for (i = 0; i < numOrderByExpressions; ++i) {
            expressionMetadata = this._orderByExpressionMetadata[i];
            columnDataTypes[i] = DataSchema.ColumnDataType.fromDataType((FieldSpec.DataType)expressionMetadata.getDataType(), (boolean)expressionMetadata.isSingleValue());
        }
        for (i = 0; i < numNonOrderByExpressions; ++i) {
            expressionMetadata = transformOperator.getResultMetadata(nonOrderByExpressions.get(i));
            columnDataTypes[numOrderByExpressions + i] = DataSchema.ColumnDataType.fromDataType((FieldSpec.DataType)expressionMetadata.getDataType(), (boolean)expressionMetadata.isSingleValue());
        }
        DataSchema dataSchema = new DataSchema(columnNames, columnDataTypes);
        return new IntermediateResultsBlock(dataSchema, this._rows);
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        long numEntriesScannedInFilter = this._transformOperator.getExecutionStatistics().getNumEntriesScannedInFilter();
        int numTotalDocs = this._indexSegment.getSegmentMetadata().getTotalDocs();
        return new ExecutionStatistics(this._numDocsScanned, numEntriesScannedInFilter, this._numEntriesScannedPostFilter, numTotalDocs);
    }

    private static class BitmapDocIdSetOperator
    extends BaseOperator<DocIdSetBlock> {
        static final String OPERATOR_NAME = "BitmapDocIdSetOperator";
        final IntIterator _docIdIterator;
        final int[] _docIdBuffer;

        BitmapDocIdSetOperator(ImmutableRoaringBitmap docIds, int numDocs) {
            this._docIdIterator = docIds.getIntIterator();
            this._docIdBuffer = new int[Math.min(numDocs, DocIdSetPlanNode.MAX_DOC_PER_CALL)];
        }

        @Override
        protected DocIdSetBlock getNextBlock() {
            int numDocIdsFilled = 0;
            while (numDocIdsFilled < DocIdSetPlanNode.MAX_DOC_PER_CALL && this._docIdIterator.hasNext()) {
                this._docIdBuffer[numDocIdsFilled++] = this._docIdIterator.next();
            }
            if (numDocIdsFilled > 0) {
                return new DocIdSetBlock(this._docIdBuffer, numDocIdsFilled);
            }
            return null;
        }

        @Override
        public String getOperatorName() {
            return OPERATOR_NAME;
        }
    }
}

