/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.query;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Map;
import org.apache.pinot.common.function.AggregationFunctionType;
import org.apache.pinot.core.common.DataSource;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.segment.index.metadata.SegmentMetadata;

public class MetadataBasedAggregationOperator
extends BaseOperator<IntermediateResultsBlock> {
    private static final String OPERATOR_NAME = "MetadataBasedAggregationOperator";
    private final AggregationFunction[] _aggregationFunctions;
    private final SegmentMetadata _segmentMetadata;
    private final Map<String, DataSource> _dataSourceMap;

    public MetadataBasedAggregationOperator(AggregationFunction[] aggregationFunctions, SegmentMetadata segmentMetadata, Map<String, DataSource> dataSourceMap) {
        this._aggregationFunctions = aggregationFunctions;
        this._segmentMetadata = segmentMetadata;
        this._dataSourceMap = dataSourceMap;
    }

    @Override
    protected IntermediateResultsBlock getNextBlock() {
        int numAggregationFunctions = this._aggregationFunctions.length;
        ArrayList<Long> aggregationResults = new ArrayList<Long>(numAggregationFunctions);
        long numTotalDocs = this._segmentMetadata.getTotalDocs();
        for (AggregationFunction aggregationFunction : this._aggregationFunctions) {
            Preconditions.checkState((aggregationFunction.getType() == AggregationFunctionType.COUNT ? 1 : 0) != 0, (Object)("Metadata based aggregation operator does not support function type: " + aggregationFunction.getType()));
            aggregationResults.add(numTotalDocs);
        }
        return new IntermediateResultsBlock(this._aggregationFunctions, aggregationResults, false);
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        int numTotalDocs = this._segmentMetadata.getTotalDocs();
        return new ExecutionStatistics(numTotalDocs, 0L, 0L, numTotalDocs);
    }
}

