/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.query;

import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import it.unimi.dsi.fastutil.floats.FloatOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Map;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.customobject.MinMaxRangePair;
import org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.spi.utils.ByteArray;

public class DictionaryBasedAggregationOperator
extends BaseOperator<IntermediateResultsBlock> {
    private static final String OPERATOR_NAME = "DictionaryBasedAggregationOperator";
    private final AggregationFunction[] _aggregationFunctions;
    private final Map<String, Dictionary> _dictionaryMap;
    private final int _numTotalDocs;

    public DictionaryBasedAggregationOperator(AggregationFunction[] aggregationFunctions, Map<String, Dictionary> dictionaryMap, int numTotalDocs) {
        this._aggregationFunctions = aggregationFunctions;
        this._dictionaryMap = dictionaryMap;
        this._numTotalDocs = numTotalDocs;
    }

    @Override
    protected IntermediateResultsBlock getNextBlock() {
        int numAggregationFunctions = this._aggregationFunctions.length;
        ArrayList<Comparable<Double>> aggregationResults = new ArrayList<Comparable<Double>>(numAggregationFunctions);
        block15: for (AggregationFunction aggregationFunction : this._aggregationFunctions) {
            String column = aggregationFunction.getInputExpressions().get(0).getIdentifier();
            Dictionary dictionary = this._dictionaryMap.get(column);
            int dictionarySize = dictionary.length();
            switch (aggregationFunction.getType()) {
                case MAX: {
                    aggregationResults.add(Double.valueOf(dictionary.getDoubleValue(dictionarySize - 1)));
                    continue block15;
                }
                case MIN: {
                    aggregationResults.add(Double.valueOf(dictionary.getDoubleValue(0)));
                    continue block15;
                }
                case MINMAXRANGE: {
                    aggregationResults.add(new MinMaxRangePair(dictionary.getDoubleValue(0), dictionary.getDoubleValue(dictionarySize - 1)));
                    continue block15;
                }
                case DISTINCTCOUNT: {
                    switch (dictionary.getValueType()) {
                        case INT: {
                            IntOpenHashSet intSet = new IntOpenHashSet(dictionarySize);
                            for (int dictId = 0; dictId < dictionarySize; ++dictId) {
                                intSet.add(dictionary.getIntValue(dictId));
                            }
                            aggregationResults.add((Comparable<Double>)intSet);
                            continue block15;
                        }
                        case LONG: {
                            LongOpenHashSet longSet = new LongOpenHashSet(dictionarySize);
                            for (int dictId = 0; dictId < dictionarySize; ++dictId) {
                                longSet.add(dictionary.getLongValue(dictId));
                            }
                            aggregationResults.add((Comparable<Double>)longSet);
                            continue block15;
                        }
                        case FLOAT: {
                            FloatOpenHashSet floatSet = new FloatOpenHashSet(dictionarySize);
                            for (int dictId = 0; dictId < dictionarySize; ++dictId) {
                                floatSet.add(dictionary.getFloatValue(dictId));
                            }
                            aggregationResults.add((Comparable<Double>)floatSet);
                            continue block15;
                        }
                        case DOUBLE: {
                            DoubleOpenHashSet doubleSet = new DoubleOpenHashSet(dictionarySize);
                            for (int dictId = 0; dictId < dictionarySize; ++dictId) {
                                doubleSet.add(dictionary.getDoubleValue(dictId));
                            }
                            aggregationResults.add((Comparable<Double>)doubleSet);
                            continue block15;
                        }
                        case STRING: {
                            ObjectOpenHashSet stringSet = new ObjectOpenHashSet(dictionarySize);
                            for (int dictId = 0; dictId < dictionarySize; ++dictId) {
                                stringSet.add((Object)dictionary.getStringValue(dictId));
                            }
                            aggregationResults.add((Comparable<Double>)stringSet);
                            continue block15;
                        }
                        case BYTES: {
                            ObjectOpenHashSet bytesSet = new ObjectOpenHashSet(dictionarySize);
                            for (int dictId = 0; dictId < dictionarySize; ++dictId) {
                                bytesSet.add((Object)new ByteArray(dictionary.getBytesValue(dictId)));
                            }
                            aggregationResults.add((Comparable<Double>)bytesSet);
                            continue block15;
                        }
                    }
                    throw new IllegalStateException();
                }
                case SEGMENTPARTITIONEDDISTINCTCOUNT: {
                    aggregationResults.add(Long.valueOf(dictionarySize));
                    continue block15;
                }
                default: {
                    throw new IllegalStateException("Dictionary based aggregation operator does not support function type: " + aggregationFunction.getType());
                }
            }
        }
        return new IntermediateResultsBlock(this._aggregationFunctions, aggregationResults, false);
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        return new ExecutionStatistics(this._numTotalDocs, 0L, 0L, this._numTotalDocs);
    }
}

