/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.query;

import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.DefaultGroupByExecutor;
import org.apache.pinot.core.query.request.context.ExpressionContext;
import org.apache.pinot.core.startree.executor.StarTreeGroupByExecutor;

public class AggregationGroupByOperator
extends BaseOperator<IntermediateResultsBlock> {
    private static final String OPERATOR_NAME = "AggregationGroupByOperator";
    private final AggregationFunction[] _aggregationFunctions;
    private final ExpressionContext[] _groupByExpressions;
    private final int _maxInitialResultHolderCapacity;
    private final int _numGroupsLimit;
    private final TransformOperator _transformOperator;
    private final long _numTotalDocs;
    private final boolean _useStarTree;
    private int _numDocsScanned = 0;

    public AggregationGroupByOperator(AggregationFunction[] aggregationFunctions, ExpressionContext[] groupByExpressions, int maxInitialResultHolderCapacity, int numGroupsLimit, TransformOperator transformOperator, long numTotalDocs, boolean useStarTree) {
        this._aggregationFunctions = aggregationFunctions;
        this._groupByExpressions = groupByExpressions;
        this._maxInitialResultHolderCapacity = maxInitialResultHolderCapacity;
        this._numGroupsLimit = numGroupsLimit;
        this._transformOperator = transformOperator;
        this._numTotalDocs = numTotalDocs;
        this._useStarTree = useStarTree;
    }

    @Override
    protected IntermediateResultsBlock getNextBlock() {
        TransformBlock transformBlock;
        DefaultGroupByExecutor groupByExecutor = this._useStarTree ? new StarTreeGroupByExecutor(this._aggregationFunctions, this._groupByExpressions, this._maxInitialResultHolderCapacity, this._numGroupsLimit, this._transformOperator) : new DefaultGroupByExecutor(this._aggregationFunctions, this._groupByExpressions, this._maxInitialResultHolderCapacity, this._numGroupsLimit, this._transformOperator);
        while ((transformBlock = (TransformBlock)this._transformOperator.nextBlock()) != null) {
            this._numDocsScanned += transformBlock.getNumDocs();
            groupByExecutor.process(transformBlock);
        }
        return new IntermediateResultsBlock(this._aggregationFunctions, groupByExecutor.getResult());
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        long numEntriesScannedInFilter = this._transformOperator.getExecutionStatistics().getNumEntriesScannedInFilter();
        long numEntriesScannedPostFilter = (long)this._numDocsScanned * (long)this._transformOperator.getNumColumnsProjected();
        return new ExecutionStatistics(this._numDocsScanned, numEntriesScannedInFilter, numEntriesScannedPostFilter, this._numTotalDocs);
    }
}

