/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter.predicate;

import it.unimi.dsi.fastutil.ints.IntSet;
import org.apache.pinot.core.operator.filter.predicate.BaseDictionaryBasedPredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.BaseRawValueBasedPredicateEvaluator;
import org.apache.pinot.core.query.request.context.predicate.Predicate;
import org.apache.pinot.core.query.request.context.predicate.RangePredicate;
import org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.BytesUtils;

public class RangePredicateEvaluatorFactory {
    private RangePredicateEvaluatorFactory() {
    }

    public static BaseDictionaryBasedPredicateEvaluator newDictionaryBasedEvaluator(RangePredicate rangePredicate, Dictionary dictionary, FieldSpec.DataType dataType) {
        if (dictionary.isSorted()) {
            return new SortedDictionaryBasedRangePredicateEvaluator(rangePredicate, dictionary);
        }
        return new UnsortedDictionaryBasedRangePredicateEvaluator(rangePredicate, dictionary, dataType);
    }

    public static BaseRawValueBasedPredicateEvaluator newRawValueBasedEvaluator(RangePredicate rangePredicate, FieldSpec.DataType dataType) {
        switch (dataType) {
            case INT: {
                return new IntRawValueBasedRangePredicateEvaluator(rangePredicate);
            }
            case LONG: {
                return new LongRawValueBasedRangePredicateEvaluator(rangePredicate);
            }
            case FLOAT: {
                return new FloatRawValueBasedRangePredicateEvaluator(rangePredicate);
            }
            case DOUBLE: {
                return new DoubleRawValueBasedRangePredicateEvaluator(rangePredicate);
            }
            case STRING: {
                return new StringRawValueBasedRangePredicateEvaluator(rangePredicate);
            }
            case BYTES: {
                return new BytesRawValueBasedRangePredicateEvaluator(rangePredicate);
            }
        }
        throw new UnsupportedOperationException("Unsupported data type: " + dataType);
    }

    private static final class BytesRawValueBasedRangePredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final byte[] _lowerBound;
        final byte[] _upperBound;
        final boolean _lowerInclusive;
        final boolean _upperInclusive;

        BytesRawValueBasedRangePredicateEvaluator(RangePredicate rangePredicate) {
            String lowerBound = rangePredicate.getLowerBound();
            String upperBound = rangePredicate.getUpperBound();
            this._lowerBound = lowerBound.equals("*") ? null : BytesUtils.toBytes((String)lowerBound);
            this._upperBound = upperBound.equals("*") ? null : BytesUtils.toBytes((String)upperBound);
            this._lowerInclusive = rangePredicate.isLowerInclusive();
            this._upperInclusive = rangePredicate.isUpperInclusive();
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.RANGE;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.BYTES;
        }

        @Override
        public boolean applySV(byte[] value) {
            boolean result = true;
            if (this._lowerBound != null) {
                if (this._lowerInclusive) {
                    result = ByteArray.compare((byte[])this._lowerBound, (byte[])value) <= 0;
                } else {
                    boolean bl = result = ByteArray.compare((byte[])this._lowerBound, (byte[])value) < 0;
                }
            }
            if (this._upperBound != null) {
                result = this._upperInclusive ? (result &= ByteArray.compare((byte[])this._upperBound, (byte[])value) >= 0) : (result &= ByteArray.compare((byte[])this._upperBound, (byte[])value) > 0);
            }
            return result;
        }
    }

    private static final class StringRawValueBasedRangePredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final String _lowerBound;
        final String _upperBound;
        final boolean _lowerInclusive;
        final boolean _upperInclusive;

        StringRawValueBasedRangePredicateEvaluator(RangePredicate rangePredicate) {
            String lowerBound = rangePredicate.getLowerBound();
            String upperBound = rangePredicate.getUpperBound();
            this._lowerBound = lowerBound.equals("*") ? null : lowerBound;
            this._upperBound = upperBound.equals("*") ? null : upperBound;
            this._lowerInclusive = rangePredicate.isLowerInclusive();
            this._upperInclusive = rangePredicate.isUpperInclusive();
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.RANGE;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.STRING;
        }

        @Override
        public boolean applySV(String value) {
            boolean result = true;
            if (this._lowerBound != null) {
                if (this._lowerInclusive) {
                    result = this._lowerBound.compareTo(value) <= 0;
                } else {
                    boolean bl = result = this._lowerBound.compareTo(value) < 0;
                }
            }
            if (this._upperBound != null) {
                result = this._upperInclusive ? (result &= this._upperBound.compareTo(value) >= 0) : (result &= this._upperBound.compareTo(value) > 0);
            }
            return result;
        }
    }

    public static final class DoubleRawValueBasedRangePredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final double _lowerBound;
        final double _upperBound;
        final boolean _lowerInclusive;
        final boolean _upperInclusive;

        DoubleRawValueBasedRangePredicateEvaluator(RangePredicate rangePredicate) {
            String lowerBound = rangePredicate.getLowerBound();
            String upperBound = rangePredicate.getUpperBound();
            boolean lowerUnbounded = lowerBound.equals("*");
            boolean upperUnbounded = upperBound.equals("*");
            this._lowerBound = lowerUnbounded ? Double.NEGATIVE_INFINITY : Double.parseDouble(lowerBound);
            this._upperBound = upperUnbounded ? Double.POSITIVE_INFINITY : Double.parseDouble(upperBound);
            this._lowerInclusive = lowerUnbounded || rangePredicate.isLowerInclusive();
            this._upperInclusive = upperUnbounded || rangePredicate.isUpperInclusive();
        }

        public double geLowerBound() {
            return this._lowerBound;
        }

        public double getUpperBound() {
            return this._upperBound;
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.RANGE;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.DOUBLE;
        }

        @Override
        public boolean applySV(double value) {
            boolean result;
            if (this._lowerInclusive) {
                result = this._lowerBound <= value;
            } else {
                boolean bl = result = this._lowerBound < value;
            }
            result = this._upperInclusive ? (result &= this._upperBound >= value) : (result &= this._upperBound > value);
            return result;
        }
    }

    public static final class FloatRawValueBasedRangePredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final float _lowerBound;
        final float _upperBound;
        final boolean _lowerInclusive;
        final boolean _upperInclusive;

        FloatRawValueBasedRangePredicateEvaluator(RangePredicate rangePredicate) {
            String lowerBound = rangePredicate.getLowerBound();
            String upperBound = rangePredicate.getUpperBound();
            boolean lowerUnbounded = lowerBound.equals("*");
            boolean upperUnbounded = upperBound.equals("*");
            this._lowerBound = lowerUnbounded ? Float.NEGATIVE_INFINITY : Float.parseFloat(lowerBound);
            this._upperBound = upperUnbounded ? Float.POSITIVE_INFINITY : Float.parseFloat(upperBound);
            this._lowerInclusive = lowerUnbounded || rangePredicate.isLowerInclusive();
            this._upperInclusive = upperUnbounded || rangePredicate.isUpperInclusive();
        }

        public float geLowerBound() {
            return this._lowerBound;
        }

        public float getUpperBound() {
            return this._upperBound;
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.RANGE;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.FLOAT;
        }

        @Override
        public boolean applySV(float value) {
            boolean result;
            if (this._lowerInclusive) {
                result = this._lowerBound <= value;
            } else {
                boolean bl = result = this._lowerBound < value;
            }
            result = this._upperInclusive ? (result &= this._upperBound >= value) : (result &= this._upperBound > value);
            return result;
        }
    }

    public static final class LongRawValueBasedRangePredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final long _lowerBound;
        final long _upperBound;
        final boolean _lowerInclusive;
        final boolean _upperInclusive;

        LongRawValueBasedRangePredicateEvaluator(RangePredicate rangePredicate) {
            String lowerBound = rangePredicate.getLowerBound();
            String upperBound = rangePredicate.getUpperBound();
            boolean lowerUnbounded = lowerBound.equals("*");
            boolean upperUnbounded = upperBound.equals("*");
            this._lowerBound = lowerUnbounded ? Long.MIN_VALUE : Long.parseLong(lowerBound);
            this._upperBound = upperUnbounded ? Long.MAX_VALUE : Long.parseLong(upperBound);
            this._lowerInclusive = lowerUnbounded || rangePredicate.isLowerInclusive();
            this._upperInclusive = upperUnbounded || rangePredicate.isUpperInclusive();
        }

        public long geLowerBound() {
            return this._lowerBound;
        }

        public long getUpperBound() {
            return this._upperBound;
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.RANGE;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.LONG;
        }

        @Override
        public boolean applySV(long value) {
            boolean result;
            if (this._lowerInclusive) {
                result = this._lowerBound <= value;
            } else {
                boolean bl = result = this._lowerBound < value;
            }
            result = this._upperInclusive ? (result &= this._upperBound >= value) : (result &= this._upperBound > value);
            return result;
        }
    }

    public static final class IntRawValueBasedRangePredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final int _lowerBound;
        final int _upperBound;
        final boolean _lowerInclusive;
        final boolean _upperInclusive;

        IntRawValueBasedRangePredicateEvaluator(RangePredicate rangePredicate) {
            String lowerBound = rangePredicate.getLowerBound();
            String upperBound = rangePredicate.getUpperBound();
            boolean lowerUnbounded = lowerBound.equals("*");
            boolean upperUnbounded = upperBound.equals("*");
            this._lowerBound = lowerUnbounded ? Integer.MIN_VALUE : Integer.parseInt(lowerBound);
            this._upperBound = upperUnbounded ? Integer.MAX_VALUE : Integer.parseInt(upperBound);
            this._lowerInclusive = lowerUnbounded || rangePredicate.isLowerInclusive();
            this._upperInclusive = upperUnbounded || rangePredicate.isUpperInclusive();
        }

        public int geLowerBound() {
            return this._lowerBound;
        }

        public int getUpperBound() {
            return this._upperBound;
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.RANGE;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.INT;
        }

        @Override
        public boolean applySV(int value) {
            boolean result;
            if (this._lowerInclusive) {
                result = this._lowerBound <= value;
            } else {
                boolean bl = result = this._lowerBound < value;
            }
            result = this._upperInclusive ? (result &= this._upperBound >= value) : (result &= this._upperBound > value);
            return result;
        }
    }

    private static final class UnsortedDictionaryBasedRangePredicateEvaluator
    extends BaseDictionaryBasedPredicateEvaluator {
        private static final int DICT_ID_SET_BASED_CARDINALITY_THRESHOLD = 1000;
        final Dictionary _dictionary;
        final FieldSpec.DataType _dataType;
        final boolean _dictIdSetBased;
        final IntSet _matchingDictIdSet;
        final BaseRawValueBasedPredicateEvaluator _rawValueBasedEvaluator;

        UnsortedDictionaryBasedRangePredicateEvaluator(RangePredicate rangePredicate, Dictionary dictionary, FieldSpec.DataType dataType) {
            this._dictionary = dictionary;
            this._dataType = dataType;
            int cardinality = dictionary.length();
            if (cardinality < 1000) {
                this._dictIdSetBased = true;
                this._rawValueBasedEvaluator = null;
                this._matchingDictIdSet = dictionary.getDictIdsInRange(rangePredicate.getLowerBound(), rangePredicate.getUpperBound(), rangePredicate.isLowerInclusive(), rangePredicate.isUpperInclusive());
                int numMatchingDictIds = this._matchingDictIdSet.size();
                if (numMatchingDictIds == 0) {
                    this._alwaysFalse = true;
                } else if (numMatchingDictIds == cardinality) {
                    this._alwaysTrue = true;
                }
            } else {
                this._dictIdSetBased = false;
                this._matchingDictIdSet = null;
                switch (dataType) {
                    case INT: {
                        this._rawValueBasedEvaluator = new IntRawValueBasedRangePredicateEvaluator(rangePredicate);
                        break;
                    }
                    case LONG: {
                        this._rawValueBasedEvaluator = new LongRawValueBasedRangePredicateEvaluator(rangePredicate);
                        break;
                    }
                    case FLOAT: {
                        this._rawValueBasedEvaluator = new FloatRawValueBasedRangePredicateEvaluator(rangePredicate);
                        break;
                    }
                    case DOUBLE: {
                        this._rawValueBasedEvaluator = new DoubleRawValueBasedRangePredicateEvaluator(rangePredicate);
                        break;
                    }
                    case STRING: {
                        this._rawValueBasedEvaluator = new StringRawValueBasedRangePredicateEvaluator(rangePredicate);
                        break;
                    }
                    case BYTES: {
                        this._rawValueBasedEvaluator = new BytesRawValueBasedRangePredicateEvaluator(rangePredicate);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.RANGE;
        }

        @Override
        public boolean applySV(int dictId) {
            if (this._dictIdSetBased) {
                return this._matchingDictIdSet.contains(dictId);
            }
            switch (this._dataType) {
                case INT: {
                    return this._rawValueBasedEvaluator.applySV(this._dictionary.getIntValue(dictId));
                }
                case LONG: {
                    return this._rawValueBasedEvaluator.applySV(this._dictionary.getLongValue(dictId));
                }
                case FLOAT: {
                    return this._rawValueBasedEvaluator.applySV(this._dictionary.getFloatValue(dictId));
                }
                case DOUBLE: {
                    return this._rawValueBasedEvaluator.applySV(this._dictionary.getDoubleValue(dictId));
                }
                case STRING: {
                    return this._rawValueBasedEvaluator.applySV(this._dictionary.getStringValue(dictId));
                }
                case BYTES: {
                    return this._rawValueBasedEvaluator.applySV(this._dictionary.getBytesValue(dictId));
                }
            }
            throw new IllegalStateException();
        }

        @Override
        public int[] getMatchingDictIds() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class SortedDictionaryBasedRangePredicateEvaluator
    extends BaseDictionaryBasedPredicateEvaluator {
        final int _startDictId;
        final int _endDictId;
        final int _numMatchingDictIds;
        int[] _matchingDictIds;

        SortedDictionaryBasedRangePredicateEvaluator(RangePredicate rangePredicate, Dictionary dictionary) {
            int insertionIndex;
            String lowerBound = rangePredicate.getLowerBound();
            String upperBound = rangePredicate.getUpperBound();
            boolean lowerInclusive = rangePredicate.isLowerInclusive();
            boolean upperInclusive = rangePredicate.isUpperInclusive();
            this._startDictId = lowerBound.equals("*") ? 0 : ((insertionIndex = dictionary.insertionIndexOf(lowerBound)) < 0 ? -(insertionIndex + 1) : (lowerInclusive ? insertionIndex : insertionIndex + 1));
            this._endDictId = upperBound.equals("*") ? dictionary.length() : ((insertionIndex = dictionary.insertionIndexOf(upperBound)) < 0 ? -(insertionIndex + 1) : (upperInclusive ? insertionIndex + 1 : insertionIndex));
            this._numMatchingDictIds = this._endDictId - this._startDictId;
            if (this._numMatchingDictIds <= 0) {
                this._alwaysFalse = true;
            } else if (dictionary.length() == this._numMatchingDictIds) {
                this._alwaysTrue = true;
            }
        }

        public int getStartDictId() {
            return this._startDictId;
        }

        public int getEndDictId() {
            return this._endDictId;
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.RANGE;
        }

        @Override
        public boolean applySV(int dictId) {
            return this._startDictId <= dictId && this._endDictId > dictId;
        }

        @Override
        public int getNumMatchingDictIds() {
            return this._numMatchingDictIds;
        }

        @Override
        public int[] getMatchingDictIds() {
            if (this._matchingDictIds == null) {
                if (this._numMatchingDictIds <= 0) {
                    this._matchingDictIds = new int[0];
                } else {
                    this._matchingDictIds = new int[this._numMatchingDictIds];
                    for (int i = 0; i < this._numMatchingDictIds; ++i) {
                        this._matchingDictIds[i] = this._startDictId + i;
                    }
                }
            }
            return this._matchingDictIds;
        }
    }
}

