/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter.predicate;

import javax.annotation.Nullable;
import org.apache.pinot.core.operator.filter.predicate.EqualsPredicateEvaluatorFactory;
import org.apache.pinot.core.operator.filter.predicate.InPredicateEvaluatorFactory;
import org.apache.pinot.core.operator.filter.predicate.NotEqualsPredicateEvaluatorFactory;
import org.apache.pinot.core.operator.filter.predicate.NotInPredicateEvaluatorFactory;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.RangePredicateEvaluatorFactory;
import org.apache.pinot.core.operator.filter.predicate.RegexpLikePredicateEvaluatorFactory;
import org.apache.pinot.core.query.exception.BadQueryRequestException;
import org.apache.pinot.core.query.request.context.predicate.EqPredicate;
import org.apache.pinot.core.query.request.context.predicate.InPredicate;
import org.apache.pinot.core.query.request.context.predicate.NotEqPredicate;
import org.apache.pinot.core.query.request.context.predicate.NotInPredicate;
import org.apache.pinot.core.query.request.context.predicate.Predicate;
import org.apache.pinot.core.query.request.context.predicate.RangePredicate;
import org.apache.pinot.core.query.request.context.predicate.RegexpLikePredicate;
import org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;

public class PredicateEvaluatorProvider {
    private PredicateEvaluatorProvider() {
    }

    public static PredicateEvaluator getPredicateEvaluator(Predicate predicate, @Nullable Dictionary dictionary, FieldSpec.DataType dataType) {
        try {
            if (dictionary != null) {
                switch (predicate.getType()) {
                    case EQ: {
                        return EqualsPredicateEvaluatorFactory.newDictionaryBasedEvaluator((EqPredicate)predicate, dictionary);
                    }
                    case NOT_EQ: {
                        return NotEqualsPredicateEvaluatorFactory.newDictionaryBasedEvaluator((NotEqPredicate)predicate, dictionary);
                    }
                    case IN: {
                        return InPredicateEvaluatorFactory.newDictionaryBasedEvaluator((InPredicate)predicate, dictionary);
                    }
                    case NOT_IN: {
                        return NotInPredicateEvaluatorFactory.newDictionaryBasedEvaluator((NotInPredicate)predicate, dictionary);
                    }
                    case RANGE: {
                        return RangePredicateEvaluatorFactory.newDictionaryBasedEvaluator((RangePredicate)predicate, dictionary, dataType);
                    }
                    case REGEXP_LIKE: {
                        return RegexpLikePredicateEvaluatorFactory.newDictionaryBasedEvaluator((RegexpLikePredicate)predicate, dictionary);
                    }
                }
                throw new UnsupportedOperationException("Unsupported predicate type: " + (Object)((Object)predicate.getType()));
            }
            switch (predicate.getType()) {
                case EQ: {
                    return EqualsPredicateEvaluatorFactory.newRawValueBasedEvaluator((EqPredicate)predicate, dataType);
                }
                case NOT_EQ: {
                    return NotEqualsPredicateEvaluatorFactory.newRawValueBasedEvaluator((NotEqPredicate)predicate, dataType);
                }
                case IN: {
                    return InPredicateEvaluatorFactory.newRawValueBasedEvaluator((InPredicate)predicate, dataType);
                }
                case NOT_IN: {
                    return NotInPredicateEvaluatorFactory.newRawValueBasedEvaluator((NotInPredicate)predicate, dataType);
                }
                case RANGE: {
                    return RangePredicateEvaluatorFactory.newRawValueBasedEvaluator((RangePredicate)predicate, dataType);
                }
                case REGEXP_LIKE: {
                    return RegexpLikePredicateEvaluatorFactory.newRawValueBasedEvaluator((RegexpLikePredicate)predicate, dataType);
                }
            }
            throw new UnsupportedOperationException("Unsupported predicate type: " + (Object)((Object)predicate.getType()));
        }
        catch (Exception e) {
            throw new BadQueryRequestException(e);
        }
    }
}

