/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter.predicate;

import org.apache.pinot.core.operator.filter.predicate.BaseDictionaryBasedPredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.BaseRawValueBasedPredicateEvaluator;
import org.apache.pinot.core.query.request.context.predicate.NotEqPredicate;
import org.apache.pinot.core.query.request.context.predicate.Predicate;
import org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.BytesUtils;

public class NotEqualsPredicateEvaluatorFactory {
    private NotEqualsPredicateEvaluatorFactory() {
    }

    public static BaseDictionaryBasedPredicateEvaluator newDictionaryBasedEvaluator(NotEqPredicate notEqPredicate, Dictionary dictionary) {
        return new DictionaryBasedNeqPredicateEvaluator(notEqPredicate, dictionary);
    }

    public static BaseRawValueBasedPredicateEvaluator newRawValueBasedEvaluator(NotEqPredicate notEqPredicate, FieldSpec.DataType dataType) {
        switch (dataType) {
            case INT: {
                return new IntRawValueBasedNeqPredicateEvaluator(notEqPredicate);
            }
            case LONG: {
                return new LongRawValueBasedNeqPredicateEvaluator(notEqPredicate);
            }
            case FLOAT: {
                return new FloatRawValueBasedNeqPredicateEvaluator(notEqPredicate);
            }
            case DOUBLE: {
                return new DoubleRawValueBasedNeqPredicateEvaluator(notEqPredicate);
            }
            case STRING: {
                return new StringRawValueBasedNeqPredicateEvaluator(notEqPredicate);
            }
            case BYTES: {
                return new BytesRawValueBasedNeqPredicateEvaluator(notEqPredicate);
            }
        }
        throw new UnsupportedOperationException("Unsupported data type: " + dataType);
    }

    private static final class BytesRawValueBasedNeqPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final byte[] _nonMatchingValue;

        BytesRawValueBasedNeqPredicateEvaluator(NotEqPredicate nEqPredicate) {
            this._nonMatchingValue = BytesUtils.toBytes((String)nEqPredicate.getValue());
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.NOT_EQ;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.BYTES;
        }

        @Override
        public boolean applySV(byte[] value) {
            return ByteArray.compare((byte[])this._nonMatchingValue, (byte[])value) != 0;
        }
    }

    private static final class StringRawValueBasedNeqPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final String _nonMatchingValue;

        StringRawValueBasedNeqPredicateEvaluator(NotEqPredicate nEqPredicate) {
            this._nonMatchingValue = nEqPredicate.getValue();
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.NOT_EQ;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.STRING;
        }

        @Override
        public boolean applySV(String value) {
            return !this._nonMatchingValue.equals(value);
        }
    }

    private static final class DoubleRawValueBasedNeqPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final double _nonMatchingValue;

        DoubleRawValueBasedNeqPredicateEvaluator(NotEqPredicate nEqPredicate) {
            this._nonMatchingValue = Double.parseDouble(nEqPredicate.getValue());
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.NOT_EQ;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.DOUBLE;
        }

        @Override
        public boolean applySV(double value) {
            return this._nonMatchingValue != value;
        }
    }

    private static final class FloatRawValueBasedNeqPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final float _nonMatchingValue;

        FloatRawValueBasedNeqPredicateEvaluator(NotEqPredicate nEqPredicate) {
            this._nonMatchingValue = Float.parseFloat(nEqPredicate.getValue());
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.NOT_EQ;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.FLOAT;
        }

        @Override
        public boolean applySV(float value) {
            return this._nonMatchingValue != value;
        }
    }

    private static final class LongRawValueBasedNeqPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final long _nonMatchingValue;

        LongRawValueBasedNeqPredicateEvaluator(NotEqPredicate nEqPredicate) {
            this._nonMatchingValue = Long.parseLong(nEqPredicate.getValue());
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.NOT_EQ;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.LONG;
        }

        @Override
        public boolean applySV(long value) {
            return this._nonMatchingValue != value;
        }
    }

    private static final class IntRawValueBasedNeqPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final int _nonMatchingValue;

        IntRawValueBasedNeqPredicateEvaluator(NotEqPredicate nEqPredicate) {
            this._nonMatchingValue = Integer.parseInt(nEqPredicate.getValue());
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.NOT_EQ;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.INT;
        }

        @Override
        public boolean applySV(int value) {
            return this._nonMatchingValue != value;
        }
    }

    private static final class DictionaryBasedNeqPredicateEvaluator
    extends BaseDictionaryBasedPredicateEvaluator {
        final int _nonMatchingDictId;
        final int[] _nonMatchingDictIds;
        final Dictionary _dictionary;
        int[] _matchingDictIds;

        DictionaryBasedNeqPredicateEvaluator(NotEqPredicate nEqPredicate, Dictionary dictionary) {
            this._nonMatchingDictId = dictionary.indexOf(nEqPredicate.getValue());
            if (this._nonMatchingDictId >= 0) {
                this._nonMatchingDictIds = new int[]{this._nonMatchingDictId};
                if (dictionary.length() == 1) {
                    this._alwaysFalse = true;
                }
            } else {
                this._nonMatchingDictIds = new int[0];
                this._alwaysTrue = true;
            }
            this._dictionary = dictionary;
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.NOT_EQ;
        }

        @Override
        public boolean applySV(int dictId) {
            return this._nonMatchingDictId != dictId;
        }

        @Override
        public int[] getMatchingDictIds() {
            block4: {
                if (this._matchingDictIds != null) break block4;
                int dictionarySize = this._dictionary.length();
                if (this._nonMatchingDictId >= 0) {
                    this._matchingDictIds = new int[dictionarySize - 1];
                    int index = 0;
                    for (int dictId = 0; dictId < dictionarySize; ++dictId) {
                        if (dictId == this._nonMatchingDictId) continue;
                        this._matchingDictIds[index++] = dictId;
                    }
                } else {
                    this._matchingDictIds = new int[dictionarySize];
                    for (int dictId = 0; dictId < dictionarySize; ++dictId) {
                        this._matchingDictIds[dictId] = dictId;
                    }
                }
            }
            return this._matchingDictIds;
        }

        @Override
        public int[] getNonMatchingDictIds() {
            return this._nonMatchingDictIds;
        }
    }
}

