/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter.predicate;

import org.apache.pinot.core.operator.filter.predicate.BaseDictionaryBasedPredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.BaseRawValueBasedPredicateEvaluator;
import org.apache.pinot.core.query.request.context.predicate.EqPredicate;
import org.apache.pinot.core.query.request.context.predicate.Predicate;
import org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.BytesUtils;

public class EqualsPredicateEvaluatorFactory {
    private EqualsPredicateEvaluatorFactory() {
    }

    public static BaseDictionaryBasedPredicateEvaluator newDictionaryBasedEvaluator(EqPredicate eqPredicate, Dictionary dictionary) {
        return new DictionaryBasedEqPredicateEvaluator(eqPredicate, dictionary);
    }

    public static BaseRawValueBasedPredicateEvaluator newRawValueBasedEvaluator(EqPredicate eqPredicate, FieldSpec.DataType dataType) {
        switch (dataType) {
            case INT: {
                return new IntRawValueBasedEqPredicateEvaluator(eqPredicate);
            }
            case LONG: {
                return new LongRawValueBasedEqPredicateEvaluator(eqPredicate);
            }
            case FLOAT: {
                return new FloatRawValueBasedEqPredicateEvaluator(eqPredicate);
            }
            case DOUBLE: {
                return new DoubleRawValueBasedEqPredicateEvaluator(eqPredicate);
            }
            case STRING: {
                return new StringRawValueBasedEqPredicateEvaluator(eqPredicate);
            }
            case BYTES: {
                return new BytesRawValueBasedEqPredicateEvaluator(eqPredicate);
            }
        }
        throw new UnsupportedOperationException("Unsupported data type: " + dataType);
    }

    private static final class BytesRawValueBasedEqPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final byte[] _matchingValue;

        BytesRawValueBasedEqPredicateEvaluator(EqPredicate eqPredicate) {
            this._matchingValue = BytesUtils.toBytes((String)eqPredicate.getValue());
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.EQ;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.BYTES;
        }

        @Override
        public boolean applySV(byte[] value) {
            return ByteArray.compare((byte[])this._matchingValue, (byte[])value) == 0;
        }
    }

    private static final class StringRawValueBasedEqPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final String _matchingValue;

        StringRawValueBasedEqPredicateEvaluator(EqPredicate eqPredicate) {
            this._matchingValue = eqPredicate.getValue();
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.EQ;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.STRING;
        }

        @Override
        public boolean applySV(String value) {
            return this._matchingValue.equals(value);
        }
    }

    private static final class DoubleRawValueBasedEqPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final double _matchingValue;

        DoubleRawValueBasedEqPredicateEvaluator(EqPredicate eqPredicate) {
            this._matchingValue = Double.parseDouble(eqPredicate.getValue());
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.EQ;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.DOUBLE;
        }

        @Override
        public boolean applySV(double value) {
            return this._matchingValue == value;
        }
    }

    private static final class FloatRawValueBasedEqPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final float _matchingValue;

        FloatRawValueBasedEqPredicateEvaluator(EqPredicate eqPredicate) {
            this._matchingValue = Float.parseFloat(eqPredicate.getValue());
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.EQ;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.FLOAT;
        }

        @Override
        public boolean applySV(float value) {
            return this._matchingValue == value;
        }
    }

    private static final class LongRawValueBasedEqPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final long _matchingValue;

        LongRawValueBasedEqPredicateEvaluator(EqPredicate eqPredicate) {
            this._matchingValue = Long.parseLong(eqPredicate.getValue());
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.EQ;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.LONG;
        }

        @Override
        public boolean applySV(long value) {
            return this._matchingValue == value;
        }
    }

    private static final class IntRawValueBasedEqPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final int _matchingValue;

        IntRawValueBasedEqPredicateEvaluator(EqPredicate eqPredicate) {
            this._matchingValue = Integer.parseInt(eqPredicate.getValue());
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.EQ;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.INT;
        }

        @Override
        public boolean applySV(int value) {
            return this._matchingValue == value;
        }
    }

    private static final class DictionaryBasedEqPredicateEvaluator
    extends BaseDictionaryBasedPredicateEvaluator {
        final int _matchingDictId;
        final int[] _matchingDictIds;

        DictionaryBasedEqPredicateEvaluator(EqPredicate eqPredicate, Dictionary dictionary) {
            this._matchingDictId = dictionary.indexOf(eqPredicate.getValue());
            if (this._matchingDictId >= 0) {
                this._matchingDictIds = new int[]{this._matchingDictId};
                if (dictionary.length() == 1) {
                    this._alwaysTrue = true;
                }
            } else {
                this._matchingDictIds = new int[0];
                this._alwaysFalse = true;
            }
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.EQ;
        }

        @Override
        public boolean applySV(int dictId) {
            return this._matchingDictId == dictId;
        }

        @Override
        public int[] getMatchingDictIds() {
            return this._matchingDictIds;
        }
    }
}

