/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import org.apache.pinot.core.operator.blocks.FilterBlock;
import org.apache.pinot.core.operator.docidsets.BitmapDocIdSet;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.segment.index.readers.TextIndexReader;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;

public class TextMatchFilterOperator
extends BaseFilterOperator {
    private static final String OPERATOR_NAME = "TextMatchFilterOperator";
    private final TextIndexReader _textIndexReader;
    private final String _searchQuery;
    private final int _numDocs;

    public TextMatchFilterOperator(TextIndexReader textIndexReader, String searchQuery, int numDocs) {
        this._textIndexReader = textIndexReader;
        this._searchQuery = searchQuery;
        this._numDocs = numDocs;
    }

    @Override
    protected FilterBlock getNextBlock() {
        return new FilterBlock(new BitmapDocIdSet((ImmutableRoaringBitmap)this._textIndexReader.getDocIds(this._searchQuery), this._numDocs));
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }
}

