/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import org.apache.pinot.core.common.DataSource;
import org.apache.pinot.core.common.DataSourceMetadata;
import org.apache.pinot.core.operator.blocks.FilterBlock;
import org.apache.pinot.core.operator.docidsets.MVScanDocIdSet;
import org.apache.pinot.core.operator.docidsets.SVScanDocIdSet;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;

public class ScanBasedFilterOperator
extends BaseFilterOperator {
    private static final String OPERATOR_NAME = "ScanBasedFilterOperator";
    private final PredicateEvaluator _predicateEvaluator;
    private final DataSource _dataSource;
    private final int _numDocs;

    ScanBasedFilterOperator(PredicateEvaluator predicateEvaluator, DataSource dataSource, int numDocs) {
        this._predicateEvaluator = predicateEvaluator;
        this._dataSource = dataSource;
        this._numDocs = numDocs;
    }

    @Override
    protected FilterBlock getNextBlock() {
        DataSourceMetadata dataSourceMetadata = this._dataSource.getDataSourceMetadata();
        if (dataSourceMetadata.isSingleValue()) {
            return new FilterBlock(new SVScanDocIdSet(this._predicateEvaluator, this._dataSource.getForwardIndex(), this._numDocs));
        }
        return new FilterBlock(new MVScanDocIdSet(this._predicateEvaluator, this._dataSource.getForwardIndex(), this._numDocs, dataSourceMetadata.getMaxNumValuesPerMVEntry()));
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    public DataSourceMetadata getDataSourceMetadata() {
        return this._dataSource.getDataSourceMetadata();
    }
}

