/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import org.apache.pinot.core.common.DataSource;
import org.apache.pinot.core.operator.blocks.FilterBlock;
import org.apache.pinot.core.operator.dociditerators.ScanBasedDocIdIterator;
import org.apache.pinot.core.operator.docidsets.BitmapDocIdSet;
import org.apache.pinot.core.operator.docidsets.FilterBlockDocIdSet;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.operator.filter.ScanBasedFilterOperator;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.RangePredicateEvaluatorFactory;
import org.apache.pinot.core.segment.index.readers.RangeIndexReader;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class RangeIndexBasedFilterOperator
extends BaseFilterOperator {
    private static final String OPERATOR_NAME = "RangeFilterOperator";
    private final PredicateEvaluator _rangePredicateEvaluator;
    private final DataSource _dataSource;
    private final int _numDocs;

    public RangeIndexBasedFilterOperator(PredicateEvaluator rangePredicateEvaluator, DataSource dataSource, int numDocs) {
        this._rangePredicateEvaluator = rangePredicateEvaluator;
        this._dataSource = dataSource;
        this._numDocs = numDocs;
    }

    @Override
    protected FilterBlock getNextBlock() {
        int lastRangeId;
        int firstRangeId;
        RangeIndexReader rangeIndexReader = (RangeIndexReader)this._dataSource.getRangeIndex();
        assert (rangeIndexReader != null);
        if (this._rangePredicateEvaluator instanceof RangePredicateEvaluatorFactory.SortedDictionaryBasedRangePredicateEvaluator) {
            firstRangeId = rangeIndexReader.findRangeId(((RangePredicateEvaluatorFactory.SortedDictionaryBasedRangePredicateEvaluator)this._rangePredicateEvaluator).getStartDictId());
            lastRangeId = rangeIndexReader.findRangeId(((RangePredicateEvaluatorFactory.SortedDictionaryBasedRangePredicateEvaluator)this._rangePredicateEvaluator).getEndDictId() - 1);
        } else {
            switch (this._rangePredicateEvaluator.getDataType()) {
                case INT: {
                    firstRangeId = rangeIndexReader.findRangeId(((RangePredicateEvaluatorFactory.IntRawValueBasedRangePredicateEvaluator)this._rangePredicateEvaluator).geLowerBound());
                    lastRangeId = rangeIndexReader.findRangeId(((RangePredicateEvaluatorFactory.IntRawValueBasedRangePredicateEvaluator)this._rangePredicateEvaluator).getUpperBound());
                    break;
                }
                case LONG: {
                    firstRangeId = rangeIndexReader.findRangeId(((RangePredicateEvaluatorFactory.LongRawValueBasedRangePredicateEvaluator)this._rangePredicateEvaluator).geLowerBound());
                    lastRangeId = rangeIndexReader.findRangeId(((RangePredicateEvaluatorFactory.LongRawValueBasedRangePredicateEvaluator)this._rangePredicateEvaluator).getUpperBound());
                    break;
                }
                case FLOAT: {
                    firstRangeId = rangeIndexReader.findRangeId(((RangePredicateEvaluatorFactory.FloatRawValueBasedRangePredicateEvaluator)this._rangePredicateEvaluator).geLowerBound());
                    lastRangeId = rangeIndexReader.findRangeId(((RangePredicateEvaluatorFactory.FloatRawValueBasedRangePredicateEvaluator)this._rangePredicateEvaluator).getUpperBound());
                    break;
                }
                case DOUBLE: {
                    firstRangeId = rangeIndexReader.findRangeId(((RangePredicateEvaluatorFactory.DoubleRawValueBasedRangePredicateEvaluator)this._rangePredicateEvaluator).geLowerBound());
                    lastRangeId = rangeIndexReader.findRangeId(((RangePredicateEvaluatorFactory.DoubleRawValueBasedRangePredicateEvaluator)this._rangePredicateEvaluator).getUpperBound());
                    break;
                }
                default: {
                    throw new IllegalStateException("String and Bytes data type not supported for Range Indexing");
                }
            }
        }
        Object docIdsToScan = firstRangeId == lastRangeId ? rangeIndexReader.getDocIds(firstRangeId) : ImmutableRoaringBitmap.or((ImmutableRoaringBitmap)rangeIndexReader.getDocIds(firstRangeId), (ImmutableRoaringBitmap)rangeIndexReader.getDocIds(lastRangeId));
        ScanBasedFilterOperator scanBasedFilterOperator = new ScanBasedFilterOperator(this._rangePredicateEvaluator, this._dataSource, this._numDocs);
        final FilterBlockDocIdSet scanBasedDocIdSet = scanBasedFilterOperator.getNextBlock().getBlockDocIdSet();
        MutableRoaringBitmap docIds = ((ScanBasedDocIdIterator)scanBasedDocIdSet.iterator()).applyAnd((ImmutableRoaringBitmap)docIdsToScan);
        for (int rangeId = firstRangeId + 1; rangeId < lastRangeId; ++rangeId) {
            docIds.or(rangeIndexReader.getDocIds(rangeId));
        }
        return new FilterBlock(new BitmapDocIdSet((ImmutableRoaringBitmap)docIds, this._numDocs){

            @Override
            public long getNumEntriesScannedInFilter() {
                return scanBasedDocIdSet.getNumEntriesScannedInFilter();
            }
        });
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }
}

