/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.core.operator.blocks.FilterBlock;
import org.apache.pinot.core.operator.docidsets.FilterBlockDocIdSet;
import org.apache.pinot.core.operator.docidsets.OrDocIdSet;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;

public class OrFilterOperator
extends BaseFilterOperator {
    private static final String OPERATOR_NAME = "OrFilterOperator";
    private final List<BaseFilterOperator> _filterOperators;
    private final int _numDocs;

    public OrFilterOperator(List<BaseFilterOperator> filterOperators, int numDocs) {
        this._filterOperators = filterOperators;
        this._numDocs = numDocs;
    }

    @Override
    protected FilterBlock getNextBlock() {
        ArrayList<FilterBlockDocIdSet> filterBlockDocIdSets = new ArrayList<FilterBlockDocIdSet>(this._filterOperators.size());
        for (BaseFilterOperator filterOperator : this._filterOperators) {
            filterBlockDocIdSets.add(((FilterBlock)filterOperator.nextBlock()).getBlockDocIdSet());
        }
        return new FilterBlock(new OrDocIdSet(filterBlockDocIdSets, this._numDocs));
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }
}

