/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.core.common.DataSource;
import org.apache.pinot.core.operator.filter.AndFilterOperator;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.operator.filter.BitmapBasedFilterOperator;
import org.apache.pinot.core.operator.filter.EmptyFilterOperator;
import org.apache.pinot.core.operator.filter.ExpressionFilterOperator;
import org.apache.pinot.core.operator.filter.MatchAllFilterOperator;
import org.apache.pinot.core.operator.filter.OrFilterOperator;
import org.apache.pinot.core.operator.filter.RangeIndexBasedFilterOperator;
import org.apache.pinot.core.operator.filter.ScanBasedFilterOperator;
import org.apache.pinot.core.operator.filter.SortedIndexBasedFilterOperator;
import org.apache.pinot.core.operator.filter.TextMatchFilterOperator;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.core.query.request.context.predicate.Predicate;

public class FilterOperatorUtils {
    public static final String USE_SCAN_REORDER_OPTIMIZATION = "useScanReorderOpt";

    private FilterOperatorUtils() {
    }

    public static BaseFilterOperator getLeafFilterOperator(PredicateEvaluator predicateEvaluator, DataSource dataSource, int numDocs) {
        if (predicateEvaluator.isAlwaysFalse()) {
            return EmptyFilterOperator.getInstance();
        }
        if (predicateEvaluator.isAlwaysTrue()) {
            return new MatchAllFilterOperator(numDocs);
        }
        Predicate.Type predicateType = predicateEvaluator.getPredicateType();
        if (predicateType == Predicate.Type.RANGE) {
            if (dataSource.getDataSourceMetadata().isSorted()) {
                return new SortedIndexBasedFilterOperator(predicateEvaluator, dataSource, numDocs);
            }
            if (dataSource.getRangeIndex() != null) {
                return new RangeIndexBasedFilterOperator(predicateEvaluator, dataSource, numDocs);
            }
            return new ScanBasedFilterOperator(predicateEvaluator, dataSource, numDocs);
        }
        if (predicateType == Predicate.Type.REGEXP_LIKE) {
            return new ScanBasedFilterOperator(predicateEvaluator, dataSource, numDocs);
        }
        if (dataSource.getDataSourceMetadata().isSorted()) {
            return new SortedIndexBasedFilterOperator(predicateEvaluator, dataSource, numDocs);
        }
        if (dataSource.getInvertedIndex() != null) {
            return new BitmapBasedFilterOperator(predicateEvaluator, dataSource, numDocs);
        }
        return new ScanBasedFilterOperator(predicateEvaluator, dataSource, numDocs);
    }

    public static BaseFilterOperator getAndFilterOperator(List<BaseFilterOperator> filterOperators, int numDocs, @Nullable Map<String, String> debugOptions) {
        ArrayList<BaseFilterOperator> childFilterOperators = new ArrayList<BaseFilterOperator>(filterOperators.size());
        for (BaseFilterOperator filterOperator : filterOperators) {
            if (filterOperator.isResultEmpty()) {
                return EmptyFilterOperator.getInstance();
            }
            if (filterOperator.isResultMatchingAll()) continue;
            childFilterOperators.add(filterOperator);
        }
        int numChildFilterOperators = childFilterOperators.size();
        if (numChildFilterOperators == 0) {
            return new MatchAllFilterOperator(numDocs);
        }
        if (numChildFilterOperators == 1) {
            return (BaseFilterOperator)childFilterOperators.get(0);
        }
        FilterOperatorUtils.reorderAndFilterChildOperators(childFilterOperators, debugOptions);
        return new AndFilterOperator(childFilterOperators);
    }

    public static BaseFilterOperator getOrFilterOperator(List<BaseFilterOperator> filterOperators, int numDocs, @Nullable Map<String, String> debugOptions) {
        ArrayList<BaseFilterOperator> childFilterOperators = new ArrayList<BaseFilterOperator>(filterOperators.size());
        for (BaseFilterOperator filterOperator : filterOperators) {
            if (filterOperator.isResultMatchingAll()) {
                return new MatchAllFilterOperator(numDocs);
            }
            if (filterOperator.isResultEmpty()) continue;
            childFilterOperators.add(filterOperator);
        }
        int numChildFilterOperators = childFilterOperators.size();
        if (numChildFilterOperators == 0) {
            return EmptyFilterOperator.getInstance();
        }
        if (numChildFilterOperators == 1) {
            return (BaseFilterOperator)childFilterOperators.get(0);
        }
        return new OrFilterOperator(childFilterOperators, numDocs);
    }

    private static void reorderAndFilterChildOperators(List<BaseFilterOperator> filterOperators, final @Nullable Map<String, String> debugOptions) {
        filterOperators.sort(new Comparator<BaseFilterOperator>(){

            @Override
            public int compare(BaseFilterOperator o1, BaseFilterOperator o2) {
                return this.getPriority(o1) - this.getPriority(o2);
            }

            int getPriority(BaseFilterOperator filterOperator) {
                if (filterOperator instanceof SortedIndexBasedFilterOperator) {
                    return 0;
                }
                if (filterOperator instanceof BitmapBasedFilterOperator) {
                    return 1;
                }
                if (filterOperator instanceof RangeIndexBasedFilterOperator) {
                    return 2;
                }
                if (filterOperator instanceof TextMatchFilterOperator) {
                    return 3;
                }
                if (filterOperator instanceof AndFilterOperator) {
                    return 4;
                }
                if (filterOperator instanceof OrFilterOperator) {
                    return 5;
                }
                if (filterOperator instanceof ScanBasedFilterOperator) {
                    return FilterOperatorUtils.getScanBasedFilterPriority((ScanBasedFilterOperator)filterOperator, 6, debugOptions);
                }
                if (filterOperator instanceof ExpressionFilterOperator) {
                    return 10;
                }
                throw new IllegalStateException(filterOperator.getClass().getSimpleName() + " should not be reordered, remove it from the list before calling this method");
            }
        });
    }

    private static int getScanBasedFilterPriority(ScanBasedFilterOperator scanBasedFilterOperator, int basePriority, @Nullable Map<String, String> debugOptions) {
        if (debugOptions != null && StringUtils.compareIgnoreCase((String)debugOptions.get(USE_SCAN_REORDER_OPTIMIZATION), (String)"false") == 0) {
            return basePriority;
        }
        if (scanBasedFilterOperator.getDataSourceMetadata().isSingleValue()) {
            return basePriority;
        }
        return basePriority + 1;
    }
}

