/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import com.google.common.base.Preconditions;
import org.apache.pinot.core.common.DataSource;
import org.apache.pinot.core.operator.blocks.FilterBlock;
import org.apache.pinot.core.operator.docidsets.BitmapDocIdSet;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.core.segment.index.readers.InvertedIndexReader;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class BitmapBasedFilterOperator
extends BaseFilterOperator {
    private static final String OPERATOR_NAME = "BitmapBasedFilterOperator";
    private final PredicateEvaluator _predicateEvaluator;
    private final InvertedIndexReader _invertedIndexReader;
    private final ImmutableRoaringBitmap _docIds;
    private final boolean _exclusive;
    private final int _numDocs;

    BitmapBasedFilterOperator(PredicateEvaluator predicateEvaluator, DataSource dataSource, int numDocs) {
        this._predicateEvaluator = predicateEvaluator;
        this._invertedIndexReader = dataSource.getInvertedIndex();
        this._docIds = null;
        this._exclusive = predicateEvaluator.isExclusive();
        this._numDocs = numDocs;
    }

    public BitmapBasedFilterOperator(ImmutableRoaringBitmap docIds, boolean exclusive, int numDocs) {
        this._predicateEvaluator = null;
        this._invertedIndexReader = null;
        this._docIds = docIds;
        this._exclusive = exclusive;
        this._numDocs = numDocs;
    }

    @Override
    protected FilterBlock getNextBlock() {
        if (this._docIds != null) {
            if (this._exclusive) {
                return new FilterBlock(new BitmapDocIdSet((ImmutableRoaringBitmap)ImmutableRoaringBitmap.flip((ImmutableRoaringBitmap)this._docIds, (long)0L, (long)this._numDocs), this._numDocs));
            }
            return new FilterBlock(new BitmapDocIdSet(this._docIds, this._numDocs));
        }
        int[] dictIds = this._exclusive ? this._predicateEvaluator.getNonMatchingDictIds() : this._predicateEvaluator.getMatchingDictIds();
        int numDictIds = dictIds.length;
        Preconditions.checkState((numDictIds > 0 ? 1 : 0) != 0);
        if (numDictIds == 1) {
            ImmutableRoaringBitmap docIds = (ImmutableRoaringBitmap)this._invertedIndexReader.getDocIds(dictIds[0]);
            if (this._exclusive) {
                if (docIds instanceof MutableRoaringBitmap) {
                    MutableRoaringBitmap mutableRoaringBitmap = (MutableRoaringBitmap)docIds;
                    mutableRoaringBitmap.flip(0L, (long)this._numDocs);
                    return new FilterBlock(new BitmapDocIdSet((ImmutableRoaringBitmap)mutableRoaringBitmap, this._numDocs));
                }
                return new FilterBlock(new BitmapDocIdSet((ImmutableRoaringBitmap)ImmutableRoaringBitmap.flip((ImmutableRoaringBitmap)docIds, (long)0L, (long)this._numDocs), this._numDocs));
            }
            return new FilterBlock(new BitmapDocIdSet(docIds, this._numDocs));
        }
        ImmutableRoaringBitmap[] bitmaps = new ImmutableRoaringBitmap[numDictIds];
        for (int i = 0; i < numDictIds; ++i) {
            bitmaps[i] = (ImmutableRoaringBitmap)this._invertedIndexReader.getDocIds(dictIds[i]);
        }
        MutableRoaringBitmap docIds = ImmutableRoaringBitmap.or((ImmutableRoaringBitmap[])bitmaps);
        if (this._exclusive) {
            docIds.flip(0L, (long)this._numDocs);
        }
        return new FilterBlock(new BitmapDocIdSet((ImmutableRoaringBitmap)docIds, this._numDocs));
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }
}

