/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.core.operator.blocks.FilterBlock;
import org.apache.pinot.core.operator.docidsets.AndDocIdSet;
import org.apache.pinot.core.operator.docidsets.FilterBlockDocIdSet;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;

public class AndFilterOperator
extends BaseFilterOperator {
    private static final String OPERATOR_NAME = "AndFilterOperator";
    private final List<BaseFilterOperator> _filterOperators;

    public AndFilterOperator(List<BaseFilterOperator> filterOperators) {
        this._filterOperators = filterOperators;
    }

    @Override
    protected FilterBlock getNextBlock() {
        ArrayList<FilterBlockDocIdSet> filterBlockDocIdSets = new ArrayList<FilterBlockDocIdSet>(this._filterOperators.size());
        for (BaseFilterOperator filterOperator : this._filterOperators) {
            filterBlockDocIdSets.add(((FilterBlock)filterOperator.nextBlock()).getBlockDocIdSet());
        }
        return new FilterBlock(new AndDocIdSet(filterBlockDocIdSets));
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }
}

