/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.docvalsets;

import javax.annotation.Nullable;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.DataBlockCache;
import org.apache.pinot.core.common.DataSource;
import org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;

public class ProjectionBlockValSet
implements BlockValSet {
    private final DataBlockCache _dataBlockCache;
    private final String _column;
    private final DataSource _dataSource;

    public ProjectionBlockValSet(DataBlockCache dataBlockCache, String column, DataSource dataSource) {
        this._dataBlockCache = dataBlockCache;
        this._column = column;
        this._dataSource = dataSource;
    }

    @Override
    public FieldSpec.DataType getValueType() {
        return this._dataSource.getDataSourceMetadata().getDataType();
    }

    @Override
    public boolean isSingleValue() {
        return this._dataSource.getDataSourceMetadata().isSingleValue();
    }

    @Override
    @Nullable
    public Dictionary getDictionary() {
        return this._dataSource.getDictionary();
    }

    @Override
    public int[] getDictionaryIdsSV() {
        return this._dataBlockCache.getDictIdsForSVColumn(this._column);
    }

    @Override
    public int[] getIntValuesSV() {
        return this._dataBlockCache.getIntValuesForSVColumn(this._column);
    }

    @Override
    public long[] getLongValuesSV() {
        return this._dataBlockCache.getLongValuesForSVColumn(this._column);
    }

    @Override
    public float[] getFloatValuesSV() {
        return this._dataBlockCache.getFloatValuesForSVColumn(this._column);
    }

    @Override
    public double[] getDoubleValuesSV() {
        return this._dataBlockCache.getDoubleValuesForSVColumn(this._column);
    }

    @Override
    public String[] getStringValuesSV() {
        return this._dataBlockCache.getStringValuesForSVColumn(this._column);
    }

    @Override
    public byte[][] getBytesValuesSV() {
        return this._dataBlockCache.getBytesValuesForSVColumn(this._column);
    }

    @Override
    public int[][] getDictionaryIdsMV() {
        return this._dataBlockCache.getDictIdsForMVColumn(this._column);
    }

    @Override
    public int[][] getIntValuesMV() {
        return this._dataBlockCache.getIntValuesForMVColumn(this._column);
    }

    @Override
    public long[][] getLongValuesMV() {
        return this._dataBlockCache.getLongValuesForMVColumn(this._column);
    }

    @Override
    public float[][] getFloatValuesMV() {
        return this._dataBlockCache.getFloatValuesForMVColumn(this._column);
    }

    @Override
    public double[][] getDoubleValuesMV() {
        return this._dataBlockCache.getDoubleValuesForMVColumn(this._column);
    }

    @Override
    public String[][] getStringValuesMV() {
        return this._dataBlockCache.getStringValuesForMVColumn(this._column);
    }

    @Override
    public int[] getNumMVEntries() {
        return this._dataBlockCache.getNumValuesForMVColumn(this._column);
    }
}

