/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.dociditerators;

import java.util.List;
import org.apache.pinot.common.utils.Pairs;
import org.apache.pinot.core.common.BlockDocIdIterator;

public final class SortedDocIdIterator
implements BlockDocIdIterator {
    private final List<Pairs.IntPair> _docIdRanges;
    private final int _numRanges;
    private int _currentRangeId = 0;
    private int _nextDocId;

    public SortedDocIdIterator(List<Pairs.IntPair> docIdRanges) {
        this._docIdRanges = docIdRanges;
        this._numRanges = this._docIdRanges.size();
        this._nextDocId = docIdRanges.get(0).getLeft();
    }

    public List<Pairs.IntPair> getDocIdRanges() {
        return this._docIdRanges;
    }

    @Override
    public int next() {
        Pairs.IntPair currentRange = this._docIdRanges.get(this._currentRangeId);
        if (this._nextDocId <= currentRange.getRight()) {
            return this._nextDocId++;
        }
        if (this._currentRangeId < this._numRanges - 1) {
            ++this._currentRangeId;
            this._nextDocId = this._docIdRanges.get(this._currentRangeId).getLeft();
            return this._nextDocId++;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int advance(int targetDocId) {
        Pairs.IntPair currentRange = this._docIdRanges.get(this._currentRangeId);
        if (targetDocId <= currentRange.getRight()) {
            this._nextDocId = Math.max(targetDocId, currentRange.getLeft());
            return this._nextDocId++;
        }
        while (this._currentRangeId < this._numRanges - 1) {
            ++this._currentRangeId;
            currentRange = this._docIdRanges.get(this._currentRangeId);
            if (targetDocId > currentRange.getRight()) continue;
            this._nextDocId = Math.max(targetDocId, currentRange.getLeft());
            return this._nextDocId++;
        }
        return Integer.MIN_VALUE;
    }
}

