/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.dociditerators;

import org.apache.pinot.core.operator.dociditerators.ScanBasedDocIdIterator;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.core.segment.index.readers.ForwardIndexReader;
import org.apache.pinot.core.segment.index.readers.ForwardIndexReaderContext;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public final class SVScanDocIdIterator
implements ScanBasedDocIdIterator {
    private final PredicateEvaluator _predicateEvaluator;
    private final ForwardIndexReader _reader;
    private final ForwardIndexReaderContext _readerContext;
    private final int _numDocs;
    private final ValueMatcher _valueMatcher;
    private int _nextDocId = 0;
    private long _numEntriesScanned = 0L;

    public SVScanDocIdIterator(PredicateEvaluator predicateEvaluator, ForwardIndexReader reader, int numDocs) {
        this._predicateEvaluator = predicateEvaluator;
        this._reader = reader;
        this._readerContext = reader.createContext();
        this._numDocs = numDocs;
        this._valueMatcher = this.getValueMatcher();
    }

    @Override
    public int next() {
        while (this._nextDocId < this._numDocs) {
            int nextDocId;
            ++this._nextDocId;
            ++this._numEntriesScanned;
            if (!this._valueMatcher.doesValueMatch(nextDocId)) continue;
            return nextDocId;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int advance(int targetDocId) {
        this._nextDocId = targetDocId;
        return this.next();
    }

    @Override
    public MutableRoaringBitmap applyAnd(ImmutableRoaringBitmap docIds) {
        int nextDocId;
        MutableRoaringBitmap result = new MutableRoaringBitmap();
        PeekableIntIterator docIdIterator = docIds.getIntIterator();
        while (docIdIterator.hasNext() && (nextDocId = docIdIterator.next()) < this._numDocs) {
            ++this._numEntriesScanned;
            if (!this._valueMatcher.doesValueMatch(nextDocId)) continue;
            result.add(nextDocId);
        }
        return result;
    }

    @Override
    public long getNumEntriesScanned() {
        return this._numEntriesScanned;
    }

    private ValueMatcher getValueMatcher() {
        if (this._reader.isDictionaryEncoded()) {
            return new DictIdMatcher();
        }
        switch (this._reader.getValueType()) {
            case INT: {
                return new IntMatcher();
            }
            case LONG: {
                return new LongMatcher();
            }
            case FLOAT: {
                return new FloatMatcher();
            }
            case DOUBLE: {
                return new DoubleMatcher();
            }
            case STRING: {
                return new StringMatcher();
            }
            case BYTES: {
                return new BytesMatcher();
            }
        }
        throw new UnsupportedOperationException();
    }

    private class BytesMatcher
    implements ValueMatcher {
        private BytesMatcher() {
        }

        @Override
        public boolean doesValueMatch(int docId) {
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(SVScanDocIdIterator.this._reader.getBytes(docId, SVScanDocIdIterator.this._readerContext));
        }
    }

    private class StringMatcher
    implements ValueMatcher {
        private StringMatcher() {
        }

        @Override
        public boolean doesValueMatch(int docId) {
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(SVScanDocIdIterator.this._reader.getString(docId, SVScanDocIdIterator.this._readerContext));
        }
    }

    private class DoubleMatcher
    implements ValueMatcher {
        private DoubleMatcher() {
        }

        @Override
        public boolean doesValueMatch(int docId) {
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(SVScanDocIdIterator.this._reader.getDouble(docId, SVScanDocIdIterator.this._readerContext));
        }
    }

    private class FloatMatcher
    implements ValueMatcher {
        private FloatMatcher() {
        }

        @Override
        public boolean doesValueMatch(int docId) {
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(SVScanDocIdIterator.this._reader.getFloat(docId, SVScanDocIdIterator.this._readerContext));
        }
    }

    private class LongMatcher
    implements ValueMatcher {
        private LongMatcher() {
        }

        @Override
        public boolean doesValueMatch(int docId) {
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(SVScanDocIdIterator.this._reader.getLong(docId, SVScanDocIdIterator.this._readerContext));
        }
    }

    private class IntMatcher
    implements ValueMatcher {
        private IntMatcher() {
        }

        @Override
        public boolean doesValueMatch(int docId) {
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(SVScanDocIdIterator.this._reader.getInt(docId, SVScanDocIdIterator.this._readerContext));
        }
    }

    private class DictIdMatcher
    implements ValueMatcher {
        private DictIdMatcher() {
        }

        @Override
        public boolean doesValueMatch(int docId) {
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(SVScanDocIdIterator.this._reader.getDictId(docId, SVScanDocIdIterator.this._readerContext));
        }
    }

    private static interface ValueMatcher {
        public boolean doesValueMatch(int var1);
    }
}

