/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.combine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.DataSourceMetadata;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.core.operator.combine.BaseCombineOperator;
import org.apache.pinot.core.operator.combine.CombineOperatorUtils;
import org.apache.pinot.core.operator.query.SelectionOrderByOperator;
import org.apache.pinot.core.query.exception.EarlyTerminationException;
import org.apache.pinot.core.query.request.context.ExpressionContext;
import org.apache.pinot.core.query.request.context.OrderByExpressionContext;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.selection.SelectionOperatorUtils;
import org.apache.pinot.core.util.trace.TraceRunnable;

public class SelectionOrderByCombineOperator
extends BaseCombineOperator {
    private static final String OPERATOR_NAME = "SelectionOrderByCombineOperator";
    private static final IntermediateResultsBlock LAST_RESULTS_BLOCK = new IntermediateResultsBlock(new DataSchema(new String[0], new DataSchema.ColumnDataType[0]), Collections.emptyList());
    private final int _numRowsToKeep;

    public SelectionOrderByCombineOperator(List<Operator> operators, QueryContext queryContext, ExecutorService executorService, long endTimeMs) {
        super(operators, queryContext, executorService, endTimeMs);
        this._numRowsToKeep = queryContext.getLimit() + queryContext.getOffset();
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    protected IntermediateResultsBlock getNextBlock() {
        List<OrderByExpressionContext> orderByExpressions = this._queryContext.getOrderByExpressions();
        assert (orderByExpressions != null);
        if (orderByExpressions.get(0).getExpression().getType() == ExpressionContext.Type.IDENTIFIER) {
            return this.minMaxValueBasedCombine();
        }
        return super.getNextBlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IntermediateResultsBlock minMaxValueBasedCombine() {
        List<OrderByExpressionContext> orderByExpressions = this._queryContext.getOrderByExpressions();
        assert (orderByExpressions != null);
        final int numOrderByExpressions = orderByExpressions.size();
        assert (numOrderByExpressions > 0);
        OrderByExpressionContext firstOrderByExpression = orderByExpressions.get(0);
        assert (firstOrderByExpression.getExpression().getType() == ExpressionContext.Type.IDENTIFIER);
        String firstOrderByColumn = firstOrderByExpression.getExpression().getIdentifier();
        final boolean asc = firstOrderByExpression.isAsc();
        final int numOperators = this._operators.size();
        final ArrayList<MinMaxValueContext> minMaxValueContexts = new ArrayList<MinMaxValueContext>(numOperators);
        for (Operator operator : this._operators) {
            minMaxValueContexts.add(new MinMaxValueContext((SelectionOrderByOperator)operator, firstOrderByColumn));
        }
        try {
            if (asc) {
                minMaxValueContexts.sort((o1, o2) -> {
                    if (o1._minValue == null) {
                        return o2._minValue == null ? 0 : -1;
                    }
                    if (o2._minValue == null) {
                        return 1;
                    }
                    return o1._minValue.compareTo(o2._minValue);
                });
            } else {
                minMaxValueContexts.sort((o1, o2) -> {
                    if (o1._maxValue == null) {
                        return o2._maxValue == null ? 0 : -1;
                    }
                    if (o2._maxValue == null) {
                        return 1;
                    }
                    return o2._maxValue.compareTo(o1._maxValue);
                });
            }
        }
        catch (Exception e) {
            LOGGER.warn("Segments have different data types for the first order-by column: {}, using the default combine", (Object)firstOrderByColumn);
            return super.getNextBlock();
        }
        final int numThreads = CombineOperatorUtils.getNumThreadsForQuery(numOperators);
        final AtomicReference<Comparable> globalBoundaryValue = new AtomicReference<Comparable>();
        final ArrayBlockingQueue blockingQueue = new ArrayBlockingQueue(numOperators);
        final AtomicInteger numOperatorsSkipped = new AtomicInteger();
        final Phaser phaser = new Phaser(1);
        Future[] futures = new Future[numThreads];
        for (int i = 0; i < numThreads; ++i) {
            final int threadIndex = i;
            futures[i] = this._executorService.submit(new TraceRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void runJob() {
                    try {
                        if (phaser.register() < 0) {
                            return;
                        }
                        Comparable threadBoundaryValue = null;
                        for (int operatorIndex = threadIndex; operatorIndex < numOperators; operatorIndex += numThreads) {
                            Comparable boundaryValue = (Comparable)globalBoundaryValue.get();
                            if (boundaryValue == null) {
                                boundaryValue = threadBoundaryValue;
                            } else if (threadBoundaryValue != null) {
                                if (asc) {
                                    if (threadBoundaryValue.compareTo(boundaryValue) < 0) {
                                        boundaryValue = threadBoundaryValue;
                                    }
                                } else if (threadBoundaryValue.compareTo(boundaryValue) > 0) {
                                    boundaryValue = threadBoundaryValue;
                                }
                            }
                            MinMaxValueContext minMaxValueContext = (MinMaxValueContext)minMaxValueContexts.get(operatorIndex);
                            if (boundaryValue != null) {
                                int result;
                                if (asc) {
                                    if (minMaxValueContext._minValue != null) {
                                        int result2 = minMaxValueContext._minValue.compareTo(boundaryValue);
                                        if (result2 > 0 || result2 == 0 && numOrderByExpressions == 1) {
                                            numOperatorsSkipped.getAndAdd((numOperators - operatorIndex - 1) / numThreads);
                                            blockingQueue.offer(LAST_RESULTS_BLOCK);
                                            return;
                                        }
                                    }
                                } else if (minMaxValueContext._maxValue != null && ((result = minMaxValueContext._maxValue.compareTo(boundaryValue)) < 0 || result == 0 && numOrderByExpressions == 1)) {
                                    numOperatorsSkipped.getAndAdd((numOperators - operatorIndex - 1) / numThreads);
                                    blockingQueue.offer(LAST_RESULTS_BLOCK);
                                    return;
                                }
                            }
                            try {
                                IntermediateResultsBlock resultsBlock = (IntermediateResultsBlock)minMaxValueContext._operator.nextBlock();
                                PriorityQueue selectionResult = (PriorityQueue)resultsBlock.getSelectionResult();
                                if (selectionResult != null && selectionResult.size() == SelectionOrderByCombineOperator.this._numRowsToKeep) {
                                    assert (selectionResult.peek() != null);
                                    Comparable segmentBoundaryValue = (Comparable)((Object[])selectionResult.peek())[0];
                                    if (boundaryValue == null) {
                                        boundaryValue = segmentBoundaryValue;
                                    } else if (asc) {
                                        if (segmentBoundaryValue.compareTo(boundaryValue) < 0) {
                                            boundaryValue = segmentBoundaryValue;
                                        }
                                    } else if (segmentBoundaryValue.compareTo(boundaryValue) > 0) {
                                        boundaryValue = segmentBoundaryValue;
                                    }
                                }
                                threadBoundaryValue = boundaryValue;
                                blockingQueue.offer(resultsBlock);
                                continue;
                            }
                            catch (EarlyTerminationException e) {
                                phaser.arriveAndDeregister();
                                return;
                            }
                            catch (Exception e) {
                                try {
                                    BaseCombineOperator.LOGGER.error("Caught exception while executing operator of index: {} (query: {})", new Object[]{operatorIndex, SelectionOrderByCombineOperator.this._queryContext, e});
                                    blockingQueue.offer(new IntermediateResultsBlock(e));
                                    phaser.arriveAndDeregister();
                                }
                                catch (Throwable throwable) {
                                    throw throwable;
                                    return;
                                }
                                return;
                            }
                        }
                    }
                    finally {
                        phaser.arriveAndDeregister();
                    }
                }
            });
        }
        IntermediateResultsBlock mergedBlock = null;
        try {
            int numBlocksMerged = 0;
            while (numBlocksMerged + numOperatorsSkipped.get() < numOperators) {
                IntermediateResultsBlock blockToMerge = (IntermediateResultsBlock)blockingQueue.poll(this._endTimeMs - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                if (blockToMerge == null) {
                    LOGGER.error("Timed out while polling results block, numBlocksMerged: {} (query: {})", (Object)numBlocksMerged, (Object)this._queryContext);
                    mergedBlock = new IntermediateResultsBlock((Exception)QueryException.getException((ProcessingException)QueryException.EXECUTION_TIMEOUT_ERROR, (Exception)new TimeoutException("Timed out while polling results block")));
                    break;
                }
                if (blockToMerge.getProcessingExceptions() != null) {
                    mergedBlock = blockToMerge;
                    break;
                }
                if (mergedBlock == null) {
                    mergedBlock = blockToMerge;
                } else if (blockToMerge != LAST_RESULTS_BLOCK) {
                    this.mergeResultsBlocks(mergedBlock, blockToMerge);
                }
                ++numBlocksMerged;
                PriorityQueue selectionResult = (PriorityQueue)mergedBlock.getSelectionResult();
                if (selectionResult == null || selectionResult.size() != this._numRowsToKeep) continue;
                assert (selectionResult.peek() != null);
                globalBoundaryValue.set((Comparable)((Object[])selectionResult.peek())[0]);
            }
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while merging results blocks (query: {})", (Object)this._queryContext, (Object)e);
            mergedBlock = new IntermediateResultsBlock((Exception)QueryException.getException((ProcessingException)QueryException.INTERNAL_ERROR, (Exception)e));
        }
        finally {
            for (Future future : futures) {
                if (future.isDone()) continue;
                future.cancel(true);
            }
            phaser.awaitAdvance(phaser.arriveAndDeregister());
        }
        CombineOperatorUtils.setExecutionStatistics(mergedBlock, this._operators);
        return mergedBlock;
    }

    @Override
    protected void mergeResultsBlocks(IntermediateResultsBlock mergedBlock, IntermediateResultsBlock blockToMerge) {
        DataSchema mergedDataSchema = mergedBlock.getDataSchema();
        DataSchema dataSchemaToMerge = blockToMerge.getDataSchema();
        assert (mergedDataSchema != null && dataSchemaToMerge != null);
        if (!mergedDataSchema.equals((Object)dataSchemaToMerge)) {
            String errorMessage = String.format("Data schema mismatch between merged block: %s and block to merge: %s, drop block to merge", mergedDataSchema, dataSchemaToMerge);
            LOGGER.debug(errorMessage);
            mergedBlock.addToProcessingExceptions(QueryException.getException((ProcessingException)QueryException.MERGE_RESPONSE_ERROR, (String)errorMessage));
            return;
        }
        PriorityQueue mergedRows = (PriorityQueue)mergedBlock.getSelectionResult();
        Collection<Object[]> rowsToMerge = blockToMerge.getSelectionResult();
        assert (mergedRows != null && rowsToMerge != null);
        SelectionOperatorUtils.mergeWithOrdering(mergedRows, rowsToMerge, this._numRowsToKeep);
    }

    private static class MinMaxValueContext {
        final SelectionOrderByOperator _operator;
        final Comparable _minValue;
        final Comparable _maxValue;

        MinMaxValueContext(SelectionOrderByOperator operator, String column) {
            this._operator = operator;
            DataSourceMetadata dataSourceMetadata = operator.getIndexSegment().getDataSource(column).getDataSourceMetadata();
            this._minValue = dataSourceMetadata.getMinValue();
            this._maxValue = dataSourceMetadata.getMaxValue();
        }
    }
}

