/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.combine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.data.table.ConcurrentIndexedTable;
import org.apache.pinot.core.data.table.Key;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.core.operator.combine.CombineOperatorUtils;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.AggregationGroupByResult;
import org.apache.pinot.core.query.aggregation.groupby.GroupKeyGenerator;
import org.apache.pinot.core.query.exception.EarlyTerminationException;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.util.GroupByUtils;
import org.apache.pinot.core.util.trace.TraceRunnable;
import org.apache.pinot.spi.utils.BytesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupByOrderByCombineOperator
extends BaseOperator<IntermediateResultsBlock> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupByOrderByCombineOperator.class);
    private static final String OPERATOR_NAME = "GroupByOrderByCombineOperator";
    private final List<Operator> _operators;
    private final QueryContext _queryContext;
    private final ExecutorService _executorService;
    private final long _endTimeMs;
    private final int _indexedTableCapacity;
    private final Lock _initLock;
    private DataSchema _dataSchema;
    private ConcurrentIndexedTable _indexedTable;

    public GroupByOrderByCombineOperator(List<Operator> operators, QueryContext queryContext, ExecutorService executorService, long endTimeMs) {
        this._operators = operators;
        this._queryContext = queryContext;
        this._executorService = executorService;
        this._endTimeMs = endTimeMs;
        this._initLock = new ReentrantLock();
        this._indexedTableCapacity = GroupByUtils.getTableCapacity(this._queryContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IntermediateResultsBlock getNextBlock() {
        AggregationFunction[] aggregationFunctions = this._queryContext.getAggregationFunctions();
        assert (aggregationFunctions != null);
        final int numAggregationFunctions = aggregationFunctions.length;
        assert (this._queryContext.getGroupByExpressions() != null);
        final int numGroupByExpressions = this._queryContext.getGroupByExpressions().size();
        final int numColumns = numGroupByExpressions + numAggregationFunctions;
        final ConcurrentLinkedQueue mergedProcessingExceptions = new ConcurrentLinkedQueue();
        int numOperators = this._operators.size();
        final CountDownLatch operatorLatch = new CountDownLatch(numOperators);
        final Phaser phaser = new Phaser(1);
        Future[] futures = new Future[numOperators];
        for (int i = 0; i < numOperators; ++i) {
            final int index = i;
            futures[i] = this._executorService.submit(new TraceRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void runJob() {
                    try {
                        AggregationGroupByResult aggregationGroupByResult;
                        if (phaser.register() < 0) {
                            return;
                        }
                        IntermediateResultsBlock intermediateResultsBlock = (IntermediateResultsBlock)((Operator)GroupByOrderByCombineOperator.this._operators.get(index)).nextBlock();
                        GroupByOrderByCombineOperator.this._initLock.lock();
                        try {
                            if (GroupByOrderByCombineOperator.this._dataSchema == null) {
                                GroupByOrderByCombineOperator.this._dataSchema = intermediateResultsBlock.getDataSchema();
                                GroupByOrderByCombineOperator.this._indexedTable = new ConcurrentIndexedTable(GroupByOrderByCombineOperator.this._dataSchema, GroupByOrderByCombineOperator.this._queryContext, GroupByOrderByCombineOperator.this._indexedTableCapacity);
                            }
                        }
                        finally {
                            GroupByOrderByCombineOperator.this._initLock.unlock();
                        }
                        List<ProcessingException> processingExceptionsToMerge = intermediateResultsBlock.getProcessingExceptions();
                        if (processingExceptionsToMerge != null) {
                            mergedProcessingExceptions.addAll(processingExceptionsToMerge);
                        }
                        if ((aggregationGroupByResult = intermediateResultsBlock.getAggregationGroupByResult()) != null) {
                            if (numGroupByExpressions == 1) {
                                Function converterFunction = GroupByOrderByCombineOperator.this.getConverterFunction(GroupByOrderByCombineOperator.this._dataSchema.getColumnDataType(0));
                                Iterator<GroupKeyGenerator.GroupKey> groupKeyIterator = aggregationGroupByResult.getGroupKeyIterator();
                                while (groupKeyIterator.hasNext()) {
                                    Object[] values = new Object[numColumns];
                                    GroupKeyGenerator.GroupKey groupKey = groupKeyIterator.next();
                                    Object convertedKey = converterFunction.apply(groupKey._stringKey);
                                    values[0] = convertedKey;
                                    for (int i = 0; i < numAggregationFunctions; ++i) {
                                        values[i + 1] = aggregationGroupByResult.getResultForKey(groupKey, i);
                                    }
                                    Key key = new Key(new Object[]{convertedKey});
                                    Record record = new Record(values);
                                    GroupByOrderByCombineOperator.this._indexedTable.upsert(key, record);
                                }
                            } else {
                                Function[] converterFunctions = new Function[numGroupByExpressions];
                                for (int i = 0; i < numGroupByExpressions; ++i) {
                                    converterFunctions[i] = GroupByOrderByCombineOperator.this.getConverterFunction(GroupByOrderByCombineOperator.this._dataSchema.getColumnDataType(i));
                                }
                                Iterator<GroupKeyGenerator.GroupKey> groupKeyIterator = aggregationGroupByResult.getGroupKeyIterator();
                                while (groupKeyIterator.hasNext()) {
                                    int i;
                                    Object[] values = new Object[numColumns];
                                    int columnIndex = 0;
                                    GroupKeyGenerator.GroupKey groupKey = groupKeyIterator.next();
                                    String[] stringKeys = groupKey.getKeys();
                                    Object[] objectKeys = new Object[numGroupByExpressions];
                                    for (i = 0; i < numGroupByExpressions; ++i) {
                                        Object convertedKey = converterFunctions[i].apply(stringKeys[i]);
                                        objectKeys[columnIndex] = convertedKey;
                                        values[columnIndex] = convertedKey;
                                        ++columnIndex;
                                    }
                                    for (i = 0; i < numAggregationFunctions; ++i) {
                                        values[columnIndex] = aggregationGroupByResult.getResultForKey(groupKey, i);
                                        ++columnIndex;
                                    }
                                    Key key = new Key(objectKeys);
                                    Record record = new Record(values);
                                    GroupByOrderByCombineOperator.this._indexedTable.upsert(key, record);
                                }
                            }
                        }
                    }
                    catch (EarlyTerminationException intermediateResultsBlock) {
                    }
                    catch (Exception e) {
                        LOGGER.error("Caught exception while processing and combining group-by order-by for index: {}, operator: {}, queryContext: {}", new Object[]{index, ((Operator)GroupByOrderByCombineOperator.this._operators.get(index)).getClass().getName(), GroupByOrderByCombineOperator.this._queryContext, e});
                        mergedProcessingExceptions.add(QueryException.getException((ProcessingException)QueryException.QUERY_EXECUTION_ERROR, (Exception)e));
                    }
                    finally {
                        operatorLatch.countDown();
                        phaser.arriveAndDeregister();
                    }
                }
            });
        }
        try {
            long timeoutMs = this._endTimeMs - System.currentTimeMillis();
            boolean opCompleted = operatorLatch.await(timeoutMs, TimeUnit.MILLISECONDS);
            if (!opCompleted) {
                String errorMessage = String.format("Timed out while combining group-by order-by results after %dms, queryContext = %s", timeoutMs, this._queryContext);
                LOGGER.error(errorMessage);
                IntermediateResultsBlock intermediateResultsBlock = new IntermediateResultsBlock(new TimeoutException(errorMessage));
                return intermediateResultsBlock;
            }
            this._indexedTable.finish(false);
            IntermediateResultsBlock mergedBlock = new IntermediateResultsBlock(this._indexedTable);
            if (!mergedProcessingExceptions.isEmpty()) {
                mergedBlock.setProcessingExceptions(new ArrayList<ProcessingException>(mergedProcessingExceptions));
            }
            CombineOperatorUtils.setExecutionStatistics(mergedBlock, this._operators);
            if (this._indexedTable.size() >= this._indexedTableCapacity) {
                mergedBlock.setNumGroupsLimitReached(true);
            }
            IntermediateResultsBlock intermediateResultsBlock = mergedBlock;
            return intermediateResultsBlock;
        }
        catch (Exception e) {
            IntermediateResultsBlock intermediateResultsBlock = new IntermediateResultsBlock(e);
            return intermediateResultsBlock;
        }
        finally {
            for (Future future : futures) {
                if (future.isDone()) continue;
                future.cancel(true);
            }
            phaser.awaitAdvance(phaser.arriveAndDeregister());
        }
    }

    private Function<String, Object> getConverterFunction(DataSchema.ColumnDataType columnDataType) {
        switch (columnDataType) {
            case INT: {
                return Integer::valueOf;
            }
            case LONG: {
                return Long::valueOf;
            }
            case FLOAT: {
                return Float::valueOf;
            }
            case DOUBLE: {
                return Double::valueOf;
            }
            case STRING: {
                return s -> s;
            }
            case BYTES: {
                return BytesUtils::toByteArray;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }
}

