/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.combine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.core.operator.combine.CombineOperatorUtils;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.AggregationGroupByResult;
import org.apache.pinot.core.query.aggregation.groupby.AggregationGroupByTrimmingService;
import org.apache.pinot.core.query.aggregation.groupby.GroupKeyGenerator;
import org.apache.pinot.core.query.exception.EarlyTerminationException;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.util.trace.TraceRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupByCombineOperator
extends BaseOperator<IntermediateResultsBlock> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupByCombineOperator.class);
    private static final String OPERATOR_NAME = "GroupByCombineOperator";
    private static final int INTER_SEGMENT_NUM_GROUPS_LIMIT_FACTOR = 2;
    private final List<Operator> _operators;
    private final QueryContext _queryContext;
    private final ExecutorService _executorService;
    private final long _endTimeMs;
    private final int _innerSegmentNumGroupsLimit;
    private final int _interSegmentNumGroupsLimit;

    public GroupByCombineOperator(List<Operator> operators, QueryContext queryContext, ExecutorService executorService, long endTimeMs, int innerSegmentNumGroupsLimit) {
        this._operators = operators;
        this._queryContext = queryContext;
        this._executorService = executorService;
        this._endTimeMs = endTimeMs;
        this._innerSegmentNumGroupsLimit = innerSegmentNumGroupsLimit;
        this._interSegmentNumGroupsLimit = (int)Math.min((long)innerSegmentNumGroupsLimit * 2L, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IntermediateResultsBlock getNextBlock() {
        final ConcurrentHashMap<String, Object[]> resultsMap = new ConcurrentHashMap<String, Object[]>();
        final AtomicInteger numGroups = new AtomicInteger();
        final ConcurrentLinkedQueue mergedProcessingExceptions = new ConcurrentLinkedQueue();
        final AggregationFunction[] aggregationFunctions = this._queryContext.getAggregationFunctions();
        assert (aggregationFunctions != null);
        final int numAggregationFunctions = aggregationFunctions.length;
        int numOperators = this._operators.size();
        final CountDownLatch operatorLatch = new CountDownLatch(numOperators);
        final Phaser phaser = new Phaser(1);
        Future[] futures = new Future[numOperators];
        for (int i = 0; i < numOperators; ++i) {
            final int index = i;
            futures[i] = this._executorService.submit(new TraceRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void runJob() {
                    try {
                        AggregationGroupByResult aggregationGroupByResult;
                        if (phaser.register() < 0) {
                            return;
                        }
                        IntermediateResultsBlock intermediateResultsBlock = (IntermediateResultsBlock)((Operator)GroupByCombineOperator.this._operators.get(index)).nextBlock();
                        List<ProcessingException> processingExceptionsToMerge = intermediateResultsBlock.getProcessingExceptions();
                        if (processingExceptionsToMerge != null) {
                            mergedProcessingExceptions.addAll(processingExceptionsToMerge);
                        }
                        if ((aggregationGroupByResult = intermediateResultsBlock.getAggregationGroupByResult()) != null) {
                            Iterator<GroupKeyGenerator.GroupKey> groupKeyIterator = aggregationGroupByResult.getGroupKeyIterator();
                            while (groupKeyIterator.hasNext()) {
                                GroupKeyGenerator.GroupKey groupKey = groupKeyIterator.next();
                                resultsMap.compute(groupKey._stringKey, (key, value) -> {
                                    block3: {
                                        block2: {
                                            if (value != null) break block2;
                                            if (numGroups.getAndIncrement() >= GroupByCombineOperator.this._interSegmentNumGroupsLimit) break block3;
                                            value = new Object[numAggregationFunctions];
                                            for (int i = 0; i < numAggregationFunctions; ++i) {
                                                value[i] = aggregationGroupByResult.getResultForKey(groupKey, i);
                                            }
                                            break block3;
                                        }
                                        for (int i = 0; i < numAggregationFunctions; ++i) {
                                            value[i] = aggregationFunctions[i].merge(value[i], aggregationGroupByResult.getResultForKey(groupKey, i));
                                        }
                                    }
                                    return value;
                                });
                            }
                        }
                    }
                    catch (EarlyTerminationException intermediateResultsBlock) {
                    }
                    catch (Exception e) {
                        LOGGER.error("Caught exception while processing and combining group-by for index: {}, operator: {}, queryContext: {}", new Object[]{index, ((Operator)GroupByCombineOperator.this._operators.get(index)).getClass().getName(), GroupByCombineOperator.this._queryContext, e});
                        mergedProcessingExceptions.add(QueryException.getException((ProcessingException)QueryException.QUERY_EXECUTION_ERROR, (Exception)e));
                    }
                    finally {
                        operatorLatch.countDown();
                        phaser.arriveAndDeregister();
                    }
                }
            });
        }
        try {
            long timeoutMs = this._endTimeMs - System.currentTimeMillis();
            boolean opCompleted = operatorLatch.await(timeoutMs, TimeUnit.MILLISECONDS);
            if (!opCompleted) {
                String errorMessage = String.format("Timed out while combining group-by results after %dms, queryContext = %s", timeoutMs, this._queryContext);
                LOGGER.error(errorMessage);
                IntermediateResultsBlock intermediateResultsBlock = new IntermediateResultsBlock(new TimeoutException(errorMessage));
                return intermediateResultsBlock;
            }
            AggregationGroupByTrimmingService aggregationGroupByTrimmingService = new AggregationGroupByTrimmingService(this._queryContext);
            List<Map<String, Object>> trimmedResults = aggregationGroupByTrimmingService.trimIntermediateResultsMap(resultsMap);
            IntermediateResultsBlock mergedBlock = new IntermediateResultsBlock(aggregationFunctions, trimmedResults, true);
            if (!mergedProcessingExceptions.isEmpty()) {
                mergedBlock.setProcessingExceptions(new ArrayList<ProcessingException>(mergedProcessingExceptions));
            }
            CombineOperatorUtils.setExecutionStatistics(mergedBlock, this._operators);
            if (resultsMap.size() >= this._innerSegmentNumGroupsLimit) {
                mergedBlock.setNumGroupsLimitReached(true);
            }
            IntermediateResultsBlock intermediateResultsBlock = mergedBlock;
            return intermediateResultsBlock;
        }
        catch (Exception e) {
            IntermediateResultsBlock intermediateResultsBlock = new IntermediateResultsBlock(e);
            return intermediateResultsBlock;
        }
        finally {
            for (Future future : futures) {
                if (future.isDone()) continue;
                future.cancel(true);
            }
            phaser.awaitAdvance(phaser.arriveAndDeregister());
        }
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }
}

