/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.combine;

import java.util.List;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;

public class CombineOperatorUtils {
    public static final int MAX_NUM_THREADS_PER_QUERY = Math.max(1, Math.min(10, Runtime.getRuntime().availableProcessors() / 2));

    private CombineOperatorUtils() {
    }

    public static int getNumThreadsForQuery(int numOperators) {
        return Math.min(numOperators, MAX_NUM_THREADS_PER_QUERY);
    }

    public static void setExecutionStatistics(IntermediateResultsBlock resultsBlock, List<Operator> operators) {
        int numSegmentsProcessed = operators.size();
        int numSegmentsMatched = 0;
        long numDocsScanned = 0L;
        long numEntriesScannedInFilter = 0L;
        long numEntriesScannedPostFilter = 0L;
        long numTotalDocs = 0L;
        for (Operator operator : operators) {
            ExecutionStatistics executionStatistics = operator.getExecutionStatistics();
            if (executionStatistics.getNumDocsScanned() > 0L) {
                ++numSegmentsMatched;
            }
            numDocsScanned += executionStatistics.getNumDocsScanned();
            numEntriesScannedInFilter += executionStatistics.getNumEntriesScannedInFilter();
            numEntriesScannedPostFilter += executionStatistics.getNumEntriesScannedPostFilter();
            numTotalDocs += executionStatistics.getNumTotalDocs();
        }
        resultsBlock.setNumSegmentsProcessed(numSegmentsProcessed);
        resultsBlock.setNumSegmentsMatched(numSegmentsMatched);
        resultsBlock.setNumDocsScanned(numDocsScanned);
        resultsBlock.setNumEntriesScannedInFilter(numEntriesScannedInFilter);
        resultsBlock.setNumEntriesScannedPostFilter(numEntriesScannedPostFilter);
        resultsBlock.setNumTotalDocs(numTotalDocs);
    }
}

