/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.combine;

import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.core.operator.combine.CombineOperatorUtils;
import org.apache.pinot.core.query.exception.EarlyTerminationException;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.util.trace.TraceRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCombineOperator
extends BaseOperator<IntermediateResultsBlock> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BaseCombineOperator.class);
    protected final List<Operator> _operators;
    protected final QueryContext _queryContext;
    protected final ExecutorService _executorService;
    protected final long _endTimeMs;

    public BaseCombineOperator(List<Operator> operators, QueryContext queryContext, ExecutorService executorService, long endTimeMs) {
        this._operators = operators;
        this._queryContext = queryContext;
        this._executorService = executorService;
        this._endTimeMs = endTimeMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IntermediateResultsBlock getNextBlock() {
        final int numOperators = this._operators.size();
        final int numThreads = CombineOperatorUtils.getNumThreadsForQuery(numOperators);
        final ArrayBlockingQueue blockingQueue = new ArrayBlockingQueue(numOperators);
        final Phaser phaser = new Phaser(1);
        Future[] futures = new Future[numThreads];
        for (int i = 0; i < numThreads; ++i) {
            final int threadIndex = i;
            futures[i] = this._executorService.submit(new TraceRunnable(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void runJob() {
                    try {
                        if (phaser.register() < 0) {
                            return;
                        }
                        for (int operatorIndex = threadIndex; operatorIndex < numOperators; operatorIndex += numThreads) {
                            IntermediateResultsBlock resultsBlock;
                            block13: {
                                resultsBlock = (IntermediateResultsBlock)BaseCombineOperator.this._operators.get(operatorIndex).nextBlock();
                                if (!BaseCombineOperator.this.isQuerySatisfied(resultsBlock)) break block13;
                                blockingQueue.offer(resultsBlock);
                                return;
                            }
                            try {
                                blockingQueue.offer(resultsBlock);
                                continue;
                            }
                            catch (EarlyTerminationException e) {
                                phaser.arriveAndDeregister();
                                return;
                            }
                            catch (Exception e) {
                                try {
                                    LOGGER.error("Caught exception while executing operator of index: {} (query: {})", new Object[]{operatorIndex, BaseCombineOperator.this._queryContext, e});
                                    blockingQueue.offer(new IntermediateResultsBlock(e));
                                    phaser.arriveAndDeregister();
                                }
                                catch (Throwable throwable) {
                                    throw throwable;
                                    return;
                                }
                                return;
                            }
                        }
                    }
                    finally {
                        phaser.arriveAndDeregister();
                    }
                }
            });
        }
        IntermediateResultsBlock mergedBlock = null;
        try {
            for (int numBlocksMerged = 0; numBlocksMerged < numOperators; ++numBlocksMerged) {
                IntermediateResultsBlock blockToMerge = (IntermediateResultsBlock)blockingQueue.poll(this._endTimeMs - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                if (blockToMerge == null) {
                    LOGGER.error("Timed out while polling results block, numBlocksMerged: {} (query: {})", (Object)numBlocksMerged, (Object)this._queryContext);
                    mergedBlock = new IntermediateResultsBlock((Exception)QueryException.getException((ProcessingException)QueryException.EXECUTION_TIMEOUT_ERROR, (Exception)new TimeoutException("Timed out while polling results block")));
                } else if (blockToMerge.getProcessingExceptions() != null) {
                    mergedBlock = blockToMerge;
                } else {
                    if (mergedBlock == null) {
                        mergedBlock = blockToMerge;
                        continue;
                    }
                    this.mergeResultsBlocks(mergedBlock, blockToMerge);
                    if (!this.isQuerySatisfied(mergedBlock)) continue;
                }
                break;
            }
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while merging results blocks (query: {})", (Object)this._queryContext, (Object)e);
            mergedBlock = new IntermediateResultsBlock((Exception)QueryException.getException((ProcessingException)QueryException.INTERNAL_ERROR, (Exception)e));
        }
        finally {
            for (Future future : futures) {
                if (future.isDone()) continue;
                future.cancel(true);
            }
            phaser.awaitAdvance(phaser.arriveAndDeregister());
        }
        CombineOperatorUtils.setExecutionStatistics(mergedBlock, this._operators);
        return mergedBlock;
    }

    protected boolean isQuerySatisfied(IntermediateResultsBlock resultsBlock) {
        return false;
    }

    protected abstract void mergeResultsBlocks(IntermediateResultsBlock var1, IntermediateResultsBlock var2);
}

