/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.combine;

import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.core.operator.combine.BaseCombineOperator;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.request.context.QueryContext;

public class AggregationOnlyCombineOperator
extends BaseCombineOperator {
    private static final String OPERATOR_NAME = "AggregationOnlyCombineOperator";

    public AggregationOnlyCombineOperator(List<Operator> operators, QueryContext queryContext, ExecutorService executorService, long endTimeMs) {
        super(operators, queryContext, executorService, endTimeMs);
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    protected void mergeResultsBlocks(IntermediateResultsBlock mergedBlock, IntermediateResultsBlock blockToMerge) {
        AggregationFunction[] aggregationFunctions = mergedBlock.getAggregationFunctions();
        List<Object> mergedResults = mergedBlock.getAggregationResult();
        List<Object> resultsToMerge = blockToMerge.getAggregationResult();
        assert (aggregationFunctions != null && mergedResults != null && resultsToMerge != null);
        int numAggregationFunctions = aggregationFunctions.length;
        for (int i = 0; i < numAggregationFunctions; ++i) {
            mergedResults.set(i, aggregationFunctions[i].merge(mergedResults.get(i), resultsToMerge.get(i)));
        }
    }
}

