/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.blocks;

import java.util.Map;
import org.apache.pinot.core.common.Block;
import org.apache.pinot.core.common.BlockDocIdSet;
import org.apache.pinot.core.common.BlockDocIdValueSet;
import org.apache.pinot.core.common.BlockMetadata;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.DataBlockCache;
import org.apache.pinot.core.common.DataSource;
import org.apache.pinot.core.operator.docvalsets.ProjectionBlockValSet;

public class ProjectionBlock
implements Block {
    private final Map<String, DataSource> _dataSourceMap;
    private final DataBlockCache _dataBlockCache;

    public ProjectionBlock(Map<String, DataSource> dataSourceMap, DataBlockCache dataBlockCache) {
        this._dataSourceMap = dataSourceMap;
        this._dataBlockCache = dataBlockCache;
    }

    public int getNumDocs() {
        return this._dataBlockCache.getNumDocs();
    }

    public BlockValSet getBlockValueSet(String column) {
        return new ProjectionBlockValSet(this._dataBlockCache, column, this._dataSourceMap.get(column));
    }

    @Override
    public BlockDocIdSet getBlockDocIdSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockValSet getBlockValueSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockDocIdValueSet getBlockDocIdValueSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockMetadata getMetadata() {
        throw new UnsupportedOperationException();
    }
}

