/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.blocks;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.common.Block;
import org.apache.pinot.core.common.BlockDocIdSet;
import org.apache.pinot.core.common.BlockDocIdValueSet;
import org.apache.pinot.core.common.BlockMetadata;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.datatable.DataTableBuilder;
import org.apache.pinot.core.common.datatable.DataTableImplV2;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.data.table.Table;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.AggregationGroupByResult;
import org.apache.pinot.core.query.selection.SelectionOperatorUtils;
import org.apache.pinot.spi.utils.ByteArray;

public class IntermediateResultsBlock
implements Block {
    private DataSchema _dataSchema;
    private Collection<Object[]> _selectionResult;
    private AggregationFunction[] _aggregationFunctions;
    private List<Object> _aggregationResult;
    private AggregationGroupByResult _aggregationGroupByResult;
    private List<Map<String, Object>> _combinedAggregationGroupByResult;
    private List<ProcessingException> _processingExceptions;
    private long _numDocsScanned;
    private long _numEntriesScannedInFilter;
    private long _numEntriesScannedPostFilter;
    private long _numTotalDocs;
    private int _numSegmentsProcessed;
    private int _numSegmentsMatched;
    private boolean _numGroupsLimitReached;
    private Table _table;

    public IntermediateResultsBlock() {
    }

    public IntermediateResultsBlock(DataSchema dataSchema, Collection<Object[]> selectionResult) {
        this._dataSchema = dataSchema;
        this._selectionResult = selectionResult;
    }

    public IntermediateResultsBlock(AggregationFunction[] aggregationFunctions, List aggregationResult, boolean isGroupBy) {
        this._aggregationFunctions = aggregationFunctions;
        if (isGroupBy) {
            this._combinedAggregationGroupByResult = aggregationResult;
        } else {
            this._aggregationResult = aggregationResult;
        }
    }

    public IntermediateResultsBlock(AggregationFunction[] aggregationFunctions, @Nullable AggregationGroupByResult aggregationGroupByResults) {
        this._aggregationFunctions = aggregationFunctions;
        this._aggregationGroupByResult = aggregationGroupByResults;
    }

    public IntermediateResultsBlock(AggregationFunction[] aggregationFunctions, @Nullable AggregationGroupByResult aggregationGroupByResults, DataSchema dataSchema) {
        this._aggregationFunctions = aggregationFunctions;
        this._aggregationGroupByResult = aggregationGroupByResults;
        this._dataSchema = dataSchema;
    }

    public IntermediateResultsBlock(Table table) {
        this._table = table;
        this._dataSchema = table.getDataSchema();
    }

    public IntermediateResultsBlock(ProcessingException processingException, Exception e) {
        this._processingExceptions = new ArrayList<ProcessingException>();
        this._processingExceptions.add(QueryException.getException((ProcessingException)processingException, (Exception)e));
    }

    public IntermediateResultsBlock(Exception e) {
        this(QueryException.QUERY_EXECUTION_ERROR, e);
    }

    @Nullable
    public DataSchema getDataSchema() {
        return this._dataSchema;
    }

    public void setDataSchema(DataSchema dataSchema) {
        this._dataSchema = dataSchema;
    }

    @Nullable
    public Collection<Object[]> getSelectionResult() {
        return this._selectionResult;
    }

    public void setSelectionResult(Collection<Object[]> rowEventsSet) {
        this._selectionResult = rowEventsSet;
    }

    @Nullable
    public AggregationFunction[] getAggregationFunctions() {
        return this._aggregationFunctions;
    }

    public void setAggregationFunctions(AggregationFunction[] aggregationFunctions) {
        this._aggregationFunctions = aggregationFunctions;
    }

    @Nullable
    public List<Object> getAggregationResult() {
        return this._aggregationResult;
    }

    public void setAggregationResults(List<Object> aggregationResults) {
        this._aggregationResult = aggregationResults;
    }

    @Nullable
    public AggregationGroupByResult getAggregationGroupByResult() {
        return this._aggregationGroupByResult;
    }

    @Nullable
    public List<ProcessingException> getProcessingExceptions() {
        return this._processingExceptions;
    }

    public void setProcessingExceptions(List<ProcessingException> processingExceptions) {
        this._processingExceptions = processingExceptions;
    }

    public void addToProcessingExceptions(ProcessingException processingException) {
        if (this._processingExceptions == null) {
            this._processingExceptions = new ArrayList<ProcessingException>();
        }
        this._processingExceptions.add(processingException);
    }

    public void setNumDocsScanned(long numDocsScanned) {
        this._numDocsScanned = numDocsScanned;
    }

    public void setNumEntriesScannedInFilter(long numEntriesScannedInFilter) {
        this._numEntriesScannedInFilter = numEntriesScannedInFilter;
    }

    public void setNumEntriesScannedPostFilter(long numEntriesScannedPostFilter) {
        this._numEntriesScannedPostFilter = numEntriesScannedPostFilter;
    }

    public void setNumSegmentsProcessed(int numSegmentsProcessed) {
        this._numSegmentsProcessed = numSegmentsProcessed;
    }

    public void setNumSegmentsMatched(int numSegmentsMatched) {
        this._numSegmentsMatched = numSegmentsMatched;
    }

    public void setNumTotalDocs(long numTotalDocs) {
        this._numTotalDocs = numTotalDocs;
    }

    public void setNumGroupsLimitReached(boolean numGroupsLimitReached) {
        this._numGroupsLimitReached = numGroupsLimitReached;
    }

    @VisibleForTesting
    public long getNumDocsScanned() {
        return this._numDocsScanned;
    }

    @VisibleForTesting
    public long getNumEntriesScannedInFilter() {
        return this._numEntriesScannedInFilter;
    }

    @VisibleForTesting
    public long getNumEntriesScannedPostFilter() {
        return this._numEntriesScannedPostFilter;
    }

    @VisibleForTesting
    public int getNumSegmentsProcessed() {
        return this._numSegmentsProcessed;
    }

    @VisibleForTesting
    public int getNumSegmentsMatched() {
        return this._numSegmentsMatched;
    }

    @VisibleForTesting
    public long getNumTotalDocs() {
        return this._numTotalDocs;
    }

    @VisibleForTesting
    public boolean isNumGroupsLimitReached() {
        return this._numGroupsLimitReached;
    }

    public DataTable getDataTable() throws Exception {
        if (this._table != null) {
            return this.getResultDataTable();
        }
        if (this._selectionResult != null) {
            return this.getSelectionResultDataTable();
        }
        if (this._aggregationResult != null) {
            return this.getAggregationResultDataTable();
        }
        if (this._combinedAggregationGroupByResult != null) {
            return this.getAggregationGroupByResultDataTable();
        }
        return this.getMetadataDataTable();
    }

    private DataTable getResultDataTable() throws IOException {
        DataTableBuilder dataTableBuilder = new DataTableBuilder(this._dataSchema);
        Iterator<Record> iterator = this._table.iterator();
        while (iterator.hasNext()) {
            Record record = iterator.next();
            dataTableBuilder.startRow();
            int columnIndex = 0;
            for (Object value : record.getValues()) {
                DataSchema.ColumnDataType columnDataType = this._dataSchema.getColumnDataType(columnIndex);
                this.setDataTableColumn(columnDataType, dataTableBuilder, columnIndex, value);
                ++columnIndex;
            }
            dataTableBuilder.finishRow();
        }
        DataTable dataTable = dataTableBuilder.build();
        return this.attachMetadataToDataTable(dataTable);
    }

    private void setDataTableColumn(DataSchema.ColumnDataType columnDataType, DataTableBuilder dataTableBuilder, int columnIndex, Object value) throws IOException {
        switch (columnDataType) {
            case INT: {
                dataTableBuilder.setColumn(columnIndex, (Integer)value);
                break;
            }
            case LONG: {
                dataTableBuilder.setColumn(columnIndex, (Long)value);
                break;
            }
            case FLOAT: {
                dataTableBuilder.setColumn(columnIndex, ((Float)value).floatValue());
                break;
            }
            case DOUBLE: {
                dataTableBuilder.setColumn(columnIndex, (Double)value);
                break;
            }
            case STRING: {
                dataTableBuilder.setColumn(columnIndex, (String)value);
                break;
            }
            case BYTES: {
                dataTableBuilder.setColumn(columnIndex, (ByteArray)value);
                break;
            }
            case OBJECT: {
                dataTableBuilder.setColumn(columnIndex, value);
                break;
            }
            case INT_ARRAY: {
                dataTableBuilder.setColumn(columnIndex, (int[])value);
                break;
            }
            case LONG_ARRAY: {
                dataTableBuilder.setColumn(columnIndex, (long[])value);
                break;
            }
            case FLOAT_ARRAY: {
                dataTableBuilder.setColumn(columnIndex, (float[])value);
                break;
            }
            case DOUBLE_ARRAY: {
                dataTableBuilder.setColumn(columnIndex, (double[])value);
                break;
            }
            case STRING_ARRAY: {
                dataTableBuilder.setColumn(columnIndex, (String[])value);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private DataTable getSelectionResultDataTable() throws Exception {
        return this.attachMetadataToDataTable(SelectionOperatorUtils.getDataTableFromRows(this._selectionResult, this._dataSchema));
    }

    private DataTable getAggregationResultDataTable() throws Exception {
        int numAggregationFunctions = this._aggregationFunctions.length;
        String[] columnNames = new String[numAggregationFunctions];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numAggregationFunctions];
        for (int i = 0; i < numAggregationFunctions; ++i) {
            AggregationFunction aggregationFunction = this._aggregationFunctions[i];
            columnNames[i] = aggregationFunction.getColumnName();
            columnDataTypes[i] = aggregationFunction.getIntermediateResultColumnType();
        }
        DataTableBuilder dataTableBuilder = new DataTableBuilder(new DataSchema(columnNames, columnDataTypes));
        dataTableBuilder.startRow();
        block6: for (int i = 0; i < numAggregationFunctions; ++i) {
            switch (columnDataTypes[i]) {
                case LONG: {
                    dataTableBuilder.setColumn(i, ((Number)this._aggregationResult.get(i)).longValue());
                    continue block6;
                }
                case DOUBLE: {
                    dataTableBuilder.setColumn(i, (Double)this._aggregationResult.get(i));
                    continue block6;
                }
                case OBJECT: {
                    dataTableBuilder.setColumn(i, this._aggregationResult.get(i));
                    continue block6;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported aggregation column data type: " + columnDataTypes[i] + " for column: " + columnNames[i]);
                }
            }
        }
        dataTableBuilder.finishRow();
        DataTable dataTable = dataTableBuilder.build();
        return this.attachMetadataToDataTable(dataTable);
    }

    private DataTable getAggregationGroupByResultDataTable() throws Exception {
        String[] columnNames = new String[]{"functionName", "GroupByResultMap"};
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[]{DataSchema.ColumnDataType.STRING, DataSchema.ColumnDataType.OBJECT};
        DataTableBuilder dataTableBuilder = new DataTableBuilder(new DataSchema(columnNames, columnDataTypes));
        int numAggregationFunctions = this._aggregationFunctions.length;
        for (int i = 0; i < numAggregationFunctions; ++i) {
            dataTableBuilder.startRow();
            AggregationFunction aggregationFunction = this._aggregationFunctions[i];
            dataTableBuilder.setColumn(0, aggregationFunction.getColumnName());
            dataTableBuilder.setColumn(1, this._combinedAggregationGroupByResult.get(i));
            dataTableBuilder.finishRow();
        }
        DataTable dataTable = dataTableBuilder.build();
        return this.attachMetadataToDataTable(dataTable);
    }

    private DataTable getMetadataDataTable() {
        return this.attachMetadataToDataTable(new DataTableImplV2());
    }

    private DataTable attachMetadataToDataTable(DataTable dataTable) {
        dataTable.getMetadata().put("numDocsScanned", String.valueOf(this._numDocsScanned));
        dataTable.getMetadata().put("numEntriesScannedInFilter", String.valueOf(this._numEntriesScannedInFilter));
        dataTable.getMetadata().put("numEntriesScannedPostFilter", String.valueOf(this._numEntriesScannedPostFilter));
        dataTable.getMetadata().put("numSegmentsProcessed", String.valueOf(this._numSegmentsProcessed));
        dataTable.getMetadata().put("numSegmentsMatched", String.valueOf(this._numSegmentsMatched));
        dataTable.getMetadata().put("totalDocs", String.valueOf(this._numTotalDocs));
        if (this._numGroupsLimitReached) {
            dataTable.getMetadata().put("numGroupsLimitReached", "true");
        }
        if (this._processingExceptions != null && this._processingExceptions.size() > 0) {
            for (ProcessingException exception : this._processingExceptions) {
                dataTable.addException(exception);
            }
        }
        return dataTable;
    }

    @Override
    public BlockDocIdSet getBlockDocIdSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockValSet getBlockValueSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockDocIdValueSet getBlockDocIdValueSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockMetadata getMetadata() {
        throw new UnsupportedOperationException();
    }
}

